/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.image.ClientQuotaImage;

public final class ClientQuotaDelta {
    private final ClientQuotaImage image;
    private final Map<String, OptionalDouble> changes = new HashMap<String, OptionalDouble>();

    public ClientQuotaDelta(ClientQuotaImage image) {
        this.image = image;
    }

    public Map<String, OptionalDouble> changes() {
        return this.changes;
    }

    public void finishSnapshot() {
        for (String key : this.image.quotas().keySet()) {
            if (this.changes.containsKey(key)) continue;
            this.changes.put(key, OptionalDouble.empty());
        }
    }

    public void replay(ClientQuotaRecord record) {
        if (record.remove()) {
            this.changes.put(record.key(), OptionalDouble.empty());
        } else {
            this.changes.put(record.key(), OptionalDouble.of(record.value()));
        }
    }

    public ClientQuotaImage apply() {
        HashMap<String, Double> newQuotas = new HashMap<String, Double>(this.image.quotas().size());
        for (Map.Entry<String, Double> entry : this.image.quotas().entrySet()) {
            OptionalDouble change = this.changes.get(entry.getKey());
            if (change == null) {
                newQuotas.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!change.isPresent()) continue;
            newQuotas.put(entry.getKey(), change.getAsDouble());
        }
        for (Map.Entry<String, Object> entry : this.changes.entrySet()) {
            if (newQuotas.containsKey(entry.getKey()) || !((OptionalDouble)entry.getValue()).isPresent()) continue;
            newQuotas.put(entry.getKey(), ((OptionalDouble)entry.getValue()).getAsDouble());
        }
        return new ClientQuotaImage(newQuotas);
    }
}

