/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ConfigurationControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ConfigurationControlManagerTest {
    static final Map<ConfigResource.Type, ConfigDef> CONFIGS = new HashMap<ConfigResource.Type, ConfigDef>();
    static final ConfigResource BROKER0;
    static final ConfigResource MYTOPIC;

    private static <A, B> Map<A, B> toMap(Map.Entry ... entries) {
        HashMap map = new HashMap();
        for (Map.Entry entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    static <A, B> Map.Entry<A, B> entry(A a, B b) {
        return new AbstractMap.SimpleImmutableEntry<A, B>(a, b);
    }

    @Test
    public void testReplay() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ConfigurationControlManager manager = new ConfigurationControlManager(new LogContext(), snapshotRegistry, CONFIGS);
        Assertions.assertEquals(Collections.emptyMap(), (Object)manager.getConfigs(BROKER0));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("foo.bar").setValue("1,2"));
        Assertions.assertEquals(Collections.singletonMap("foo.bar", "1,2"), (Object)manager.getConfigs(BROKER0));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("foo.bar").setValue(null));
        Assertions.assertEquals(Collections.emptyMap(), (Object)manager.getConfigs(BROKER0));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("x,y,z"));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("def").setValue("blah"));
        Assertions.assertEquals(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", "x,y,z"), ConfigurationControlManagerTest.entry("def", "blah")), (Object)manager.getConfigs(MYTOPIC));
    }

    @Test
    public void testCheckConfigResource() {
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Unsupported configuration resource type BROKER_LOGGER ").toString(), (Object)ConfigurationControlManager.checkConfigResource((ConfigResource)new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "kafka.server.FetchContext")).toString());
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Illegal topic name.").toString(), (Object)ConfigurationControlManager.checkConfigResource((ConfigResource)new ConfigResource(ConfigResource.Type.TOPIC, "* @ invalid$")).toString());
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Illegal topic name.").toString(), (Object)ConfigurationControlManager.checkConfigResource((ConfigResource)new ConfigResource(ConfigResource.Type.TOPIC, "")).toString());
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Illegal non-integral BROKER resource type name.").toString(), (Object)ConfigurationControlManager.checkConfigResource((ConfigResource)new ConfigResource(ConfigResource.Type.BROKER, "bob")).toString());
        Assertions.assertEquals((Object)new ApiError(Errors.NONE, null).toString(), (Object)ConfigurationControlManager.checkConfigResource((ConfigResource)new ConfigResource(ConfigResource.Type.BROKER, "")).toString());
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Unsupported configuration resource type UNKNOWN.").toString(), (Object)ConfigurationControlManager.checkConfigResource((ConfigResource)new ConfigResource(ConfigResource.Type.UNKNOWN, "bob")).toString());
    }

    @Test
    public void testIncrementalAlterConfigs() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ConfigurationControlManager manager = new ConfigurationControlManager(new LogContext(), snapshotRegistry, CONFIGS);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("123"), 0)), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(BROKER0, new ApiError(Errors.INVALID_REQUEST, "A DELETE op was given with a non-null value.")), ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(BROKER0, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("foo.bar", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.DELETE, "abc")), ConfigurationControlManagerTest.entry("quux", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "abc")))), ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.APPEND, "123")))))));
    }

    @Test
    public void testIsSplittable() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ConfigurationControlManager manager = new ConfigurationControlManager(new LogContext(), snapshotRegistry, CONFIGS);
        Assertions.assertTrue((boolean)manager.isSplittable(ConfigResource.Type.BROKER, "foo.bar"));
        Assertions.assertFalse((boolean)manager.isSplittable(ConfigResource.Type.BROKER, "baz"));
        Assertions.assertFalse((boolean)manager.isSplittable(ConfigResource.Type.BROKER, "foo.baz.quux"));
        Assertions.assertFalse((boolean)manager.isSplittable(ConfigResource.Type.TOPIC, "baz"));
        Assertions.assertTrue((boolean)manager.isSplittable(ConfigResource.Type.TOPIC, "abc"));
    }

    @Test
    public void testGetConfigValueDefault() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ConfigurationControlManager manager = new ConfigurationControlManager(new LogContext(), snapshotRegistry, CONFIGS);
        Assertions.assertEquals((Object)"1", (Object)manager.getConfigValueDefault(ConfigResource.Type.BROKER, "foo.bar"));
        Assertions.assertEquals(null, (Object)manager.getConfigValueDefault(ConfigResource.Type.BROKER, "foo.baz.quux"));
        Assertions.assertEquals(null, (Object)manager.getConfigValueDefault(ConfigResource.Type.TOPIC, "abc"));
        Assertions.assertEquals((Object)"true", (Object)manager.getConfigValueDefault(ConfigResource.Type.TOPIC, "ghi"));
    }

    @Test
    public void testLegacyAlterConfigs() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ConfigurationControlManager manager = new ConfigurationControlManager(new LogContext(), snapshotRegistry, CONFIGS);
        List<ApiMessageAndVersion> expectedRecords1 = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("456"), 0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("def").setValue("901"), 0));
        Assertions.assertEquals((Object)ControllerResult.atomicOf(expectedRecords1, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)manager.legacyAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", "456"), ConfigurationControlManagerTest.entry("def", "901"))))));
        for (ApiMessageAndVersion message : expectedRecords1) {
            manager.replay((ConfigRecord)message.message());
        }
        Assertions.assertEquals((Object)ControllerResult.atomicOf(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue(null), 0)), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)manager.legacyAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("def", "901"))))));
    }

    static {
        CONFIGS.put(ConfigResource.Type.BROKER, new ConfigDef().define("foo.bar", ConfigDef.Type.LIST, (Object)"1", ConfigDef.Importance.HIGH, "foo bar").define("baz", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "baz").define("quux", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "quux"));
        CONFIGS.put(ConfigResource.Type.TOPIC, new ConfigDef().define("abc", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "abc").define("def", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "def").define("ghi", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.HIGH, "ghi"));
        BROKER0 = new ConfigResource(ConfigResource.Type.BROKER, "0");
        MYTOPIC = new ConfigResource(ConfigResource.Type.TOPIC, "mytopic");
    }
}

