/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metalog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metalog.LocalLogManager;
import org.apache.kafka.metalog.MetaLogLeader;
import org.apache.kafka.metalog.MockMetaLogManagerListener;
import org.apache.kafka.test.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalLogManagerTestEnv
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(LocalLogManagerTestEnv.class);
    final AtomicReference<String> firstError = new AtomicReference<Object>(null);
    private final File dir = TestUtils.tempDirectory();
    private final LocalLogManager.SharedLogData shared = new LocalLogManager.SharedLogData();
    private final List<LocalLogManager> logManagers;

    public static LocalLogManagerTestEnv createWithMockListeners(int numManagers) throws Exception {
        LocalLogManagerTestEnv testEnv = new LocalLogManagerTestEnv(numManagers);
        try {
            for (LocalLogManager logManager : testEnv.logManagers) {
                logManager.register(new MockMetaLogManagerListener());
            }
        }
        catch (Exception e) {
            testEnv.close();
            throw e;
        }
        return testEnv;
    }

    public LocalLogManagerTestEnv(int numManagers) throws Exception {
        ArrayList<LocalLogManager> newLogManagers = new ArrayList<LocalLogManager>(numManagers);
        try {
            for (int nodeId = 0; nodeId < numManagers; ++nodeId) {
                newLogManagers.add(new LocalLogManager(new LogContext(String.format("[LocalLogManager %d] ", nodeId)), nodeId, this.shared, String.format("LocalLogManager-%d_", nodeId)));
            }
            for (LocalLogManager logManager : newLogManagers) {
                logManager.initialize();
            }
        }
        catch (Throwable t) {
            for (LocalLogManager logManager : newLogManagers) {
                logManager.close();
            }
            throw t;
        }
        this.logManagers = newLogManagers;
    }

    AtomicReference<String> firstError() {
        return this.firstError;
    }

    File dir() {
        return this.dir;
    }

    MetaLogLeader waitForLeader() throws InterruptedException {
        AtomicReference<Object> value = new AtomicReference<Object>(null);
        TestUtils.retryOnExceptionWithTimeout((long)2000L, (long)3L, () -> {
            MetaLogLeader result = null;
            for (LocalLogManager logManager : this.logManagers) {
                MetaLogLeader leader = logManager.leader();
                if (leader.nodeId() != logManager.nodeId()) continue;
                if (result != null) {
                    throw new RuntimeException("node " + leader.nodeId() + " thinks it's the leader, but so does " + result.nodeId());
                }
                result = leader;
            }
            if (result == null) {
                throw new RuntimeException("No leader found.");
            }
            value.set(result);
        });
        return value.get();
    }

    public List<LocalLogManager> logManagers() {
        return this.logManagers;
    }

    @Override
    public void close() throws InterruptedException {
        try {
            for (LocalLogManager logManager : this.logManagers) {
                logManager.beginShutdown();
            }
            for (LocalLogManager logManager : this.logManagers) {
                logManager.close();
            }
            Utils.delete((File)this.dir);
        }
        catch (IOException e) {
            log.error("Error deleting {}", (Object)this.dir.getAbsolutePath(), (Object)e);
        }
    }
}

