/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.message.AlterIsrResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.BrokersToIsrs;
import org.apache.kafka.controller.ClusterControlManager;
import org.apache.kafka.controller.ConfigurationControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.ControllerTestUtils;
import org.apache.kafka.controller.MockRandom;
import org.apache.kafka.controller.ReplicaPlacementPolicy;
import org.apache.kafka.controller.Replicas;
import org.apache.kafka.controller.ReplicationControlManager;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.controller.SimpleReplicaPlacementPolicy;
import org.apache.kafka.metadata.ApiMessageAndVersion;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ReplicationControlManagerTest {
    private static void registerBroker(int brokerId, ReplicationControlTestContext ctx) {
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(brokerId + 100).setBrokerId(brokerId);
        brokerRecord.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092 + brokerId).setName("PLAINTEXT").setHost("localhost"));
        ctx.clusterControl.replay(brokerRecord);
    }

    private static void unfenceBroker(int brokerId, ReplicationControlTestContext ctx) throws Exception {
        ControllerResult result = ctx.replicationControl.processBrokerHeartbeat(new BrokerHeartbeatRequestData().setBrokerId(brokerId).setBrokerEpoch((long)(brokerId + 100)).setCurrentMetadataOffset(1L).setWantFence(false).setWantShutDown(false), 0L);
        Assertions.assertEquals((Object)new BrokerHeartbeatReply(true, false, false, false), (Object)result.response());
        ControllerTestUtils.replayAll(ctx.clusterControl, result.records());
    }

    @Test
    public void testCreateTopics() throws Exception {
        ReplicationControlTestContext ctx = new ReplicationControlTestContext();
        ReplicationControlManager replicationControl = ctx.replicationControl;
        CreateTopicsRequestData request = new CreateTopicsRequestData();
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName("foo").setNumPartitions(-1).setReplicationFactor((short)-1));
        ControllerResult result = replicationControl.createTopics(request);
        CreateTopicsResponseData expectedResponse = new CreateTopicsResponseData();
        expectedResponse.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName("foo").setErrorCode(Errors.INVALID_REPLICATION_FACTOR.code()).setErrorMessage("Unable to replicate the partition 3 times: there are only 0 usable brokers"));
        Assertions.assertEquals((Object)expectedResponse, (Object)result.response());
        ReplicationControlManagerTest.registerBroker(0, ctx);
        ReplicationControlManagerTest.unfenceBroker(0, ctx);
        ReplicationControlManagerTest.registerBroker(1, ctx);
        ReplicationControlManagerTest.unfenceBroker(1, ctx);
        ReplicationControlManagerTest.registerBroker(2, ctx);
        ReplicationControlManagerTest.unfenceBroker(2, ctx);
        ControllerResult result2 = replicationControl.createTopics(request);
        CreateTopicsResponseData expectedResponse2 = new CreateTopicsResponseData();
        expectedResponse2.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName("foo").setNumPartitions(1).setReplicationFactor((short)3).setErrorMessage(null).setErrorCode((short)0).setTopicId(((CreateTopicsResponseData)result2.response()).topics().find("foo").topicId()));
        Assertions.assertEquals((Object)expectedResponse2, (Object)result2.response());
        ControllerTestUtils.replayAll(replicationControl, result2.records());
        Assertions.assertEquals((Object)new ReplicationControlManager.PartitionControlInfo(new int[]{2, 0, 1}, new int[]{2, 0, 1}, null, null, 2, 0, 0), (Object)replicationControl.getPartition(((TopicRecord)((ApiMessageAndVersion)result2.records().get(0)).message()).topicId(), 0));
        ControllerResult result3 = replicationControl.createTopics(request);
        CreateTopicsResponseData expectedResponse3 = new CreateTopicsResponseData();
        expectedResponse3.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName("foo").setErrorCode(Errors.TOPIC_ALREADY_EXISTS.code()).setErrorMessage(Errors.TOPIC_ALREADY_EXISTS.exception().getMessage()));
        Assertions.assertEquals((Object)expectedResponse3, (Object)result3.response());
    }

    @Test
    public void testValidateNewTopicNames() {
        HashMap topicErrors = new HashMap();
        CreateTopicsRequestData.CreatableTopicCollection topics = new CreateTopicsRequestData.CreatableTopicCollection();
        topics.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName(""));
        topics.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName("woo"));
        topics.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName("."));
        ReplicationControlManager.validateNewTopicNames(topicErrors, (CreateTopicsRequestData.CreatableTopicCollection)topics);
        HashMap<String, ApiError> expectedTopicErrors = new HashMap<String, ApiError>();
        expectedTopicErrors.put("", new ApiError(Errors.INVALID_TOPIC_EXCEPTION, "Topic name is illegal, it can't be empty"));
        expectedTopicErrors.put(".", new ApiError(Errors.INVALID_TOPIC_EXCEPTION, "Topic name cannot be \".\" or \"..\""));
        Assertions.assertEquals(expectedTopicErrors, topicErrors);
    }

    private static CreateTopicsResponseData.CreatableTopicResult createTestTopic(ReplicationControlManager replicationControl, String name, int[][] replicas) throws Exception {
        Assertions.assertFalse((replicas.length == 0 ? 1 : 0) != 0);
        CreateTopicsRequestData request = new CreateTopicsRequestData();
        CreateTopicsRequestData.CreatableTopic topic = new CreateTopicsRequestData.CreatableTopic().setName(name);
        topic.setNumPartitions(-1).setReplicationFactor((short)-1);
        for (int i = 0; i < replicas.length; ++i) {
            topic.assignments().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableReplicaAssignment().setPartitionIndex(i).setBrokerIds(Replicas.toList((int[])replicas[i])));
        }
        request.topics().add((ImplicitLinkedHashCollection.Element)topic);
        ControllerResult result = replicationControl.createTopics(request);
        CreateTopicsResponseData.CreatableTopicResult topicResult = ((CreateTopicsResponseData)result.response()).topics().find(name);
        Assertions.assertNotNull((Object)topicResult);
        Assertions.assertEquals((short)0, (short)topicResult.errorCode());
        Assertions.assertEquals((int)replicas.length, (int)topicResult.numPartitions());
        Assertions.assertEquals((int)replicas[0].length, (int)topicResult.replicationFactor());
        ControllerTestUtils.replayAll(replicationControl, result.records());
        return topicResult;
    }

    @Test
    public void testRemoveLeaderships() throws Exception {
        ReplicationControlTestContext ctx = new ReplicationControlTestContext();
        ReplicationControlManager replicationControl = ctx.replicationControl;
        for (int i = 0; i < 6; ++i) {
            ReplicationControlManagerTest.registerBroker(i, ctx);
            ReplicationControlManagerTest.unfenceBroker(i, ctx);
        }
        CreateTopicsResponseData.CreatableTopicResult result = ReplicationControlManagerTest.createTestTopic(replicationControl, "foo", new int[][]{{0, 1, 2}, {1, 2, 3}, {2, 3, 0}, {0, 2, 1}});
        HashSet<BrokersToIsrs.TopicIdPartition> expectedPartitions = new HashSet<BrokersToIsrs.TopicIdPartition>();
        expectedPartitions.add(new BrokersToIsrs.TopicIdPartition(result.topicId(), 0));
        expectedPartitions.add(new BrokersToIsrs.TopicIdPartition(result.topicId(), 3));
        Assertions.assertEquals(expectedPartitions, ControllerTestUtils.iteratorToSet(replicationControl.brokersToIsrs().iterator(0, true)));
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        replicationControl.handleNodeDeactivated(0, records);
        ControllerTestUtils.replayAll(replicationControl, records);
        Assertions.assertEquals(Collections.emptySet(), ControllerTestUtils.iteratorToSet(replicationControl.brokersToIsrs().iterator(0, true)));
    }

    @Test
    public void testShrinkAndExpandIsr() throws Exception {
        ReplicationControlTestContext ctx = new ReplicationControlTestContext();
        ReplicationControlManager replicationControl = ctx.replicationControl;
        for (int i = 0; i < 3; ++i) {
            ReplicationControlManagerTest.registerBroker(i, ctx);
            ReplicationControlManagerTest.unfenceBroker(i, ctx);
        }
        CreateTopicsResponseData.CreatableTopicResult createTopicResult = ReplicationControlManagerTest.createTestTopic(replicationControl, "foo", new int[][]{{0, 1, 2}});
        BrokersToIsrs.TopicIdPartition topicIdPartition = new BrokersToIsrs.TopicIdPartition(createTopicResult.topicId(), 0);
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        Assertions.assertEquals((Object)OptionalInt.of(0), (Object)this.currentLeader(replicationControl, topicIdPartition));
        long brokerEpoch = this.currentBrokerEpoch(ctx, 0);
        AlterIsrRequestData.PartitionData shrinkIsrRequest = this.newAlterIsrPartition(replicationControl, topicIdPartition, Arrays.asList(0, 1));
        ControllerResult<AlterIsrResponseData> shrinkIsrResult = this.sendAlterIsr(replicationControl, 0, brokerEpoch, "foo", shrinkIsrRequest);
        AlterIsrResponseData.PartitionData shrinkIsrResponse = this.assertAlterIsrResponse(shrinkIsrResult, topicPartition, Errors.NONE);
        this.assertConsistentAlterIsrResponse(replicationControl, topicIdPartition, shrinkIsrResponse);
        AlterIsrRequestData.PartitionData expandIsrRequest = this.newAlterIsrPartition(replicationControl, topicIdPartition, Arrays.asList(0, 1, 2));
        ControllerResult<AlterIsrResponseData> expandIsrResult = this.sendAlterIsr(replicationControl, 0, brokerEpoch, "foo", expandIsrRequest);
        AlterIsrResponseData.PartitionData expandIsrResponse = this.assertAlterIsrResponse(expandIsrResult, topicPartition, Errors.NONE);
        this.assertConsistentAlterIsrResponse(replicationControl, topicIdPartition, expandIsrResponse);
    }

    @Test
    public void testInvalidAlterIsrRequests() throws Exception {
        ReplicationControlTestContext ctx = new ReplicationControlTestContext();
        ReplicationControlManager replicationControl = ctx.replicationControl;
        for (int i = 0; i < 3; ++i) {
            ReplicationControlManagerTest.registerBroker(i, ctx);
            ReplicationControlManagerTest.unfenceBroker(i, ctx);
        }
        CreateTopicsResponseData.CreatableTopicResult createTopicResult = ReplicationControlManagerTest.createTestTopic(replicationControl, "foo", new int[][]{{0, 1, 2}});
        BrokersToIsrs.TopicIdPartition topicIdPartition = new BrokersToIsrs.TopicIdPartition(createTopicResult.topicId(), 0);
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        Assertions.assertEquals((Object)OptionalInt.of(0), (Object)this.currentLeader(replicationControl, topicIdPartition));
        long brokerEpoch = this.currentBrokerEpoch(ctx, 0);
        AlterIsrRequestData.PartitionData invalidLeaderRequest = this.newAlterIsrPartition(replicationControl, topicIdPartition, Arrays.asList(0, 1));
        ControllerResult<AlterIsrResponseData> invalidLeaderResult = this.sendAlterIsr(replicationControl, 1, this.currentBrokerEpoch(ctx, 1), "foo", invalidLeaderRequest);
        this.assertAlterIsrResponse(invalidLeaderResult, topicPartition, Errors.INVALID_REQUEST);
        AlterIsrRequestData.PartitionData invalidBrokerEpochRequest = this.newAlterIsrPartition(replicationControl, topicIdPartition, Arrays.asList(0, 1));
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> this.sendAlterIsr(replicationControl, 0, brokerEpoch - 1L, "foo", invalidBrokerEpochRequest));
        AlterIsrRequestData.PartitionData invalidLeaderEpochRequest = this.newAlterIsrPartition(replicationControl, topicIdPartition, Arrays.asList(0, 1));
        invalidLeaderEpochRequest.setLeaderEpoch(500);
        ControllerResult<AlterIsrResponseData> invalidLeaderEpochResult = this.sendAlterIsr(replicationControl, 1, this.currentBrokerEpoch(ctx, 1), "foo", invalidLeaderEpochRequest);
        this.assertAlterIsrResponse(invalidLeaderEpochResult, topicPartition, Errors.INVALID_REQUEST);
        AlterIsrRequestData.PartitionData invalidIsrRequest1 = this.newAlterIsrPartition(replicationControl, topicIdPartition, Arrays.asList(0, 1));
        invalidIsrRequest1.setNewIsr(Arrays.asList(0, 1, 3));
        ControllerResult<AlterIsrResponseData> invalidIsrResult1 = this.sendAlterIsr(replicationControl, 1, this.currentBrokerEpoch(ctx, 1), "foo", invalidIsrRequest1);
        this.assertAlterIsrResponse(invalidIsrResult1, topicPartition, Errors.INVALID_REQUEST);
        AlterIsrRequestData.PartitionData invalidIsrRequest2 = this.newAlterIsrPartition(replicationControl, topicIdPartition, Arrays.asList(0, 1));
        invalidIsrRequest2.setNewIsr(Arrays.asList(1, 2));
        ControllerResult<AlterIsrResponseData> invalidIsrResult2 = this.sendAlterIsr(replicationControl, 1, this.currentBrokerEpoch(ctx, 1), "foo", invalidIsrRequest2);
        this.assertAlterIsrResponse(invalidIsrResult2, topicPartition, Errors.INVALID_REQUEST);
    }

    private long currentBrokerEpoch(ReplicationControlTestContext ctx, int brokerId) {
        Map registrations = ctx.clusterControl.brokerRegistrations();
        BrokerRegistration registration = (BrokerRegistration)registrations.get(brokerId);
        Assertions.assertNotNull((Object)registration, (String)("No current registration for broker " + brokerId));
        return registration.epoch();
    }

    private OptionalInt currentLeader(ReplicationControlManager replicationControl, BrokersToIsrs.TopicIdPartition topicIdPartition) {
        ReplicationControlManager.PartitionControlInfo partitionControl = replicationControl.getPartition(topicIdPartition.topicId(), topicIdPartition.partitionId());
        if (partitionControl.leader < 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(partitionControl.leader);
    }

    private AlterIsrRequestData.PartitionData newAlterIsrPartition(ReplicationControlManager replicationControl, BrokersToIsrs.TopicIdPartition topicIdPartition, List<Integer> newIsr) {
        ReplicationControlManager.PartitionControlInfo partitionControl = replicationControl.getPartition(topicIdPartition.topicId(), topicIdPartition.partitionId());
        return new AlterIsrRequestData.PartitionData().setPartitionIndex(0).setLeaderEpoch(partitionControl.leaderEpoch).setCurrentIsrVersion(partitionControl.partitionEpoch).setNewIsr(newIsr);
    }

    private ControllerResult<AlterIsrResponseData> sendAlterIsr(ReplicationControlManager replicationControl, int brokerId, long brokerEpoch, String topic, AlterIsrRequestData.PartitionData partitionData) throws Exception {
        AlterIsrRequestData request = new AlterIsrRequestData().setBrokerId(brokerId).setBrokerEpoch(brokerEpoch);
        AlterIsrRequestData.TopicData topicData = new AlterIsrRequestData.TopicData().setName(topic);
        request.topics().add(topicData);
        topicData.partitions().add(partitionData);
        ControllerResult result = replicationControl.alterIsr(request);
        ControllerTestUtils.replayAll(replicationControl, result.records());
        return result;
    }

    private AlterIsrResponseData.PartitionData assertAlterIsrResponse(ControllerResult<AlterIsrResponseData> alterIsrResult, TopicPartition topicPartition, Errors expectedError) {
        AlterIsrResponseData response = (AlterIsrResponseData)alterIsrResult.response();
        Assertions.assertEquals((int)1, (int)response.topics().size());
        AlterIsrResponseData.TopicData topicData = (AlterIsrResponseData.TopicData)response.topics().get(0);
        Assertions.assertEquals((Object)topicPartition.topic(), (Object)topicData.name());
        Assertions.assertEquals((int)1, (int)topicData.partitions().size());
        AlterIsrResponseData.PartitionData partitionData = (AlterIsrResponseData.PartitionData)topicData.partitions().get(0);
        Assertions.assertEquals((int)topicPartition.partition(), (int)partitionData.partitionIndex());
        Assertions.assertEquals((Object)expectedError, (Object)Errors.forCode((short)partitionData.errorCode()));
        return partitionData;
    }

    private void assertConsistentAlterIsrResponse(ReplicationControlManager replicationControl, BrokersToIsrs.TopicIdPartition topicIdPartition, AlterIsrResponseData.PartitionData partitionData) {
        ReplicationControlManager.PartitionControlInfo partitionControl = replicationControl.getPartition(topicIdPartition.topicId(), topicIdPartition.partitionId());
        Assertions.assertEquals((int)partitionControl.leader, (int)partitionData.leaderId());
        Assertions.assertEquals((int)partitionControl.leaderEpoch, (int)partitionData.leaderEpoch());
        Assertions.assertEquals((int)partitionControl.partitionEpoch, (int)partitionData.currentIsrVersion());
        List expectedIsr = IntStream.of(partitionControl.isr).boxed().collect(Collectors.toList());
        Assertions.assertEquals(expectedIsr, (Object)partitionData.isr());
    }

    private void assertCreatedTopicConfigs(ReplicationControlTestContext ctx, String topic, CreateTopicsRequestData.CreateableTopicConfigCollection requestConfigs) {
        Map configs = ctx.configurationControl.getConfigs(new ConfigResource(ConfigResource.Type.TOPIC, topic));
        Assertions.assertEquals((int)requestConfigs.size(), (int)configs.size());
        for (CreateTopicsRequestData.CreateableTopicConfig requestConfig : requestConfigs) {
            String value = (String)configs.get(requestConfig.name());
            Assertions.assertEquals((Object)requestConfig.value(), (Object)value);
        }
    }

    private void assertEmptyTopicConfigs(ReplicationControlTestContext ctx, String topic) {
        Map configs = ctx.configurationControl.getConfigs(new ConfigResource(ConfigResource.Type.TOPIC, topic));
        Assertions.assertEquals(Collections.emptyMap(), (Object)configs);
    }

    @Test
    public void testDeleteTopics() throws Exception {
        ReplicationControlTestContext ctx = new ReplicationControlTestContext();
        ReplicationControlManager replicationControl = ctx.replicationControl;
        CreateTopicsRequestData request = new CreateTopicsRequestData();
        CreateTopicsRequestData.CreateableTopicConfigCollection requestConfigs = new CreateTopicsRequestData.CreateableTopicConfigCollection();
        requestConfigs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("cleanup.policy").setValue("compact"));
        requestConfigs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("min.cleanable.dirty.ratio").setValue("0.1"));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName("foo").setNumPartitions(3).setReplicationFactor((short)2).setConfigs(requestConfigs));
        ReplicationControlManagerTest.registerBroker(0, ctx);
        ReplicationControlManagerTest.unfenceBroker(0, ctx);
        ReplicationControlManagerTest.registerBroker(1, ctx);
        ReplicationControlManagerTest.unfenceBroker(1, ctx);
        ControllerResult createResult = replicationControl.createTopics(request);
        CreateTopicsResponseData expectedResponse = new CreateTopicsResponseData();
        Uuid topicId = ((CreateTopicsResponseData)createResult.response()).topics().find("foo").topicId();
        expectedResponse.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName("foo").setNumPartitions(3).setReplicationFactor((short)2).setErrorMessage(null).setErrorCode((short)0).setTopicId(topicId));
        Assertions.assertEquals((Object)expectedResponse, (Object)createResult.response());
        Assertions.assertNull((Object)replicationControl.getPartition(topicId, 0));
        this.assertEmptyTopicConfigs(ctx, "foo");
        ctx.replay(createResult.records());
        Assertions.assertNotNull((Object)replicationControl.getPartition(topicId, 0));
        Assertions.assertNotNull((Object)replicationControl.getPartition(topicId, 1));
        Assertions.assertNotNull((Object)replicationControl.getPartition(topicId, 2));
        Assertions.assertNull((Object)replicationControl.getPartition(topicId, 3));
        this.assertCreatedTopicConfigs(ctx, "foo", requestConfigs);
        Assertions.assertEquals(Collections.singletonMap(topicId, new ResultOrError((Object)"foo")), (Object)replicationControl.findTopicNames(Long.MAX_VALUE, Collections.singleton(topicId)));
        Assertions.assertEquals(Collections.singletonMap("foo", new ResultOrError((Object)topicId)), (Object)replicationControl.findTopicIds(Long.MAX_VALUE, Collections.singleton("foo")));
        Uuid invalidId = new Uuid(topicId.getMostSignificantBits() + 1L, topicId.getLeastSignificantBits());
        Assertions.assertEquals(Collections.singletonMap(invalidId, new ResultOrError(new ApiError(Errors.UNKNOWN_TOPIC_ID))), (Object)replicationControl.findTopicNames(Long.MAX_VALUE, Collections.singleton(invalidId)));
        Assertions.assertEquals(Collections.singletonMap("bar", new ResultOrError(new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION))), (Object)replicationControl.findTopicIds(Long.MAX_VALUE, Collections.singleton("bar")));
        ControllerResult invalidDeleteResult = replicationControl.deleteTopics(Collections.singletonList(invalidId));
        Assertions.assertEquals((int)0, (int)invalidDeleteResult.records().size());
        Assertions.assertEquals(Collections.singletonMap(invalidId, new ApiError(Errors.UNKNOWN_TOPIC_ID, null)), (Object)invalidDeleteResult.response());
        ControllerResult deleteResult = replicationControl.deleteTopics(Collections.singletonList(topicId));
        Assertions.assertTrue((boolean)deleteResult.isAtomic());
        Assertions.assertEquals(Collections.singletonMap(topicId, new ApiError(Errors.NONE, null)), (Object)deleteResult.response());
        Assertions.assertEquals((int)1, (int)deleteResult.records().size());
        ctx.replay(deleteResult.records());
        Assertions.assertNull((Object)replicationControl.getPartition(topicId, 0));
        Assertions.assertNull((Object)replicationControl.getPartition(topicId, 1));
        Assertions.assertNull((Object)replicationControl.getPartition(topicId, 2));
        Assertions.assertNull((Object)replicationControl.getPartition(topicId, 3));
        Assertions.assertEquals(Collections.singletonMap(topicId, new ResultOrError(new ApiError(Errors.UNKNOWN_TOPIC_ID))), (Object)replicationControl.findTopicNames(Long.MAX_VALUE, Collections.singleton(topicId)));
        Assertions.assertEquals(Collections.singletonMap("foo", new ResultOrError(new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION))), (Object)replicationControl.findTopicIds(Long.MAX_VALUE, Collections.singleton("foo")));
        this.assertEmptyTopicConfigs(ctx, "foo");
    }

    private static class ReplicationControlTestContext {
        final SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        final LogContext logContext = new LogContext();
        final MockTime time = new MockTime();
        final MockRandom random = new MockRandom();
        final ClusterControlManager clusterControl = new ClusterControlManager(this.logContext, (Time)this.time, this.snapshotRegistry, 1000L, (ReplicaPlacementPolicy)new SimpleReplicaPlacementPolicy((Random)this.random));
        final ConfigurationControlManager configurationControl = new ConfigurationControlManager(new LogContext(), this.snapshotRegistry, Collections.emptyMap());
        final ReplicationControlManager replicationControl = new ReplicationControlManager(this.snapshotRegistry, new LogContext(), 3, 1, this.configurationControl, this.clusterControl);

        void replay(List<ApiMessageAndVersion> records) throws Exception {
            ControllerTestUtils.replayAll(this.clusterControl, records);
            ControllerTestUtils.replayAll(this.configurationControl, records);
            ControllerTestUtils.replayAll(this.replicationControl, records);
        }

        ReplicationControlTestContext() {
            this.clusterControl.activate();
        }
    }
}

