/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.controller.BrokersToIsrs;
import org.apache.kafka.controller.ConfigurationControlManagerTest;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumControllerTestEnv;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.metalog.LocalLogManagerTestEnv;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=40L)
public class QuorumControllerTest {
    private static final Logger log = LoggerFactory.getLogger(QuorumControllerTest.class);

    @Test
    public void testCreateAndClose() throws Throwable {
        try (LocalLogManagerTestEnv logEnv = new LocalLogManagerTestEnv(1);){
            QuorumControllerTestEnv controlEnv = new QuorumControllerTestEnv(logEnv, __ -> {});
            Throwable throwable = null;
            if (controlEnv != null) {
                if (throwable != null) {
                    try {
                        controlEnv.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    controlEnv.close();
                }
            }
        }
    }

    @Test
    public void testConfigurationOperations() throws Throwable {
        try (LocalLogManagerTestEnv logEnv = new LocalLogManagerTestEnv(1);
             QuorumControllerTestEnv controlEnv = new QuorumControllerTestEnv(logEnv, b -> b.setConfigDefs(ConfigurationControlManagerTest.CONFIGS));){
            this.testConfigurationOperations(controlEnv.activeController());
        }
    }

    private void testConfigurationOperations(QuorumController controller) throws Throwable {
        Assertions.assertEquals(Collections.singletonMap(ConfigurationControlManagerTest.BROKER0, ApiError.NONE), controller.incrementalAlterConfigs(Collections.singletonMap(ConfigurationControlManagerTest.BROKER0, Collections.singletonMap("baz", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "123"))), true).get());
        Assertions.assertEquals(Collections.singletonMap(ConfigurationControlManagerTest.BROKER0, new ResultOrError(Collections.emptyMap())), controller.describeConfigs(Collections.singletonMap(ConfigurationControlManagerTest.BROKER0, Collections.emptyList())).get());
        Assertions.assertEquals(Collections.singletonMap(ConfigurationControlManagerTest.BROKER0, ApiError.NONE), controller.incrementalAlterConfigs(Collections.singletonMap(ConfigurationControlManagerTest.BROKER0, Collections.singletonMap("baz", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "123"))), false).get());
        Assertions.assertEquals(Collections.singletonMap(ConfigurationControlManagerTest.BROKER0, new ResultOrError(Collections.singletonMap("baz", "123"))), controller.describeConfigs(Collections.singletonMap(ConfigurationControlManagerTest.BROKER0, Collections.emptyList())).get());
    }

    @Test
    public void testDelayedConfigurationOperations() throws Throwable {
        try (LocalLogManagerTestEnv logEnv = new LocalLogManagerTestEnv(1);
             QuorumControllerTestEnv controlEnv = new QuorumControllerTestEnv(logEnv, b -> b.setConfigDefs(ConfigurationControlManagerTest.CONFIGS));){
            this.testDelayedConfigurationOperations(logEnv, controlEnv.activeController());
        }
    }

    private void testDelayedConfigurationOperations(LocalLogManagerTestEnv logEnv, QuorumController controller) throws Throwable {
        logEnv.logManagers().forEach(m -> m.setMaxReadOffset(0L));
        CompletableFuture future1 = controller.incrementalAlterConfigs(Collections.singletonMap(ConfigurationControlManagerTest.BROKER0, Collections.singletonMap("baz", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "123"))), false);
        Assertions.assertFalse((boolean)future1.isDone());
        Assertions.assertEquals(Collections.singletonMap(ConfigurationControlManagerTest.BROKER0, new ResultOrError(Collections.emptyMap())), controller.describeConfigs(Collections.singletonMap(ConfigurationControlManagerTest.BROKER0, Collections.emptyList())).get());
        logEnv.logManagers().forEach(m -> m.setMaxReadOffset(1L));
        Assertions.assertEquals(Collections.singletonMap(ConfigurationControlManagerTest.BROKER0, ApiError.NONE), future1.get());
    }

    @Test
    public void testUnregisterBroker() throws Throwable {
        try (LocalLogManagerTestEnv logEnv = new LocalLogManagerTestEnv(1);
             QuorumControllerTestEnv controlEnv = new QuorumControllerTestEnv(logEnv, b -> b.setConfigDefs(ConfigurationControlManagerTest.CONFIGS));){
            BrokerRegistrationRequestData.ListenerCollection listeners = new BrokerRegistrationRequestData.ListenerCollection();
            listeners.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Listener().setName("PLAINTEXT").setHost("localhost").setPort(9092));
            QuorumController active = controlEnv.activeController();
            CompletableFuture reply = active.registerBroker(new BrokerRegistrationRequestData().setBrokerId(0).setClusterId("06B-K3N1TBCNYFgruEVP0Q").setIncarnationId(Uuid.fromString((String)"kxAT73dKQsitIedpiPtwBA")).setListeners(listeners));
            Assertions.assertEquals((long)0L, (long)((BrokerRegistrationReply)reply.get()).epoch());
            CreateTopicsRequestData createTopicsRequestData = new CreateTopicsRequestData().setTopics(new CreateTopicsRequestData.CreatableTopicCollection(Collections.singleton(new CreateTopicsRequestData.CreatableTopic().setName("foo").setNumPartitions(1).setReplicationFactor((short)1)).iterator()));
            Assertions.assertEquals((short)Errors.INVALID_REPLICATION_FACTOR.code(), (short)((CreateTopicsResponseData)active.createTopics(createTopicsRequestData).get()).topics().find("foo").errorCode());
            Assertions.assertEquals((Object)new BrokerHeartbeatReply(true, false, false, false), active.processBrokerHeartbeat(new BrokerHeartbeatRequestData().setWantFence(false).setBrokerEpoch(0L).setBrokerId(0).setCurrentMetadataOffset(100000L)).get());
            Assertions.assertEquals((short)Errors.NONE.code(), (short)((CreateTopicsResponseData)active.createTopics(createTopicsRequestData).get()).topics().find("foo").errorCode());
            CompletableFuture topicPartitionFuture = active.appendReadEvent("debugGetPartition", () -> {
                BrokersToIsrs.PartitionsOnReplicaIterator iterator = active.replicationControl().brokersToIsrs().iterator(0, true);
                Assertions.assertTrue((boolean)iterator.hasNext());
                return (BrokersToIsrs.TopicIdPartition)iterator.next();
            });
            Assertions.assertEquals((int)0, (int)((BrokersToIsrs.TopicIdPartition)topicPartitionFuture.get()).partitionId());
            active.unregisterBroker(0).get();
            topicPartitionFuture = active.appendReadEvent("debugGetPartition", () -> {
                BrokersToIsrs.PartitionsOnReplicaIterator iterator = active.replicationControl().brokersToIsrs().noLeaderIterator();
                Assertions.assertTrue((boolean)iterator.hasNext());
                return (BrokersToIsrs.TopicIdPartition)iterator.next();
            });
            Assertions.assertEquals((int)0, (int)((BrokersToIsrs.TopicIdPartition)topicPartitionFuture.get()).partitionId());
        }
    }
}

