/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.metalog.LocalLogManagerTestEnv;
import org.apache.kafka.metalog.MetaLogManager;
import org.apache.kafka.test.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumControllerTestEnv
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(QuorumControllerTestEnv.class);
    private final List<QuorumController> controllers;

    public QuorumControllerTestEnv(LocalLogManagerTestEnv logEnv, Consumer<QuorumController.Builder> builderConsumer) throws Exception {
        int numControllers = logEnv.logManagers().size();
        this.controllers = new ArrayList<QuorumController>(numControllers);
        try {
            for (int i = 0; i < numControllers; ++i) {
                QuorumController.Builder builder = new QuorumController.Builder(i);
                builder.setLogManager((MetaLogManager)logEnv.logManagers().get(i));
                builderConsumer.accept(builder);
                this.controllers.add(builder.build());
            }
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    QuorumController activeController() throws InterruptedException {
        AtomicReference<Object> value = new AtomicReference<Object>(null);
        TestUtils.retryOnExceptionWithTimeout((long)3L, (long)20000L, () -> {
            QuorumController activeController = null;
            for (QuorumController controller : this.controllers) {
                if (!controller.isActive()) continue;
                if (activeController != null) {
                    throw new RuntimeException("node " + activeController.nodeId() + " thinks it's the leader, but so does " + controller.nodeId());
                }
                activeController = controller;
            }
            if (activeController == null) {
                throw new RuntimeException("No leader found.");
            }
            value.set(activeController);
        });
        return value.get();
    }

    public List<QuorumController> controllers() {
        return this.controllers;
    }

    @Override
    public void close() throws InterruptedException {
        for (QuorumController controller : this.controllers) {
            controller.beginShutdown();
        }
        for (QuorumController controller : this.controllers) {
            controller.close();
        }
    }
}

