/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.util;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.util.BatchFileReader;
import org.apache.kafka.metadata.util.BatchFileWriter;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class BatchFileWriterReaderTest {
    @Test
    public void testHeaderFooter() throws Exception {
        File tempFile = TestUtils.tempFile();
        Path tempPath = tempFile.toPath();
        tempFile.delete();
        try (BatchFileWriter writer = BatchFileWriter.open((Path)tempPath);){
            ApiMessageAndVersion message = new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("bar").setTopicId(Uuid.fromString((String)"cxBT72dK4si8Ied1iP4wBA")), 0);
            writer.append(message);
        }
        try (BatchFileReader reader = new BatchFileReader.Builder().setPath(tempPath.toString()).build();){
            long currentOffset = 0L;
            Assertions.assertTrue((boolean)reader.hasNext());
            BatchFileReader.BatchAndType batchAndType = reader.next();
            Assertions.assertTrue((boolean)batchAndType.isControl());
            Batch batch = batchAndType.batch();
            Assertions.assertEquals((long)currentOffset, (long)batch.baseOffset());
            Assertions.assertEquals((long)currentOffset, (long)batch.lastOffset());
            List records = batch.records();
            Assertions.assertEquals((int)1, (int)records.size());
            ApiMessageAndVersion apiMessageAndVersion = (ApiMessageAndVersion)records.get(0);
            Assertions.assertEquals((int)0, (int)apiMessageAndVersion.version());
            SnapshotHeaderRecord headerRecord = (SnapshotHeaderRecord)apiMessageAndVersion.message();
            Assertions.assertEquals((int)0, (int)headerRecord.version());
            Assertions.assertEquals((long)0L, (long)headerRecord.lastContainedLogTimestamp());
            Assertions.assertTrue((boolean)reader.hasNext());
            batchAndType = reader.next();
            Assertions.assertFalse((boolean)batchAndType.isControl());
            batch = batchAndType.batch();
            Assertions.assertEquals((long)(++currentOffset), (long)batch.baseOffset());
            Assertions.assertEquals((long)currentOffset, (long)batch.lastOffset());
            records = batch.records();
            Assertions.assertEquals((int)1, (int)records.size());
            apiMessageAndVersion = (ApiMessageAndVersion)records.get(0);
            Assertions.assertEquals((int)0, (int)apiMessageAndVersion.version());
            TopicRecord topicRecord = (TopicRecord)apiMessageAndVersion.message();
            Assertions.assertEquals((Object)"bar", (Object)topicRecord.name());
            Assertions.assertEquals((Object)Uuid.fromString((String)"cxBT72dK4si8Ied1iP4wBA"), (Object)topicRecord.topicId());
            Assertions.assertTrue((boolean)reader.hasNext());
            batchAndType = reader.next();
            Assertions.assertTrue((boolean)batchAndType.isControl());
            batch = batchAndType.batch();
            Assertions.assertEquals((long)(++currentOffset), (long)batch.baseOffset());
            Assertions.assertEquals((long)currentOffset, (long)batch.lastOffset());
            records = batch.records();
            Assertions.assertEquals((int)1, (int)records.size());
            apiMessageAndVersion = (ApiMessageAndVersion)records.get(0);
            Assertions.assertEquals((int)0, (int)apiMessageAndVersion.version());
            SnapshotFooterRecord footerRecord = (SnapshotFooterRecord)apiMessageAndVersion.message();
            Assertions.assertEquals((int)0, (int)footerRecord.version());
        }
    }
}

