/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.properties;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.AbstractMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class MetaPropertiesEnsembleTest {
    private static final MetaPropertiesEnsemble FOO = new MetaPropertiesEnsemble(new HashSet<String>(List.of("/tmp/empty1", "/tmp/empty2")), new HashSet<String>(List.of("/tmp/error3")), Stream.of(new AbstractMap.SimpleImmutableEntry<String, MetaProperties>("/tmp/dir4", new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("fooClusterId").setNodeId(2).build()), new AbstractMap.SimpleImmutableEntry<String, MetaProperties>("/tmp/dir5", new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("fooClusterId").setNodeId(2).build())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), Optional.of("/tmp/dir4"));
    private static final List<MetaProperties> SAMPLE_META_PROPS_LIST = List.of(new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("AtgGav8yQjiaJ3rTXE7VCA").setNodeId(1).setDirectoryId(Uuid.fromString((String)"s33AdXtkR8Gf_xRO-R_dpA")).build(), new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("AtgGav8yQjiaJ3rTXE7VCA").setNodeId(1).setDirectoryId(Uuid.fromString((String)"oTM53yT_SbSfzlvkh_PfVA")).build(), new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("AtgGav8yQjiaJ3rTXE7VCA").setNodeId(1).setDirectoryId(Uuid.fromString((String)"FcUhIv2mTzmLqGkVEabyag")).build());

    private static String createLogDir(MetaProperties metaProps) throws IOException {
        File logDir = TestUtils.tempDirectory();
        PropertiesUtils.writePropertiesFile((Properties)metaProps.toProperties(), (String)new File(logDir, "meta.properties").getAbsolutePath(), (boolean)false);
        return logDir.getAbsolutePath();
    }

    private static String createEmptyLogDir() {
        File logDir = TestUtils.tempDirectory();
        return logDir.getAbsolutePath();
    }

    private static String createErrorLogDir() throws IOException {
        File logDir = TestUtils.tempDirectory();
        File metaPath = new File(logDir, "meta.properties");
        Files.write(metaPath.toPath(), new byte[]{0}, new OpenOption[0]);
        metaPath.setReadable(false);
        return logDir.getAbsolutePath();
    }

    @Test
    public void testEmptyLogDirsForFoo() {
        Assertions.assertEquals(new HashSet<String>(List.of("/tmp/empty1", "/tmp/empty2")), (Object)FOO.emptyLogDirs());
    }

    @Test
    public void testEmptyLogDirsForEmpty() {
        Assertions.assertEquals(new HashSet(), (Object)MetaPropertiesEnsemble.EMPTY.emptyLogDirs());
    }

    @Test
    public void testErrorLogDirsForFoo() {
        Assertions.assertEquals(new HashSet<String>(List.of("/tmp/error3")), (Object)FOO.errorLogDirs());
    }

    @Test
    public void testErrorLogDirsForEmpty() {
        Assertions.assertEquals(new HashSet(), (Object)MetaPropertiesEnsemble.EMPTY.errorLogDirs());
    }

    @Test
    public void testLogDirPropsForFoo() {
        Assertions.assertEquals(new HashSet<String>(List.of("/tmp/dir4", "/tmp/dir5")), FOO.logDirProps().keySet());
    }

    @Test
    public void testLogDirPropsForEmpty() {
        Assertions.assertEquals(new HashSet(), MetaPropertiesEnsemble.EMPTY.logDirProps().keySet());
    }

    @Test
    public void testNonFailedDirectoryPropsForFoo() {
        HashMap results = new HashMap();
        FOO.nonFailedDirectoryProps().forEachRemaining(entry -> results.put((String)entry.getKey(), (Optional)entry.getValue()));
        Assertions.assertEquals(Optional.empty(), results.get("/tmp/empty1"));
        Assertions.assertEquals(Optional.empty(), results.get("/tmp/empty2"));
        Assertions.assertNull(results.get("/tmp/error3"));
        Assertions.assertEquals(Optional.of(new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("fooClusterId").setNodeId(2).build()), results.get("/tmp/dir4"));
        Assertions.assertEquals(Optional.of(new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("fooClusterId").setNodeId(2).build()), results.get("/tmp/dir5"));
        Assertions.assertEquals((int)4, (int)results.size());
    }

    @Test
    public void testNonFailedDirectoryPropsForEmpty() {
        Assertions.assertFalse((boolean)MetaPropertiesEnsemble.EMPTY.nonFailedDirectoryProps().hasNext());
    }

    @Test
    public void testMetadataLogDirForFoo() {
        Assertions.assertEquals(Optional.of("/tmp/dir4"), (Object)FOO.metadataLogDir());
    }

    @Test
    public void testMetadataLogDirForEmpty() {
        Assertions.assertEquals(Optional.empty(), (Object)MetaPropertiesEnsemble.EMPTY.metadataLogDir());
    }

    @Test
    public void testNodeIdForFoo() {
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)FOO.nodeId());
    }

    @Test
    public void testNodeIdForEmpty() {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)MetaPropertiesEnsemble.EMPTY.nodeId());
    }

    @Test
    public void testClusterIdForFoo() {
        Assertions.assertEquals(Optional.of("fooClusterId"), (Object)FOO.clusterId());
    }

    @Test
    public void testClusterIdForEmpty() {
        Assertions.assertEquals(Optional.empty(), (Object)MetaPropertiesEnsemble.EMPTY.clusterId());
    }

    @Test
    public void testSuccessfulVerification() {
        FOO.verify(Optional.empty(), OptionalInt.empty(), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_AT_LEAST_ONE_VALID, MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR));
    }

    @Test
    public void testSuccessfulVerificationWithClusterId() {
        FOO.verify(Optional.of("fooClusterId"), OptionalInt.empty(), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_AT_LEAST_ONE_VALID, MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR));
    }

    @Test
    public void testSuccessfulVerificationWithClusterIdAndNodeId() {
        FOO.verify(Optional.of("fooClusterId"), OptionalInt.of(2), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_AT_LEAST_ONE_VALID, MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR));
    }

    @Test
    public void testVerificationFailureOnRequireV0() {
        Assertions.assertEquals((Object)"Found unexpected version in /tmp/dir4/meta.properties. ZK-based brokers that are not migrating only support version 0 (which is implicit when the `version` field is missing).", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> FOO.verify(Optional.empty(), OptionalInt.empty(), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_V0)))).getMessage());
    }

    @Test
    public void testVerificationFailureOnRequireAtLeastOneValid() {
        Assertions.assertEquals((Object)"No readable meta.properties files found.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> MetaPropertiesEnsemble.EMPTY.verify(Optional.empty(), OptionalInt.empty(), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_AT_LEAST_ONE_VALID)))).getMessage());
    }

    @Test
    public void testVerificationFailureOnLackOfMetadataLogDir() {
        MetaPropertiesEnsemble ensemble = new MetaPropertiesEnsemble(Set.of("/tmp/foo1"), Set.of(), Map.of(), Optional.empty());
        Assertions.assertEquals((Object)"No metadata log directory was specified.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ensemble.verify(Optional.empty(), OptionalInt.empty(), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR)))).getMessage());
    }

    @Test
    public void testVerificationFailureOnMetadataLogDirWithError() {
        MetaPropertiesEnsemble ensemble = new MetaPropertiesEnsemble(Set.of(), Set.of("/tmp/foo1"), Map.of(), Optional.of("/tmp/foo1"));
        Assertions.assertEquals((Object)"Encountered I/O error in metadata log directory /tmp/foo1. Cannot continue.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ensemble.verify(Optional.empty(), OptionalInt.empty(), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR)))).getMessage());
    }

    @Test
    public void testMetaPropertiesEnsembleLoad() throws IOException {
        MetaPropertiesEnsemble.Loader loader = new MetaPropertiesEnsemble.Loader();
        MetaProperties metaProps = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("AtgGav8yQjiaJ3rTXE7VCA").setNodeId(1).build();
        loader.addMetadataLogDir(MetaPropertiesEnsembleTest.createLogDir(metaProps));
        MetaPropertiesEnsemble metaPropertiesEnsemble = loader.load();
        metaPropertiesEnsemble.verify(Optional.of("AtgGav8yQjiaJ3rTXE7VCA"), OptionalInt.of(1), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR, MetaPropertiesEnsemble.VerificationFlag.REQUIRE_AT_LEAST_ONE_VALID));
        Assertions.assertEquals((int)1, (int)metaPropertiesEnsemble.logDirProps().values().size());
        Assertions.assertEquals((Object)metaProps, metaPropertiesEnsemble.logDirProps().values().iterator().next());
    }

    @Test
    public void testMetaPropertiesEnsembleLoadEmpty() throws IOException {
        MetaPropertiesEnsemble.Loader loader = new MetaPropertiesEnsemble.Loader();
        loader.addMetadataLogDir(MetaPropertiesEnsembleTest.createEmptyLogDir());
        MetaPropertiesEnsemble metaPropertiesEnsemble = loader.load();
        metaPropertiesEnsemble.verify(Optional.of("AtgGav8yQjiaJ3rTXE7VCA"), OptionalInt.of(1), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR));
        Assertions.assertEquals((int)1, (int)metaPropertiesEnsemble.emptyLogDirs().size());
    }

    @Test
    public void testMetaPropertiesEnsembleLoadError() throws IOException {
        MetaPropertiesEnsemble.Loader loader = new MetaPropertiesEnsemble.Loader();
        loader.addMetadataLogDir(MetaPropertiesEnsembleTest.createErrorLogDir());
        loader.addLogDirs(List.of(MetaPropertiesEnsembleTest.createLogDir(new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("AtgGav8yQjiaJ3rTXE7VCA").setNodeId(1).build())));
        MetaPropertiesEnsemble metaPropertiesEnsemble = loader.load();
        Assertions.assertEquals((int)1, (int)metaPropertiesEnsemble.errorLogDirs().size());
        Assertions.assertEquals((int)1, (int)metaPropertiesEnsemble.logDirProps().size());
    }

    private static void verifyCopy(MetaPropertiesEnsemble expected, MetaPropertiesEnsemble.Copier copier) {
        copier.verify();
        MetaPropertiesEnsemble foo2 = copier.copy();
        Assertions.assertEquals((Object)expected, (Object)foo2);
        Assertions.assertEquals((int)expected.hashCode(), (int)foo2.hashCode());
        Assertions.assertEquals((Object)expected.toString(), (Object)foo2.toString());
    }

    @Test
    public void testCopierWithoutModifications() {
        MetaPropertiesEnsembleTest.verifyCopy(FOO, new MetaPropertiesEnsemble.Copier(FOO));
    }

    @Test
    public void testCopyFooItemByItem() {
        MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(MetaPropertiesEnsemble.EMPTY);
        copier.setMetaLogDir(FOO.metadataLogDir());
        FOO.emptyLogDirs().forEach(e -> copier.emptyLogDirs().add(e));
        FOO.logDirProps().forEach((key, value) -> copier.logDirProps().put(key, value));
        FOO.errorLogDirs().forEach(e -> copier.errorLogDirs().add(e));
        MetaPropertiesEnsembleTest.verifyCopy(FOO, copier);
    }

    @Test
    public void testCopierGenerateValidDirectoryId() {
        MetaPropertiesMockRandom random = new MetaPropertiesMockRandom();
        MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(MetaPropertiesEnsemble.EMPTY);
        copier.setRandom((Random)random);
        copier.logDirProps().put("/tmp/dir1", new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("PpYMbsoRQV-589isZzNzEw").setNodeId(0).setDirectoryId(new Uuid(2336837413447398698L, 1758400403264101670L)).build());
        copier.logDirProps().put("/tmp/dir2", new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("PpYMbsoRQV-589isZzNzEw").setNodeId(0).setDirectoryId(new Uuid(4341931186263415792L, 6389410885970711333L)).build());
        Assertions.assertEquals((Object)new Uuid(7265008559332826740L, 3478747443029687715L), (Object)copier.generateValidDirectoryId());
    }

    @Test
    public void testCopierVerificationFailsOnEmptyAndErrorOverlap() {
        MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(MetaPropertiesEnsemble.EMPTY);
        copier.emptyLogDirs().add("/tmp/foo");
        copier.errorLogDirs().add("/tmp/foo");
        Assertions.assertEquals((Object)"Error: log directory /tmp/foo is in both emptyLogDirs and errorLogDirs.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ((MetaPropertiesEnsemble.Copier)copier).verify())).getMessage());
    }

    @Test
    public void testCopierVerificationFailsOnEmptyAndLogDirsOverlap() {
        MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(MetaPropertiesEnsemble.EMPTY);
        copier.emptyLogDirs().add("/tmp/foo");
        copier.logDirProps().put("/tmp/foo", new MetaProperties.Builder().build());
        Assertions.assertEquals((Object)"Error: log directory /tmp/foo is in both emptyLogDirs and logDirProps.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ((MetaPropertiesEnsemble.Copier)copier).verify())).getMessage());
    }

    @Test
    public void testCopierVerificationFailsOnErrorAndLogDirsOverlap() {
        MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(MetaPropertiesEnsemble.EMPTY);
        copier.errorLogDirs().add("/tmp/foo");
        copier.logDirProps().put("/tmp/foo", new MetaProperties.Builder().build());
        Assertions.assertEquals((Object)"Error: log directory /tmp/foo is in both errorLogDirs and logDirProps.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ((MetaPropertiesEnsemble.Copier)copier).verify())).getMessage());
    }

    @Test
    public void testCopierWriteLogDirChanges() throws Exception {
        MetaPropertiesEnsemble.Loader loader = new MetaPropertiesEnsemble.Loader();
        loader.addMetadataLogDir(MetaPropertiesEnsembleTest.createLogDir(SAMPLE_META_PROPS_LIST.get(0)));
        MetaPropertiesEnsemble ensemble = loader.load();
        MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(ensemble);
        String newLogDir1 = MetaPropertiesEnsembleTest.createEmptyLogDir();
        copier.logDirProps().put(newLogDir1, SAMPLE_META_PROPS_LIST.get(1));
        String newLogDir2 = MetaPropertiesEnsembleTest.createEmptyLogDir();
        copier.logDirProps().put(newLogDir2, SAMPLE_META_PROPS_LIST.get(2));
        copier.writeLogDirChanges();
        Assertions.assertEquals((Object)SAMPLE_META_PROPS_LIST.get(1).toProperties(), (Object)PropertiesUtils.readPropertiesFile((String)new File(newLogDir1, "meta.properties").getAbsolutePath()));
        Assertions.assertEquals((Object)SAMPLE_META_PROPS_LIST.get(2).toProperties(), (Object)PropertiesUtils.readPropertiesFile((String)new File(newLogDir2, "meta.properties").getAbsolutePath()));
    }

    @Test
    public void testCopierWriteChanged() throws Exception {
        MetaPropertiesEnsemble.Loader loader = new MetaPropertiesEnsemble.Loader();
        String dir0 = MetaPropertiesEnsembleTest.createLogDir(SAMPLE_META_PROPS_LIST.get(0));
        loader.addMetadataLogDir(dir0);
        String dir1 = MetaPropertiesEnsembleTest.createLogDir(SAMPLE_META_PROPS_LIST.get(1));
        loader.addLogDirs(List.of(dir0, dir1));
        MetaPropertiesEnsemble ensemble = loader.load();
        MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(ensemble);
        copier.setLogDirProps(dir0, SAMPLE_META_PROPS_LIST.get(2));
        copier.writeLogDirChanges();
        Assertions.assertEquals((Object)SAMPLE_META_PROPS_LIST.get(2).toProperties(), (Object)PropertiesUtils.readPropertiesFile((String)new File(dir0, "meta.properties").getAbsolutePath()));
        Assertions.assertEquals((Object)SAMPLE_META_PROPS_LIST.get(1).toProperties(), (Object)PropertiesUtils.readPropertiesFile((String)new File(dir1, "meta.properties").getAbsolutePath()));
    }

    static class MetaPropertiesMockRandom
    extends Random {
        private final AtomicInteger index = new AtomicInteger(0);
        private final List<Long> results = List.of(Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(2336837413447398698L), Long.valueOf(1758400403264101670L), Long.valueOf(4341931186263415792L), Long.valueOf(6389410885970711333L), Long.valueOf(7265008559332826740L), Long.valueOf(3478747443029687715L));

        MetaPropertiesMockRandom() {
        }

        @Override
        public long nextLong() {
            int curIndex = this.index.getAndIncrement();
            return this.results.get(curIndex % this.results.size());
        }
    }
}

