/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.placement;

import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.apache.kafka.metadata.placement.PartitionAssignmentTest;
import org.apache.kafka.metadata.placement.TopicAssignment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicAssignmentTest {
    @Test
    public void testTopicAssignmentReplicas() {
        List<Integer> replicasP0 = List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
        List<Integer> replicasP1 = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(0));
        List<PartitionAssignment> partitionAssignments = List.of(PartitionAssignmentTest.partitionAssignment(replicasP0), PartitionAssignmentTest.partitionAssignment(replicasP1));
        Assertions.assertEquals(partitionAssignments, (Object)new TopicAssignment(partitionAssignments).assignments());
    }

    @Test
    public void testConsistentEqualsAndHashCode() {
        List<TopicAssignment> topicAssignments = List.of(new TopicAssignment(List.of(PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))))), new TopicAssignment(List.of(PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(0))))));
        for (int i = 0; i < topicAssignments.size(); ++i) {
            for (int j = 0; j < topicAssignments.size(); ++j) {
                if (i == j) {
                    Assertions.assertEquals((Object)topicAssignments.get(i), (Object)topicAssignments.get(j));
                    Assertions.assertEquals((Object)topicAssignments.get(i), (Object)new TopicAssignment(topicAssignments.get(i).assignments()));
                    Assertions.assertEquals((int)topicAssignments.get(i).hashCode(), (int)topicAssignments.get(j).hashCode());
                    continue;
                }
                Assertions.assertNotEquals((Object)topicAssignments.get(i), (Object)topicAssignments.get(j));
                Assertions.assertNotEquals((int)topicAssignments.get(i).hashCode(), (int)topicAssignments.get(j).hashCode());
            }
        }
    }

    @Test
    public void testToString() {
        List<Integer> replicas = List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
        List<Uuid> directories = List.of(Uuid.fromString((String)"v56qeYzNRrqNtXsxzcReog"), Uuid.fromString((String)"MvUIAsOiRlSePeiBHdZrSQ"), Uuid.fromString((String)"jUqCchHtTHqMxeVv4dw1RA"));
        List<PartitionAssignment> partitionAssignments = List.of(new PartitionAssignment(replicas, directories::get));
        TopicAssignment topicAssignment = new TopicAssignment(partitionAssignments);
        Assertions.assertEquals((Object)"TopicAssignment(assignments=[PartitionAssignment(replicas=[0, 1, 2], directories=[v56qeYzNRrqNtXsxzcReog, MvUIAsOiRlSePeiBHdZrSQ, jUqCchHtTHqMxeVv4dw1RA])])", (Object)topicAssignment.toString());
    }
}

