/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.bootstrap;

import java.util.List;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.NoOpRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=60L)
public class BootstrapMetadataTest {
    static final List<ApiMessageAndVersion> SAMPLE_RECORDS1 = List.of(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel((short)8), 0), new ApiMessageAndVersion((ApiMessage)new NoOpRecord(), 0), new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel((short)7), 0));
    private static final ApiMessageAndVersion MV_10 = new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel((short)10), 0);
    private static final ApiMessageAndVersion MV_11 = new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel((short)11), 0);
    private static final ApiMessageAndVersion FOO_1 = new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo").setFeatureLevel((short)1), 0);
    private static final ApiMessageAndVersion FOO_2 = new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo").setFeatureLevel((short)2), 0);
    static final List<ApiMessageAndVersion> RECORDS_WITH_OLD_METADATA_VERSION = List.of(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel((short)1), 0));

    @Test
    public void testFromVersion() {
        Assertions.assertEquals((Object)new BootstrapMetadata(List.of(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel((short)7), 0)), MetadataVersion.IBP_3_3_IV3.featureLevel(), "foo"), (Object)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.IBP_3_3_IV3, (String)"foo"));
    }

    @Test
    public void testFromRecordsList() {
        Assertions.assertEquals((Object)new BootstrapMetadata(SAMPLE_RECORDS1, MetadataVersion.IBP_3_3_IV3.featureLevel(), "bar"), (Object)BootstrapMetadata.fromRecords(SAMPLE_RECORDS1, (String)"bar"));
    }

    @Test
    public void testFromRecordsListWithoutMetadataVersion() {
        Assertions.assertEquals((Object)"No FeatureLevelRecord for metadata.version was found in the bootstrap metadata from quux", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> BootstrapMetadata.fromRecords(List.of(), (String)"quux"))).getMessage());
    }

    @Test
    public void testCopyWithNewFeatureRecord() {
        Assertions.assertEquals((Object)BootstrapMetadata.fromRecords(List.of(MV_10, FOO_1), (String)"src"), (Object)BootstrapMetadata.fromRecords(List.of(MV_10), (String)"src").copyWithFeatureRecord("foo", (short)1));
    }

    @Test
    public void testFeatureLevelForMetadataVersion() {
        Assertions.assertEquals((short)11, (short)BootstrapMetadata.fromRecords(List.of(MV_10, MV_11), (String)"src").featureLevel("metadata.version"));
    }

    @Test
    public void testCopyWithModifiedFeatureRecord() {
        Assertions.assertEquals((Object)BootstrapMetadata.fromRecords(List.of(MV_10, FOO_2), (String)"src"), (Object)BootstrapMetadata.fromRecords(List.of(MV_10, FOO_1), (String)"src").copyWithFeatureRecord("foo", (short)2));
    }

    @Test
    public void testFeatureLevelForFeatureThatIsNotSet() {
        Assertions.assertEquals((short)0, (short)BootstrapMetadata.fromRecords(List.of(MV_10), (String)"src").featureLevel("foo"));
    }

    @Test
    public void testFeatureLevelForFeature() {
        Assertions.assertEquals((short)2, (short)BootstrapMetadata.fromRecords(List.of(MV_10, FOO_2), (String)"src").featureLevel("foo"));
    }

    @Test
    public void testFromRecordsListWithOldMetadataVersion() {
        BootstrapMetadata bootstrapMetadata = BootstrapMetadata.fromRecords(RECORDS_WITH_OLD_METADATA_VERSION, (String)"quux");
        Assertions.assertEquals((Object)("No MetadataVersion with feature level 1. Valid feature levels are from " + MetadataVersion.MINIMUM_VERSION.featureLevel() + " to " + MetadataVersion.latestTesting().featureLevel() + "."), (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> bootstrapMetadata.metadataVersion())).getMessage());
    }
}

