/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.AuthorizerNotReadyException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.PluginMetrics;
import org.apache.kafka.common.metrics.internals.PluginMetricsImpl;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.authorizer.MockAuthorizableRequestContext;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerData;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=40L)
public class StandardAuthorizerTest {
    public static final Endpoint PLAINTEXT = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "127.0.0.1", 9020);
    public static final Endpoint CONTROLLER = new Endpoint("CONTROLLER", SecurityProtocol.PLAINTEXT, "127.0.0.1", 9020);
    private final Metrics metrics = new Metrics();

    @Test
    public void testGetConfiguredSuperUsers() {
        Assertions.assertEquals(Set.of(), (Object)StandardAuthorizer.getConfiguredSuperUsers(Map.of()));
        Assertions.assertEquals(Set.of(), (Object)StandardAuthorizer.getConfiguredSuperUsers(Map.of("super.users", " ")));
        Assertions.assertEquals(Set.of("User:bob", "User:alice"), (Object)StandardAuthorizer.getConfiguredSuperUsers(Map.of("super.users", "User:bob;User:alice ")));
        Assertions.assertEquals(Set.of("User:bob", "User:alice"), (Object)StandardAuthorizer.getConfiguredSuperUsers(Map.of("super.users", ";  User:bob  ;  User:alice ")));
        Assertions.assertEquals((Object)"expected a string in format principalType:principalName but got bob", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> StandardAuthorizer.getConfiguredSuperUsers(Map.of("super.users", "bob;:alice")))).getMessage());
    }

    @Test
    public void testGetDefaultResult() {
        Assertions.assertEquals((Object)AuthorizationResult.DENIED, (Object)StandardAuthorizer.getDefaultResult(Map.of()));
        Assertions.assertEquals((Object)AuthorizationResult.ALLOWED, (Object)StandardAuthorizer.getDefaultResult(Map.of("allow.everyone.if.no.acl.found", "true")));
        Assertions.assertEquals((Object)AuthorizationResult.DENIED, (Object)StandardAuthorizer.getDefaultResult(Map.of("allow.everyone.if.no.acl.found", "false")));
    }

    @Test
    public void testAllowEveryoneIfNoAclFoundConfigEnabled() throws Exception {
        Map<String, Object> configs = Map.of("super.users", "User:alice;User:chris", "allow.everyone.if.no.acl.found", "true");
        StandardAuthorizer authorizer = this.createAndInitializeStandardAuthorizer(configs);
        List<StandardAclWithId> acls = List.of(StandardAuthorizerTest.withId(new StandardAcl(ResourceType.TOPIC, "topic1", PatternType.LITERAL, "User:Alice", "*", AclOperation.READ, AclPermissionType.ALLOW)));
        acls.forEach(acl -> authorizer.addAcl(acl.id(), acl.acl()));
        Assertions.assertEquals(List.of(AuthorizationResult.DENIED), (Object)authorizer.authorize((AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "Bob")).build(), List.of(StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "topic1"))));
        Assertions.assertEquals(List.of(AuthorizationResult.ALLOWED), (Object)authorizer.authorize((AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "Bob")).build(), List.of(StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "topic2"))));
    }

    @Test
    public void testAllowEveryoneIfNoAclFoundConfigDisabled() throws Exception {
        Map<String, Object> configs = Map.of("super.users", "User:alice;User:chris", "allow.everyone.if.no.acl.found", "false");
        StandardAuthorizer authorizer = this.createAndInitializeStandardAuthorizer(configs);
        List<StandardAclWithId> acls = List.of(StandardAuthorizerTest.withId(new StandardAcl(ResourceType.TOPIC, "topic1", PatternType.LITERAL, "User:Alice", "*", AclOperation.READ, AclPermissionType.ALLOW)));
        acls.forEach(acl -> authorizer.addAcl(acl.id(), acl.acl()));
        Assertions.assertEquals(List.of(AuthorizationResult.DENIED), (Object)authorizer.authorize((AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "Bob")).build(), List.of(StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "topic1"))));
        Assertions.assertEquals(List.of(AuthorizationResult.DENIED), (Object)authorizer.authorize((AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "Bob")).build(), List.of(StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "topic2"))));
    }

    @Test
    public void testConfigure() {
        Map<String, Object> configs = Map.of("super.users", "User:alice;User:chris", "allow.everyone.if.no.acl.found", "true");
        StandardAuthorizer authorizer = this.createAndInitializeStandardAuthorizer(configs);
        Assertions.assertEquals(Set.of("User:alice", "User:chris"), (Object)authorizer.superUsers());
        Assertions.assertEquals((Object)AuthorizationResult.ALLOWED, (Object)authorizer.defaultResult());
    }

    private static Action newAction(AclOperation aclOperation, ResourceType resourceType, String resourceName) {
        return new Action(aclOperation, new ResourcePattern(resourceType, resourceName, PatternType.LITERAL), 1, false, false);
    }

    private StandardAuthorizer createAndInitializeStandardAuthorizer() {
        return this.createAndInitializeStandardAuthorizer(Map.of("super.users", "User:superman"));
    }

    private StandardAuthorizer createAndInitializeStandardAuthorizer(Map<String, Object> configs) {
        StandardAuthorizer authorizer = new StandardAuthorizer();
        authorizer.configure(configs);
        authorizer.withPluginMetrics((PluginMetrics)new PluginMetricsImpl(this.metrics, Map.of()));
        authorizer.start((AuthorizerServerInfo)new AuthorizerTestServerInfo(List.of(PLAINTEXT)));
        authorizer.completeInitialLoad();
        return authorizer;
    }

    private static StandardAcl newFooAcl(AclOperation op, AclPermissionType permission) {
        return new StandardAcl(ResourceType.TOPIC, "foo_", PatternType.PREFIXED, "User:bob", "*", op, permission);
    }

    private static StandardAclWithId withId(StandardAcl acl) {
        return new StandardAclWithId(new Uuid((long)acl.hashCode(), (long)acl.hashCode()), acl);
    }

    @Test
    public void testFindResultImplication() throws Exception {
        for (AclOperation op : List.of(AclOperation.DESCRIBE, AclOperation.READ, AclOperation.WRITE, AclOperation.DELETE, AclOperation.ALTER)) {
            Assertions.assertEquals((Object)AuthorizationResult.ALLOWED, (Object)StandardAuthorizerData.findResult((Action)StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "foo_bar"), (AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "bob")).build(), (StandardAcl)StandardAuthorizerTest.newFooAcl(op, AclPermissionType.ALLOW)));
        }
        Assertions.assertNull((Object)StandardAuthorizerData.findResult((Action)StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "foo_bar"), (AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "bob")).build(), (StandardAcl)StandardAuthorizerTest.newFooAcl(AclOperation.CREATE, AclPermissionType.ALLOW)));
        for (AclOperation op : List.of(AclOperation.READ, AclOperation.WRITE, AclOperation.DELETE, AclOperation.ALTER)) {
            Assertions.assertNull((Object)StandardAuthorizerData.findResult((Action)StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "foo_bar"), (AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "bob")).build(), (StandardAcl)StandardAuthorizerTest.newFooAcl(op, AclPermissionType.DENY)));
        }
        Assertions.assertEquals((Object)AuthorizationResult.DENIED, (Object)StandardAuthorizerData.findResult((Action)StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "foo_bar"), (AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "bob")).build(), (StandardAcl)StandardAuthorizerTest.newFooAcl(AclOperation.DESCRIBE, AclPermissionType.DENY)));
        for (AclOperation op : List.of(AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS)) {
            Assertions.assertEquals((Object)AuthorizationResult.ALLOWED, (Object)StandardAuthorizerData.findResult((Action)StandardAuthorizerTest.newAction(AclOperation.DESCRIBE_CONFIGS, ResourceType.TOPIC, "foo_bar"), (AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "bob")).build(), (StandardAcl)StandardAuthorizerTest.newFooAcl(op, AclPermissionType.ALLOW)));
        }
        Assertions.assertNull((Object)StandardAuthorizerData.findResult((Action)StandardAuthorizerTest.newAction(AclOperation.DESCRIBE_CONFIGS, ResourceType.TOPIC, "foo_bar"), (AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "bob")).build(), (StandardAcl)StandardAuthorizerTest.newFooAcl(AclOperation.ALTER_CONFIGS, AclPermissionType.DENY)));
        Assertions.assertEquals((Object)AuthorizationResult.DENIED, (Object)StandardAuthorizerData.findResult((Action)StandardAuthorizerTest.newAction(AclOperation.ALTER_CONFIGS, ResourceType.TOPIC, "foo_bar"), (AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "bob")).build(), (StandardAcl)StandardAuthorizerTest.newFooAcl(AclOperation.ALTER_CONFIGS, AclPermissionType.DENY)));
    }

    private static StandardAcl newBarAcl(AclOperation op, AclPermissionType permission) {
        return new StandardAcl(ResourceType.GROUP, "bar", PatternType.LITERAL, "User:*", "*", op, permission);
    }

    @Test
    public void testFindResultPrincipalMatching() throws Exception {
        Assertions.assertEquals((Object)AuthorizationResult.ALLOWED, (Object)StandardAuthorizerData.findResult((Action)StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "foo_bar"), (AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "bob")).build(), (StandardAcl)StandardAuthorizerTest.newFooAcl(AclOperation.READ, AclPermissionType.ALLOW)));
        Assertions.assertNull((Object)StandardAuthorizerData.findResult((Action)StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "foo_bar"), (AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "alice")).build(), (StandardAcl)StandardAuthorizerTest.newFooAcl(AclOperation.READ, AclPermissionType.ALLOW)));
        Assertions.assertEquals((Object)AuthorizationResult.DENIED, (Object)StandardAuthorizerData.findResult((Action)StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.GROUP, "bar"), (AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "alice")).build(), (StandardAcl)StandardAuthorizerTest.newBarAcl(AclOperation.READ, AclPermissionType.DENY)));
    }

    private static void assertContains(Iterable<AclBinding> iterable, StandardAcl ... acls) {
        Iterator<AclBinding> iterator = iterable.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            AclBinding acl = iterator.next();
            Assertions.assertTrue((i < acls.length ? 1 : 0) != 0, (String)("Only expected " + i + " element(s)"));
            Assertions.assertEquals((Object)acls[i].toBinding(), (Object)acl, (String)("Unexpected element " + i));
            ++i;
        }
        Assertions.assertFalse((boolean)iterator.hasNext(), (String)("Expected only " + acls.length + " element(s)"));
    }

    @Test
    public void testListAcls() {
        StandardAuthorizer authorizer = this.createAndInitializeStandardAuthorizer();
        List<StandardAclWithId> fooAcls = List.of(StandardAuthorizerTest.withId(StandardAuthorizerTest.newFooAcl(AclOperation.READ, AclPermissionType.ALLOW)), StandardAuthorizerTest.withId(StandardAuthorizerTest.newFooAcl(AclOperation.WRITE, AclPermissionType.ALLOW)));
        List<StandardAclWithId> barAcls = List.of(StandardAuthorizerTest.withId(StandardAuthorizerTest.newBarAcl(AclOperation.DESCRIBE_CONFIGS, AclPermissionType.DENY)), StandardAuthorizerTest.withId(StandardAuthorizerTest.newBarAcl(AclOperation.ALTER_CONFIGS, AclPermissionType.DENY)));
        fooAcls.forEach(a -> authorizer.addAcl(a.id(), a.acl()));
        barAcls.forEach(a -> authorizer.addAcl(a.id(), a.acl()));
        StandardAuthorizerTest.assertContains(authorizer.acls(AclBindingFilter.ANY), fooAcls.get(0).acl(), fooAcls.get(1).acl(), barAcls.get(0).acl(), barAcls.get(1).acl());
        authorizer.removeAcl(fooAcls.get(1).id());
        StandardAuthorizerTest.assertContains(authorizer.acls(AclBindingFilter.ANY), fooAcls.get(0).acl(), barAcls.get(0).acl(), barAcls.get(1).acl());
        StandardAuthorizerTest.assertContains(authorizer.acls(new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.ANY), AccessControlEntryFilter.ANY)), fooAcls.get(0).acl());
    }

    @Test
    public void testSimpleAuthorizations() throws Exception {
        StandardAuthorizer authorizer = this.createAndInitializeStandardAuthorizer();
        List<StandardAclWithId> fooAcls = List.of(StandardAuthorizerTest.withId(StandardAuthorizerTest.newFooAcl(AclOperation.READ, AclPermissionType.ALLOW)), StandardAuthorizerTest.withId(StandardAuthorizerTest.newFooAcl(AclOperation.WRITE, AclPermissionType.ALLOW)));
        List<StandardAclWithId> barAcls = List.of(StandardAuthorizerTest.withId(StandardAuthorizerTest.newBarAcl(AclOperation.DESCRIBE_CONFIGS, AclPermissionType.ALLOW)), StandardAuthorizerTest.withId(StandardAuthorizerTest.newBarAcl(AclOperation.ALTER_CONFIGS, AclPermissionType.ALLOW)));
        fooAcls.forEach(a -> authorizer.addAcl(a.id(), a.acl()));
        barAcls.forEach(a -> authorizer.addAcl(a.id(), a.acl()));
        Assertions.assertEquals(List.of(AuthorizationResult.ALLOWED), (Object)authorizer.authorize((AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "bob")).build(), List.of(StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "foo_"))));
        Assertions.assertEquals(List.of(AuthorizationResult.ALLOWED), (Object)authorizer.authorize((AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "fred")).build(), List.of(StandardAuthorizerTest.newAction(AclOperation.ALTER_CONFIGS, ResourceType.GROUP, "bar"))));
    }

    @Test
    public void testDenyPrecedenceWithOperationAll() throws Exception {
        StandardAuthorizer authorizer = this.createAndInitializeStandardAuthorizer();
        List<StandardAcl> acls = List.of(new StandardAcl(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:alice", "*", AclOperation.ALL, AclPermissionType.DENY), new StandardAcl(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:alice", "*", AclOperation.READ, AclPermissionType.ALLOW), new StandardAcl(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:*", "*", AclOperation.ALL, AclPermissionType.DENY), new StandardAcl(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:*", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        acls.forEach(acl -> {
            StandardAclWithId aclWithId = StandardAuthorizerTest.withId(acl);
            authorizer.addAcl(aclWithId.id(), aclWithId.acl());
        });
        Assertions.assertEquals(List.of(AuthorizationResult.DENIED, AuthorizationResult.DENIED, AuthorizationResult.DENIED, AuthorizationResult.ALLOWED), (Object)authorizer.authorize(this.newRequestContext("alice"), List.of(StandardAuthorizerTest.newAction(AclOperation.WRITE, ResourceType.TOPIC, "foo"), StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "foo"), StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "foo"), StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "foobar"))));
        Assertions.assertEquals(List.of(AuthorizationResult.DENIED, AuthorizationResult.DENIED, AuthorizationResult.DENIED, AuthorizationResult.ALLOWED, AuthorizationResult.DENIED), (Object)authorizer.authorize(this.newRequestContext("bob"), List.of(StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "foo"), StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "foo"), StandardAuthorizerTest.newAction(AclOperation.WRITE, ResourceType.TOPIC, "foo"), StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "foobaz"), StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "foobaz"))));
    }

    @Test
    public void testTopicAclWithOperationAll() throws Exception {
        StandardAuthorizer authorizer = this.createAndInitializeStandardAuthorizer();
        List<StandardAcl> acls = List.of(new StandardAcl(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:*", "*", AclOperation.ALL, AclPermissionType.ALLOW), new StandardAcl(ResourceType.TOPIC, "bar", PatternType.PREFIXED, "User:alice", "*", AclOperation.ALL, AclPermissionType.ALLOW), new StandardAcl(ResourceType.TOPIC, "baz", PatternType.LITERAL, "User:bob", "*", AclOperation.ALL, AclPermissionType.ALLOW));
        acls.forEach(acl -> {
            StandardAclWithId aclWithId = StandardAuthorizerTest.withId(acl);
            authorizer.addAcl(aclWithId.id(), aclWithId.acl());
        });
        Assertions.assertEquals(List.of(AuthorizationResult.ALLOWED, AuthorizationResult.ALLOWED, AuthorizationResult.DENIED), (Object)authorizer.authorize(this.newRequestContext("alice"), List.of(StandardAuthorizerTest.newAction(AclOperation.WRITE, ResourceType.TOPIC, "foo"), StandardAuthorizerTest.newAction(AclOperation.DESCRIBE_CONFIGS, ResourceType.TOPIC, "bar"), StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "baz"))));
        Assertions.assertEquals(List.of(AuthorizationResult.ALLOWED, AuthorizationResult.DENIED, AuthorizationResult.ALLOWED), (Object)authorizer.authorize(this.newRequestContext("bob"), List.of(StandardAuthorizerTest.newAction(AclOperation.WRITE, ResourceType.TOPIC, "foo"), StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "bar"), StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "baz"))));
        Assertions.assertEquals(List.of(AuthorizationResult.ALLOWED, AuthorizationResult.DENIED, AuthorizationResult.DENIED), (Object)authorizer.authorize(this.newRequestContext("malory"), List.of(StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "foo"), StandardAuthorizerTest.newAction(AclOperation.WRITE, ResourceType.TOPIC, "bar"), StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "baz"))));
    }

    private AuthorizableRequestContext newRequestContext(String principal) throws Exception {
        return new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", principal)).build();
    }

    @Test
    public void testHostAddressAclValidation() throws Exception {
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        StandardAuthorizer authorizer = this.createAndInitializeStandardAuthorizer();
        List<StandardAcl> acls = List.of(new StandardAcl(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:alice", host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY), new StandardAcl(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:alice", "*", AclOperation.READ, AclPermissionType.ALLOW), new StandardAcl(ResourceType.TOPIC, "bar", PatternType.LITERAL, "User:bob", host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW), new StandardAcl(ResourceType.TOPIC, "bar", PatternType.LITERAL, "User:*", InetAddress.getLocalHost().getHostAddress(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        acls.forEach(acl -> {
            StandardAclWithId aclWithId = StandardAuthorizerTest.withId(acl);
            authorizer.addAcl(aclWithId.id(), aclWithId.acl());
        });
        List<Action> actions = List.of(StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "foo"), StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "bar"), StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "bar"));
        Assertions.assertEquals(List.of(AuthorizationResult.ALLOWED, AuthorizationResult.DENIED, AuthorizationResult.ALLOWED), (Object)authorizer.authorize(this.newRequestContext("alice", InetAddress.getLocalHost()), actions));
        Assertions.assertEquals(List.of(AuthorizationResult.DENIED, AuthorizationResult.DENIED, AuthorizationResult.DENIED), (Object)authorizer.authorize(this.newRequestContext("alice", host1), actions));
        Assertions.assertEquals(List.of(AuthorizationResult.ALLOWED, AuthorizationResult.DENIED, AuthorizationResult.DENIED), (Object)authorizer.authorize(this.newRequestContext("alice", host2), actions));
        Assertions.assertEquals(List.of(AuthorizationResult.DENIED, AuthorizationResult.DENIED, AuthorizationResult.ALLOWED), (Object)authorizer.authorize(this.newRequestContext("bob", InetAddress.getLocalHost()), actions));
        Assertions.assertEquals(List.of(AuthorizationResult.DENIED, AuthorizationResult.DENIED, AuthorizationResult.DENIED), (Object)authorizer.authorize(this.newRequestContext("bob", host1), actions));
        Assertions.assertEquals(List.of(AuthorizationResult.DENIED, AuthorizationResult.ALLOWED, AuthorizationResult.ALLOWED), (Object)authorizer.authorize(this.newRequestContext("bob", host2), actions));
    }

    private AuthorizableRequestContext newRequestContext(String principal, InetAddress clientAddress) throws Exception {
        return new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", principal)).setClientAddress(clientAddress).build();
    }

    private static void addManyAcls(StandardAuthorizer authorizer) {
        List<StandardAcl> acls = List.of(new StandardAcl(ResourceType.TOPIC, "green2", PatternType.LITERAL, "User:*", "*", AclOperation.READ, AclPermissionType.ALLOW), new StandardAcl(ResourceType.TOPIC, "green", PatternType.PREFIXED, "User:bob", "*", AclOperation.READ, AclPermissionType.ALLOW), new StandardAcl(ResourceType.TOPIC, "betamax4", PatternType.LITERAL, "User:bob", "*", AclOperation.READ, AclPermissionType.ALLOW), new StandardAcl(ResourceType.TOPIC, "betamax", PatternType.LITERAL, "User:bob", "*", AclOperation.READ, AclPermissionType.ALLOW), new StandardAcl(ResourceType.TOPIC, "beta", PatternType.PREFIXED, "User:*", "*", AclOperation.READ, AclPermissionType.ALLOW), new StandardAcl(ResourceType.TOPIC, "alpha", PatternType.PREFIXED, "User:*", "*", AclOperation.READ, AclPermissionType.ALLOW), new StandardAcl(ResourceType.TOPIC, "alp", PatternType.PREFIXED, "User:bob", "*", AclOperation.READ, AclPermissionType.DENY), new StandardAcl(ResourceType.GROUP, "*", PatternType.LITERAL, "User:bob", "*", AclOperation.WRITE, AclPermissionType.ALLOW), new StandardAcl(ResourceType.GROUP, "wheel", PatternType.LITERAL, "User:*", "*", AclOperation.WRITE, AclPermissionType.DENY));
        acls.forEach(acl -> {
            StandardAclWithId aclWithId = StandardAuthorizerTest.withId(acl);
            authorizer.addAcl(aclWithId.id(), aclWithId.acl());
        });
    }

    @Test
    public void testAuthorizationWithManyAcls() throws Exception {
        StandardAuthorizer authorizer = this.createAndInitializeStandardAuthorizer();
        StandardAuthorizerTest.addManyAcls(authorizer);
        Assertions.assertEquals(List.of(AuthorizationResult.ALLOWED, AuthorizationResult.DENIED), (Object)authorizer.authorize((AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "bob")).build(), List.of(StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "green1"), StandardAuthorizerTest.newAction(AclOperation.WRITE, ResourceType.GROUP, "wheel"))));
        Assertions.assertEquals(List.of(AuthorizationResult.DENIED, AuthorizationResult.ALLOWED, AuthorizationResult.DENIED), (Object)authorizer.authorize((AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "bob")).build(), List.of(StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "alpha"), StandardAuthorizerTest.newAction(AclOperation.WRITE, ResourceType.GROUP, "arbitrary"), StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "ala"))));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDenyAuditLogging(boolean logIfDenied) throws Exception {
        try (MockedStatic mockedLoggerFactory = Mockito.mockStatic(LoggerFactory.class);){
            Logger otherLog = (Logger)Mockito.mock(Logger.class);
            Logger auditLog = (Logger)Mockito.mock(Logger.class);
            mockedLoggerFactory.when(() -> LoggerFactory.getLogger((String)"kafka.authorizer.logger")).thenReturn((Object)auditLog);
            mockedLoggerFactory.when(() -> LoggerFactory.getLogger((Class)((Class)Mockito.any(Class.class)))).thenReturn((Object)otherLog);
            Mockito.when((Object)auditLog.isDebugEnabled()).thenReturn((Object)true);
            Mockito.when((Object)auditLog.isTraceEnabled()).thenReturn((Object)true);
            StandardAuthorizer authorizer = this.createAndInitializeStandardAuthorizer();
            StandardAuthorizerTest.addManyAcls(authorizer);
            ResourcePattern topicResource = new ResourcePattern(ResourceType.TOPIC, "alpha", PatternType.LITERAL);
            Action action = new Action(AclOperation.READ, topicResource, 1, false, logIfDenied);
            MockAuthorizableRequestContext requestContext = new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "bob")).setClientAddress(InetAddress.getByName("127.0.0.1")).build();
            Assertions.assertEquals(List.of(AuthorizationResult.DENIED), (Object)authorizer.authorize((AuthorizableRequestContext)requestContext, List.of(action)));
            String expectedAuditLog = "Principal = User:bob is Denied operation = READ from host = 127.0.0.1 on resource = Topic:LITERAL:alpha for request = Fetch with resourceRefCount = 1 based on rule MatchingAcl(acl=StandardAcl(resourceType=TOPIC, resourceName=alp, patternType=PREFIXED, principal=User:bob, host=*, operation=READ, permissionType=DENY))";
            if (logIfDenied) {
                ((Logger)Mockito.verify((Object)auditLog)).info(expectedAuditLog);
            } else {
                ((Logger)Mockito.verify((Object)auditLog)).trace(expectedAuditLog);
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testAllowAuditLogging(boolean logIfAllowed) throws Exception {
        try (MockedStatic mockedLoggerFactory = Mockito.mockStatic(LoggerFactory.class);){
            Logger otherLog = (Logger)Mockito.mock(Logger.class);
            Logger auditLog = (Logger)Mockito.mock(Logger.class);
            mockedLoggerFactory.when(() -> LoggerFactory.getLogger((String)"kafka.authorizer.logger")).thenReturn((Object)auditLog);
            mockedLoggerFactory.when(() -> LoggerFactory.getLogger((Class)((Class)Mockito.any(Class.class)))).thenReturn((Object)otherLog);
            Mockito.when((Object)auditLog.isDebugEnabled()).thenReturn((Object)true);
            Mockito.when((Object)auditLog.isTraceEnabled()).thenReturn((Object)true);
            StandardAuthorizer authorizer = this.createAndInitializeStandardAuthorizer();
            StandardAuthorizerTest.addManyAcls(authorizer);
            ResourcePattern topicResource = new ResourcePattern(ResourceType.TOPIC, "green1", PatternType.LITERAL);
            Action action = new Action(AclOperation.READ, topicResource, 1, logIfAllowed, false);
            MockAuthorizableRequestContext requestContext = new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "bob")).setClientAddress(InetAddress.getByName("127.0.0.1")).build();
            Assertions.assertEquals(List.of(AuthorizationResult.ALLOWED), (Object)authorizer.authorize((AuthorizableRequestContext)requestContext, List.of(action)));
            String expectedAuditLog = "Principal = User:bob is Allowed operation = READ from host = 127.0.0.1 on resource = Topic:LITERAL:green1 for request = Fetch with resourceRefCount = 1 based on rule MatchingAcl(acl=StandardAcl(resourceType=TOPIC, resourceName=green, patternType=PREFIXED, principal=User:bob, host=*, operation=READ, permissionType=ALLOW))";
            if (logIfAllowed) {
                ((Logger)Mockito.verify((Object)auditLog)).debug(expectedAuditLog);
            } else {
                ((Logger)Mockito.verify((Object)auditLog)).trace(expectedAuditLog);
            }
        }
    }

    @Test
    public void testStartWithEarlyStartListeners() {
        StandardAuthorizer authorizer = new StandardAuthorizer();
        authorizer.configure(Map.of("super.users", "User:superman"));
        Map futures2 = authorizer.start((AuthorizerServerInfo)new AuthorizerTestServerInfo(List.of(PLAINTEXT, CONTROLLER)));
        Assertions.assertEquals(Set.of(PLAINTEXT, CONTROLLER), futures2.keySet());
        Assertions.assertFalse((boolean)((CompletionStage)futures2.get(PLAINTEXT)).toCompletableFuture().isDone());
        Assertions.assertTrue((boolean)((CompletionStage)futures2.get(CONTROLLER)).toCompletableFuture().isDone());
    }

    @Test
    public void testAuthorizationPriorToCompleteInitialLoad() throws Exception {
        StandardAuthorizer authorizer = new StandardAuthorizer();
        authorizer.configure(Map.of("super.users", "User:superman"));
        authorizer.withPluginMetrics((PluginMetrics)new PluginMetricsImpl(new Metrics(), Map.of()));
        Assertions.assertThrows(AuthorizerNotReadyException.class, () -> authorizer.authorize((AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "bob")).build(), List.of(StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "green1"), StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "green2"))));
        Assertions.assertEquals(List.of(AuthorizationResult.ALLOWED, AuthorizationResult.ALLOWED), (Object)authorizer.authorize((AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "superman")).build(), List.of(StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "green1"), StandardAuthorizerTest.newAction(AclOperation.WRITE, ResourceType.GROUP, "wheel"))));
    }

    @Test
    public void testCompleteInitialLoad() {
        StandardAuthorizer authorizer = new StandardAuthorizer();
        authorizer.configure(Map.of("super.users", "User:superman"));
        Map futures = authorizer.start((AuthorizerServerInfo)new AuthorizerTestServerInfo(Set.of(PLAINTEXT)));
        Assertions.assertEquals(Set.of(PLAINTEXT), futures.keySet());
        Assertions.assertFalse((boolean)((CompletionStage)futures.get(PLAINTEXT)).toCompletableFuture().isDone());
        authorizer.completeInitialLoad();
        Assertions.assertTrue((boolean)((CompletionStage)futures.get(PLAINTEXT)).toCompletableFuture().isDone());
        Assertions.assertFalse((boolean)((CompletionStage)futures.get(PLAINTEXT)).toCompletableFuture().isCompletedExceptionally());
    }

    @Test
    public void testCompleteInitialLoadWithException() {
        StandardAuthorizer authorizer = new StandardAuthorizer();
        authorizer.configure(Map.of("super.users", "User:superman"));
        Map futures = authorizer.start((AuthorizerServerInfo)new AuthorizerTestServerInfo(List.of(PLAINTEXT, CONTROLLER)));
        Assertions.assertEquals(Set.of(PLAINTEXT, CONTROLLER), futures.keySet());
        Assertions.assertFalse((boolean)((CompletionStage)futures.get(PLAINTEXT)).toCompletableFuture().isDone());
        Assertions.assertTrue((boolean)((CompletionStage)futures.get(CONTROLLER)).toCompletableFuture().isDone());
        authorizer.completeInitialLoad((Exception)new TimeoutException("timed out"));
        Assertions.assertTrue((boolean)((CompletionStage)futures.get(PLAINTEXT)).toCompletableFuture().isDone());
        Assertions.assertTrue((boolean)((CompletionStage)futures.get(PLAINTEXT)).toCompletableFuture().isCompletedExceptionally());
        Assertions.assertTrue((boolean)((CompletionStage)futures.get(CONTROLLER)).toCompletableFuture().isDone());
        Assertions.assertFalse((boolean)((CompletionStage)futures.get(CONTROLLER)).toCompletableFuture().isCompletedExceptionally());
    }

    @Test
    public void testPrefixAcls() throws Exception {
        StandardAuthorizer authorizer = this.createAndInitializeStandardAuthorizer();
        List<StandardAcl> acls = List.of(new StandardAcl(ResourceType.TOPIC, "fooa", PatternType.PREFIXED, "User:alice", "*", AclOperation.ALL, AclPermissionType.ALLOW), new StandardAcl(ResourceType.TOPIC, "foobar", PatternType.LITERAL, "User:bob", "*", AclOperation.ALL, AclPermissionType.ALLOW), new StandardAcl(ResourceType.TOPIC, "f", PatternType.PREFIXED, "User:bob", "*", AclOperation.ALL, AclPermissionType.ALLOW));
        acls.forEach(acl -> {
            StandardAclWithId aclWithId = StandardAuthorizerTest.withId(acl);
            authorizer.addAcl(aclWithId.id(), aclWithId.acl());
        });
        Assertions.assertEquals(List.of(AuthorizationResult.ALLOWED, AuthorizationResult.DENIED, AuthorizationResult.ALLOWED), (Object)authorizer.authorize(this.newRequestContext("bob"), List.of(StandardAuthorizerTest.newAction(AclOperation.WRITE, ResourceType.TOPIC, "foobarr"), StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "goobar"), StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "fooa"))));
        Assertions.assertEquals(List.of(AuthorizationResult.ALLOWED, AuthorizationResult.DENIED, AuthorizationResult.DENIED), (Object)authorizer.authorize(this.newRequestContext("alice"), List.of(StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "fooa"), StandardAuthorizerTest.newAction(AclOperation.WRITE, ResourceType.TOPIC, "bar"), StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "baz"))));
    }

    @Test
    public void testAuthorizerMetrics() throws Exception {
        Assertions.assertEquals((int)1, (int)this.metrics.metrics().size());
        StandardAuthorizer authorizer = this.createAndInitializeStandardAuthorizer();
        Assertions.assertEquals(List.of(AuthorizationResult.ALLOWED), (Object)authorizer.authorize((AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setPrincipal(new KafkaPrincipal("User", "superman")).build(), List.of(StandardAuthorizerTest.newAction(AclOperation.READ, ResourceType.TOPIC, "green"))));
        Assertions.assertEquals((int)5, (int)this.metrics.metrics().size());
    }

    public record AuthorizerTestServerInfo(Collection<Endpoint> endpoints) implements AuthorizerServerInfo
    {
        public AuthorizerTestServerInfo {
            Assertions.assertFalse((boolean)endpoints.isEmpty());
        }

        public ClusterResource clusterResource() {
            return new ClusterResource(Uuid.fromString((String)"r7mqHQrxTNmzbKvCvWZzLQ").toString());
        }

        public int brokerId() {
            return 0;
        }

        public Endpoint interBrokerEndpoint() {
            return this.endpoints.iterator().next();
        }

        public Collection<String> earlyStartListeners() {
            ArrayList<String> result = new ArrayList<String>();
            for (Endpoint endpoint : this.endpoints) {
                if (!endpoint.listener().equals("CONTROLLER")) continue;
                result.add(endpoint.listener());
            }
            return result;
        }
    }
}

