/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class StandardAclTest {
    public static final List<StandardAcl> TEST_ACLS = new ArrayList<StandardAcl>();

    private static int signum(int input) {
        return Integer.compare(input, 0);
    }

    @Test
    public void testCompareTo() {
        Assertions.assertEquals((int)1, (int)StandardAclTest.signum(TEST_ACLS.get(0).compareTo(TEST_ACLS.get(1))));
        Assertions.assertEquals((int)-1, (int)StandardAclTest.signum(TEST_ACLS.get(1).compareTo(TEST_ACLS.get(0))));
        Assertions.assertEquals((int)-1, (int)StandardAclTest.signum(TEST_ACLS.get(2).compareTo(TEST_ACLS.get(3))));
        Assertions.assertEquals((int)1, (int)StandardAclTest.signum(TEST_ACLS.get(4).compareTo(TEST_ACLS.get(3))));
        Assertions.assertEquals((int)-1, (int)StandardAclTest.signum(TEST_ACLS.get(3).compareTo(TEST_ACLS.get(4))));
    }

    @Test
    public void testToBindingRoundTrips() {
        for (StandardAcl acl : TEST_ACLS) {
            AclBinding binding = acl.toBinding();
            StandardAcl acl2 = StandardAcl.fromAclBinding((AclBinding)binding);
            Assertions.assertEquals((Object)acl2, (Object)acl);
        }
    }

    @Test
    public void testEquals() {
        for (int i = 0; i != TEST_ACLS.size(); ++i) {
            for (int j = 0; j != TEST_ACLS.size(); ++j) {
                if (i == j) {
                    Assertions.assertEquals((Object)TEST_ACLS.get(i), (Object)TEST_ACLS.get(j));
                    continue;
                }
                Assertions.assertNotEquals((Object)TEST_ACLS.get(i), (Object)TEST_ACLS.get(j));
            }
        }
    }

    static {
        TEST_ACLS.add(new StandardAcl(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL, "User:*", "*", AclOperation.ALTER, AclPermissionType.ALLOW));
        TEST_ACLS.add(new StandardAcl(ResourceType.TOPIC, "foo_", PatternType.PREFIXED, "User:*", "*", AclOperation.READ, AclPermissionType.ALLOW));
        TEST_ACLS.add(new StandardAcl(ResourceType.GROUP, "mygroup", PatternType.LITERAL, "User:foo", "*", AclOperation.READ, AclPermissionType.DENY));
        TEST_ACLS.add(new StandardAcl(ResourceType.GROUP, "mygroup", PatternType.PREFIXED, "User:foo", "*", AclOperation.READ, AclPermissionType.DENY));
        TEST_ACLS.add(new StandardAcl(ResourceType.GROUP, "foo", PatternType.PREFIXED, "User:foo", "*", AclOperation.READ, AclPermissionType.DENY));
    }
}

