/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.metadata.ConfigRepository;

public class MockConfigRepository
implements ConfigRepository {
    private final Map<ConfigResource, Properties> configs = new HashMap<ConfigResource, Properties>();

    public static MockConfigRepository forTopic(String topic, String key, String value) {
        Properties properties = new Properties();
        properties.put(key, value);
        return MockConfigRepository.forTopic(topic, properties);
    }

    public static MockConfigRepository forTopic(String topic, Properties properties) {
        MockConfigRepository repository = new MockConfigRepository();
        repository.configs.put(new ConfigResource(ConfigResource.Type.TOPIC, topic), properties);
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties config(ConfigResource configResource) {
        Map<ConfigResource, Properties> map = this.configs;
        synchronized (map) {
            return this.configs.getOrDefault(configResource, new Properties());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(ConfigResource configResource, String key, String value) {
        Map<ConfigResource, Properties> map = this.configs;
        synchronized (map) {
            Properties properties = this.configs.getOrDefault(configResource, new Properties());
            Properties newProperties = new Properties();
            newProperties.putAll((Map<?, ?>)properties);
            newProperties.compute(key, (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> value));
            this.configs.put(configResource, newProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTopicConfig(String topicName, String key, String value) {
        Map<ConfigResource, Properties> map = this.configs;
        synchronized (map) {
            this.setConfig(new ConfigResource(ConfigResource.Type.TOPIC, topicName), key, value);
        }
    }
}

