/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.ControllerRegistrationRequestData;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RegisterControllerRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.ListenerInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class ListenerInfoTest {
    private static final Endpoint INTERNAL = new Endpoint("INTERNAL", SecurityProtocol.PLAINTEXT, null, 0);
    private static final Endpoint EXTERNAL = new Endpoint("EXTERNAL", SecurityProtocol.SASL_SSL, "example.com", 9092);
    private static final Endpoint SSL = new Endpoint("SSL", SecurityProtocol.SSL, "", 9093);
    private static final Endpoint SASL_PLAINTEXT = new Endpoint("SASL_PLAINTEXT", SecurityProtocol.SASL_PLAINTEXT, "example2.com", 9094);
    private static final List<Endpoint> ALL = List.of(INTERNAL, EXTERNAL, SSL, SASL_PLAINTEXT);

    @Test
    public void testNullHostname() {
        Assertions.assertNull((Object)ListenerInfo.create(List.of(INTERNAL)).firstListener().host());
    }

    @Test
    public void testNullHostnameGetsResolved() throws Exception {
        Assertions.assertNotNull((Object)ListenerInfo.create(List.of(INTERNAL)).withWildcardHostnamesResolved().firstListener().host());
    }

    @Test
    public void testEmptyHostname() {
        Assertions.assertEquals((Object)"", (Object)ListenerInfo.create(List.of(SSL)).firstListener().host());
    }

    @Test
    public void testEmptyHostnameGetsResolved() throws Exception {
        Assertions.assertNotEquals((Object)"", (Object)ListenerInfo.create(List.of(SSL)).withWildcardHostnamesResolved().firstListener().host());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3})
    public void testCreatePreservesOrdering(int startIndex) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (int i = 0; i < ALL.size(); ++i) {
            endpoints.add(ALL.get((i + startIndex) % ALL.size()));
        }
        ListenerInfo listenerInfo = ListenerInfo.create(endpoints);
        Assertions.assertEquals((Object)ALL.get(startIndex).listener(), (Object)listenerInfo.firstListener().listener());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3})
    public void testCreateWithExplicitFirstListener(int startIndex) {
        ListenerInfo listenerInfo = ListenerInfo.create(Optional.of(ALL.get(startIndex).listener()), ALL);
        Assertions.assertEquals((Object)ALL.get(startIndex).listener(), (Object)listenerInfo.firstListener().listener());
    }

    @Test
    public void testRoundTripToControllerRegistrationRequest() throws Exception {
        ListenerInfo listenerInfo = ListenerInfo.create(ALL).withWildcardHostnamesResolved().withEphemeralPortsCorrected(__ -> 9094);
        ListenerInfo newListenerInfo = ListenerInfo.fromControllerRegistrationRequest((ControllerRegistrationRequestData.ListenerCollection)listenerInfo.toControllerRegistrationRequest());
        Assertions.assertEquals((Object)listenerInfo, (Object)newListenerInfo);
    }

    @Test
    public void testToControllerRegistrationRequestFailsOnNullHost() {
        Assertions.assertThrows(RuntimeException.class, () -> ListenerInfo.create(List.of(INTERNAL)).toControllerRegistrationRequest());
    }

    @Test
    public void testToControllerRegistrationRequestFailsOnZeroPort() {
        Assertions.assertThrows(RuntimeException.class, () -> ListenerInfo.create(List.of(INTERNAL)).withWildcardHostnamesResolved().toControllerRegistrationRequest());
    }

    @Test
    public void testRoundTripToControllerRegistrationRecord() throws Exception {
        ListenerInfo listenerInfo = ListenerInfo.create(ALL).withWildcardHostnamesResolved().withEphemeralPortsCorrected(__ -> 9094);
        ListenerInfo newListenerInfo = ListenerInfo.fromControllerRegistrationRecord((RegisterControllerRecord.ControllerEndpointCollection)listenerInfo.toControllerRegistrationRecord());
        Assertions.assertEquals((Object)listenerInfo, (Object)newListenerInfo);
    }

    @Test
    public void testToControllerRegistrationRecordFailsOnNullHost() {
        Assertions.assertThrows(RuntimeException.class, () -> ListenerInfo.create(List.of(INTERNAL)).toControllerRegistrationRecord());
    }

    @Test
    public void testToControllerRegistrationRecordFailsOnZeroPort() {
        Assertions.assertThrows(RuntimeException.class, () -> ListenerInfo.create(List.of(INTERNAL)).withWildcardHostnamesResolved().toControllerRegistrationRecord());
    }

    @Test
    public void testRoundTripToBrokerRegistrationRequest() throws Exception {
        ListenerInfo listenerInfo = ListenerInfo.create(ALL).withWildcardHostnamesResolved().withEphemeralPortsCorrected(__ -> 9094);
        ListenerInfo newListenerInfo = ListenerInfo.fromBrokerRegistrationRequest((BrokerRegistrationRequestData.ListenerCollection)listenerInfo.toBrokerRegistrationRequest());
        Assertions.assertEquals((Object)listenerInfo, (Object)newListenerInfo);
    }

    @Test
    public void testToBrokerRegistrationRequestFailsOnNullHost() {
        Assertions.assertThrows(RuntimeException.class, () -> ListenerInfo.create(List.of(INTERNAL)).toBrokerRegistrationRequest());
    }

    @Test
    public void testToBrokerRegistrationRequestFailsOnZeroPort() {
        Assertions.assertThrows(RuntimeException.class, () -> ListenerInfo.create(List.of(INTERNAL)).withWildcardHostnamesResolved().toBrokerRegistrationRequest());
    }

    @Test
    public void testRoundTripToBrokerRegistrationRecord() throws Exception {
        ListenerInfo listenerInfo = ListenerInfo.create(ALL).withWildcardHostnamesResolved().withEphemeralPortsCorrected(__ -> 9094);
        ListenerInfo newListenerInfo = ListenerInfo.fromBrokerRegistrationRecord((RegisterBrokerRecord.BrokerEndpointCollection)listenerInfo.toBrokerRegistrationRecord());
        Assertions.assertEquals((Object)listenerInfo, (Object)newListenerInfo);
    }

    @Test
    public void testToBrokerRegistrationRecordFailsOnNullHost() {
        Assertions.assertThrows(RuntimeException.class, () -> ListenerInfo.create(List.of(INTERNAL)).toBrokerRegistrationRecord());
    }

    @Test
    public void testToBrokerRegistrationRecordFailsOnZeroPort() {
        Assertions.assertThrows(RuntimeException.class, () -> ListenerInfo.create(List.of(INTERNAL)).withWildcardHostnamesResolved().toBrokerRegistrationRecord());
    }

    @Test
    public void testToString() {
        ListenerInfo listenerInfo = ListenerInfo.create(List.of(EXTERNAL, SASL_PLAINTEXT));
        Assertions.assertEquals((Object)"ListenerInfo(Endpoint(listenerName='EXTERNAL', securityProtocol=SASL_SSL, host='example.com', port=9092), Endpoint(listenerName='SASL_PLAINTEXT', securityProtocol=SASL_PLAINTEXT, host='example2.com', port=9094))", (Object)listenerInfo.toString());
    }
}

