/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.List;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class LeaderAndIsrTest {
    @Test
    public void testRecoveringLeaderAndIsr() {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, List.of(Integer.valueOf(1), Integer.valueOf(2)));
        LeaderAndIsr recoveringLeaderAndIsr = leaderAndIsr.newRecoveringLeaderAndIsr(3, List.of(Integer.valueOf(3)));
        Assertions.assertEquals((int)3, (int)recoveringLeaderAndIsr.leader());
        Assertions.assertEquals(List.of(Integer.valueOf(3)), (Object)recoveringLeaderAndIsr.isr());
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERING, (Object)recoveringLeaderAndIsr.leaderRecoveryState());
    }

    @Test
    public void testNewLeaderAndIsr() {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, List.of(Integer.valueOf(1), Integer.valueOf(2)));
        LeaderAndIsr newLeaderAndIsr = leaderAndIsr.newLeaderAndIsr(2, List.of(Integer.valueOf(1), Integer.valueOf(2)));
        Assertions.assertEquals((int)2, (int)newLeaderAndIsr.leader());
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2)), (Object)newLeaderAndIsr.isr());
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERED, (Object)newLeaderAndIsr.leaderRecoveryState());
    }

    @Test
    public void testNewLeader() {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(2, List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
        Assertions.assertEquals((int)2, (int)leaderAndIsr.leader());
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), (Object)leaderAndIsr.isr());
        LeaderAndIsr newLeaderAndIsr = leaderAndIsr.newLeader(3);
        Assertions.assertEquals((int)3, (int)newLeaderAndIsr.leader());
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), (Object)newLeaderAndIsr.isr());
    }

    @Test
    public void testNewEpoch() {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(3, List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
        Assertions.assertEquals((int)0, (int)leaderAndIsr.leaderEpoch());
        LeaderAndIsr leaderWithNewEpoch = leaderAndIsr.newEpoch();
        Assertions.assertEquals((int)1, (int)leaderWithNewEpoch.leaderEpoch());
    }

    @Test
    public void testLeaderOpt() {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(2, List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
        Assertions.assertEquals((int)2, (Integer)leaderAndIsr.leaderOpt().orElse(0));
    }
}

