/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.RegisterControllerRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.ControllerRegistration;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ControllerRegistrationTest {
    private static final List<ControllerRegistration> REGISTRATIONS = List.of(new ControllerRegistration.Builder().setId(0).setIncarnationId(Uuid.fromString((String)"ycRmGrOFQru7HXf6fOybZQ")).setZkMigrationReady(true).setListeners(ControllerRegistrationTest.doubleMap("PLAINTEXT", new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9107), "SSL", new Endpoint("SSL", SecurityProtocol.SSL, "localhost", 9207))).setSupportedFeatures(Map.of("metadata.version", VersionRange.of((int)1, (int)10))).build(), new ControllerRegistration.Builder().setId(1).setIncarnationId(Uuid.fromString((String)"ubT_wuD6R3uopZ_lV76dQg")).setZkMigrationReady(true).setListeners(ControllerRegistrationTest.doubleMap("PLAINTEXT", new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9108), "SSL", new Endpoint("SSL", SecurityProtocol.SSL, "localhost", 9208))).setSupportedFeatures(Map.of("metadata.version", VersionRange.of((int)1, (int)10))).build(), new ControllerRegistration.Builder().setId(2).setIncarnationId(Uuid.fromString((String)"muQS341gRIeNh9Ps7reDSw")).setZkMigrationReady(false).setListeners(ControllerRegistrationTest.doubleMap("PLAINTEXT", new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9109), "SSL", new Endpoint("SSL", SecurityProtocol.SSL, "localhost", 9209))).setSupportedFeatures(Map.of("metadata.version", VersionRange.of((int)1, (int)10))).build());

    static <K, V> Map<K, V> doubleMap(K k1, V v1, K k2, V v2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    @Test
    public void testValues() {
        Assertions.assertEquals((int)0, (int)REGISTRATIONS.get(0).id());
        Assertions.assertEquals((int)1, (int)REGISTRATIONS.get(1).id());
        Assertions.assertEquals((int)2, (int)REGISTRATIONS.get(2).id());
    }

    @Test
    public void testEquals() {
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(0), (Object)REGISTRATIONS.get(1));
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(1), (Object)REGISTRATIONS.get(0));
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(0), (Object)REGISTRATIONS.get(2));
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(2), (Object)REGISTRATIONS.get(0));
        Assertions.assertEquals((Object)REGISTRATIONS.get(0), (Object)REGISTRATIONS.get(0));
        Assertions.assertEquals((Object)REGISTRATIONS.get(1), (Object)REGISTRATIONS.get(1));
        Assertions.assertEquals((Object)REGISTRATIONS.get(2), (Object)REGISTRATIONS.get(2));
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"ControllerRegistration(id=1, incarnationId=ubT_wuD6R3uopZ_lV76dQg, zkMigrationReady=true, listeners=[Endpoint(listenerName='PLAINTEXT', securityProtocol=PLAINTEXT, host='localhost', port=9108), Endpoint(listenerName='SSL', securityProtocol=SSL, host='localhost', port=9208)], supportedFeatures={metadata.version: 1-10})", (Object)REGISTRATIONS.get(1).toString());
    }

    @Test
    public void testFromRecordAndToRecord() {
        this.testRoundTrip(REGISTRATIONS.get(0));
        this.testRoundTrip(REGISTRATIONS.get(1));
        this.testRoundTrip(REGISTRATIONS.get(2));
    }

    private void testRoundTrip(ControllerRegistration registration) {
        ApiMessageAndVersion messageAndVersion = registration.toRecord(new ImageWriterOptions.Builder(MetadataVersion.latestProduction()).build());
        ControllerRegistration registration2 = new ControllerRegistration.Builder((RegisterControllerRecord)messageAndVersion.message()).build();
        Assertions.assertEquals((Object)registration, (Object)registration2);
        ApiMessageAndVersion messageAndVersion2 = registration2.toRecord(new ImageWriterOptions.Builder(MetadataVersion.latestProduction()).build());
        Assertions.assertEquals((Object)messageAndVersion, (Object)messageAndVersion2);
    }

    @Test
    public void testToNode() {
        Assertions.assertEquals(Optional.empty(), (Object)REGISTRATIONS.get(0).node("NONEXISTENT"));
        Assertions.assertEquals(Optional.of(new Node(0, "localhost", 9107, null)), (Object)REGISTRATIONS.get(0).node("PLAINTEXT"));
        Assertions.assertEquals(Optional.of(new Node(0, "localhost", 9207, null)), (Object)REGISTRATIONS.get(0).node("SSL"));
    }
}

