/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.writer;

import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.writer.ImageWriterClosedException;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.RecordTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class RecordListWriterTest {
    @Test
    public void testWrite() {
        RecordListWriter writer = new RecordListWriter();
        writer.write(RecordTestUtils.testRecord(0));
        writer.write(RecordTestUtils.testRecord(1));
        writer.close(true);
        Assertions.assertEquals(List.of(RecordTestUtils.testRecord(0), RecordTestUtils.testRecord(1)), (Object)writer.records());
    }

    @Test
    public void testCloseWithoutFreeze() {
        RecordListWriter writer = new RecordListWriter();
        writer.write(RecordTestUtils.testRecord(0));
        writer.close();
        Assertions.assertEquals(List.of(), (Object)writer.records());
    }

    @Test
    public void testWriteAfterClose() {
        RecordListWriter writer = new RecordListWriter();
        writer.close(true);
        Assertions.assertThrows(ImageWriterClosedException.class, () -> writer.write(0, (ApiMessage)new TopicRecord().setName("foo").setTopicId(Uuid.fromString((String)"3B134hrsQgKtz8Sp6QBIfg"))));
    }
}

