/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.writer;

import java.util.List;
import org.apache.kafka.image.FakeSnapshotWriter;
import org.apache.kafka.image.writer.RaftSnapshotWriter;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class RaftSnapshotWriterTest {
    @Test
    public void testFreezeAndClose() {
        FakeSnapshotWriter snapshotWriter = new FakeSnapshotWriter();
        RaftSnapshotWriter writer = new RaftSnapshotWriter((SnapshotWriter)snapshotWriter, 2);
        writer.write(RecordTestUtils.testRecord(0));
        writer.write(RecordTestUtils.testRecord(1));
        writer.write(RecordTestUtils.testRecord(2));
        writer.close(true);
        Assertions.assertTrue((boolean)snapshotWriter.isFrozen());
        Assertions.assertTrue((boolean)snapshotWriter.isClosed());
        Assertions.assertEquals(List.of(List.of(RecordTestUtils.testRecord(0), RecordTestUtils.testRecord(1)), List.of(RecordTestUtils.testRecord(2))), snapshotWriter.batches());
    }

    @Test
    public void testCloseWithoutFreeze() {
        FakeSnapshotWriter snapshotWriter = new FakeSnapshotWriter();
        RaftSnapshotWriter writer = new RaftSnapshotWriter((SnapshotWriter)snapshotWriter, 2);
        writer.write(RecordTestUtils.testRecord(0));
        writer.close();
        Assertions.assertFalse((boolean)snapshotWriter.isFrozen());
        Assertions.assertTrue((boolean)snapshotWriter.isClosed());
        Assertions.assertEquals(List.of(), snapshotWriter.batches());
    }
}

