/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.writer;

import java.util.function.Consumer;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.image.AclsImageTest;
import org.apache.kafka.image.ClientQuotasImageTest;
import org.apache.kafka.image.ClusterImageTest;
import org.apache.kafka.image.ConfigurationsImageTest;
import org.apache.kafka.image.DelegationTokenImageTest;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImageTest;
import org.apache.kafka.image.ScramImageTest;
import org.apache.kafka.image.TopicsImageTest;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.UnwritableMetadataException;
import org.apache.kafka.server.common.EligibleLeaderReplicasVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class ImageWriterOptionsTest {
    @Test
    public void testDefaultLossHandler() {
        ImageWriterOptions options = new ImageWriterOptions.Builder(MetadataVersion.latestProduction()).build();
        Assertions.assertEquals((Object)"stuff", (Object)((UnwritableMetadataException)Assertions.assertThrows(UnwritableMetadataException.class, () -> options.handleLoss("stuff"))).loss());
    }

    @Test
    public void testHandleLoss() {
        String expectedMessage = "stuff";
        for (int i = MetadataVersion.MINIMUM_VERSION.ordinal(); i < MetadataVersion.VERSIONS.length; ++i) {
            MetadataVersion version = MetadataVersion.VERSIONS[i];
            String formattedMessage = String.format("Metadata has been lost because the following could not be represented in metadata.version %s: %s", version, expectedMessage);
            Consumer<UnwritableMetadataException> customLossHandler = e -> Assertions.assertEquals((Object)formattedMessage, (Object)e.getMessage());
            ImageWriterOptions options = new ImageWriterOptions.Builder(version).setLossHandler(customLossHandler).build();
            options.handleLoss(expectedMessage);
        }
    }

    @Test
    public void testSetEligibleLeaderReplicasEnabled() {
        MetadataVersion version = MetadataVersion.MINIMUM_VERSION;
        ImageWriterOptions options = new ImageWriterOptions.Builder(version).setEligibleLeaderReplicasEnabled(true).build();
        Assertions.assertEquals((Object)true, (Object)options.isEligibleLeaderReplicasEnabled());
        options = new ImageWriterOptions.Builder(version).build();
        Assertions.assertEquals((Object)false, (Object)options.isEligibleLeaderReplicasEnabled());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testConstructionWithImage(boolean isElrEnabled) {
        FeaturesDelta featuresDelta = new FeaturesDelta(FeaturesImage.EMPTY);
        featuresDelta.replay(new FeatureLevelRecord().setName("eligible.leader.replicas.version").setFeatureLevel(isElrEnabled ? EligibleLeaderReplicasVersion.ELRV_1.featureLevel() : EligibleLeaderReplicasVersion.ELRV_0.featureLevel()));
        featuresDelta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_4_0_IV1.featureLevel()));
        MetadataImage metadataImage = new MetadataImage(new MetadataProvenance(100L, 4, 2000L, true), featuresDelta.apply(), ClusterImageTest.IMAGE1, TopicsImageTest.IMAGE1, ConfigurationsImageTest.IMAGE1, ClientQuotasImageTest.IMAGE1, ProducerIdsImageTest.IMAGE1, AclsImageTest.IMAGE1, ScramImageTest.IMAGE1, DelegationTokenImageTest.IMAGE1);
        ImageWriterOptions options = new ImageWriterOptions.Builder(metadataImage).build();
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV1, (Object)options.metadataVersion());
        if (isElrEnabled) {
            Assertions.assertEquals((Object)true, (Object)options.isEligibleLeaderReplicasEnabled());
        } else {
            Assertions.assertEquals((Object)false, (Object)options.isEligibleLeaderReplicasEnabled());
        }
    }
}

