/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.publisher.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.ControllerMetricsTestUtils;
import org.apache.kafka.image.publisher.metrics.SnapshotEmitterMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=40L)
public class SnapshotEmitterMetricsTest {
    private static final Logger log = LoggerFactory.getLogger(SnapshotEmitterMetricsTest.class);

    @Test
    public void testMetricNames() {
        try (SnapshotEmitterMetricsTestContext ctx = new SnapshotEmitterMetricsTestContext();){
            ControllerMetricsTestUtils.assertMetricsForTypeEqual(ctx.registry, "kafka.server:", new HashSet<String>(List.of("kafka.server:type=SnapshotEmitter,name=LatestSnapshotGeneratedBytes", "kafka.server:type=SnapshotEmitter,name=LatestSnapshotGeneratedAgeMs")));
            ctx.metrics.close();
            ControllerMetricsTestUtils.assertMetricsForTypeEqual(ctx.registry, "KafkaController", Set.of());
        }
    }

    @Test
    public void testLatestSnapshotGeneratedBytesMetric() {
        try (SnapshotEmitterMetricsTestContext ctx = new SnapshotEmitterMetricsTestContext();){
            Assertions.assertEquals((long)0L, (long)ctx.metrics.latestSnapshotGeneratedBytes());
            ctx.metrics.setLatestSnapshotGeneratedBytes(12345L);
            Assertions.assertEquals((long)12345L, (long)ctx.metrics.latestSnapshotGeneratedBytes());
            Assertions.assertEquals((long)12345L, (long)ctx.readLongGauge("LatestSnapshotGeneratedBytes"));
        }
    }

    @Test
    public void testLatestSnapshotGeneratedAgeMsMetric() {
        try (SnapshotEmitterMetricsTestContext ctx = new SnapshotEmitterMetricsTestContext();){
            Assertions.assertEquals((long)10000L, (long)ctx.metrics.latestSnapshotGeneratedTimeMs());
            Assertions.assertEquals((long)0L, (long)ctx.metrics.latestSnapshotGeneratedAgeMs());
            ctx.time.sleep(20000L);
            Assertions.assertEquals((long)10000L, (long)ctx.metrics.latestSnapshotGeneratedTimeMs());
            Assertions.assertEquals((long)20000L, (long)ctx.metrics.latestSnapshotGeneratedAgeMs());
            Assertions.assertEquals((long)20000L, (long)ctx.readLongGauge("LatestSnapshotGeneratedAgeMs"));
        }
    }

    static class SnapshotEmitterMetricsTestContext
    implements AutoCloseable {
        final MetricsRegistry registry = new MetricsRegistry();
        final MockTime time = new MockTime(0L, 10000L, 0L);
        final SnapshotEmitterMetrics metrics = new SnapshotEmitterMetrics(Optional.of(this.registry), (Time)this.time);

        SnapshotEmitterMetricsTestContext() {
        }

        long readLongGauge(String name) {
            MetricName metricName = new MetricName("kafka.server", "SnapshotEmitter", name, null, "kafka.server:type=SnapshotEmitter,name=" + name);
            return (Long)((Gauge)this.registry.allMetrics().get(metricName)).value();
        }

        @Override
        public void close() {
            try {
                this.registry.shutdown();
            }
            catch (Exception e) {
                log.error("Error closing registry", (Throwable)e);
            }
        }
    }
}

