/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.ConfigurationImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.node.ConfigurationsImageNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ConfigurationsImageNodeTest {
    private static final ConfigurationsImageNode NODE;

    @Test
    public void testNodeChildNames() {
        ArrayList childNames = new ArrayList(NODE.childNames());
        childNames.sort(String::compareTo);
        Assertions.assertEquals(List.of("BROKER", "BROKER:0", "TOPIC", "TOPIC::colons:", "TOPIC:__internal", "TOPIC:foobar"), childNames);
    }

    @Test
    public void testNodeChildNameParsing() {
        List<ConfigResource> childResources = NODE.childNames().stream().sorted().map(ConfigurationsImageNode::resourceFromName).toList();
        Assertions.assertEquals(List.of(new ConfigResource(ConfigResource.Type.BROKER, ""), new ConfigResource(ConfigResource.Type.BROKER, "0"), new ConfigResource(ConfigResource.Type.TOPIC, ""), new ConfigResource(ConfigResource.Type.TOPIC, ":colons:"), new ConfigResource(ConfigResource.Type.TOPIC, "__internal"), new ConfigResource(ConfigResource.Type.TOPIC, "foobar")), childResources);
    }

    static {
        HashMap<ConfigResource, ConfigurationImage> resourceMap = new HashMap<ConfigResource, ConfigurationImage>();
        for (ConfigResource resource : List.of(new ConfigResource(ConfigResource.Type.BROKER, ""), new ConfigResource(ConfigResource.Type.BROKER, "0"), new ConfigResource(ConfigResource.Type.TOPIC, ""), new ConfigResource(ConfigResource.Type.TOPIC, "foobar"), new ConfigResource(ConfigResource.Type.TOPIC, ":colons:"), new ConfigResource(ConfigResource.Type.TOPIC, "__internal"))) {
            resourceMap.put(resource, new ConfigurationImage(resource, Map.of("foo", "bar")));
        }
        ConfigurationsImage image = new ConfigurationsImage(resourceMap);
        NODE = new ConfigurationsImageNode(image);
    }
}

