/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.loader.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.controller.metrics.ControllerMetricsTestUtils;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.metrics.MetadataLoaderMetrics;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MetadataLoaderMetricsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricNames() {
        MetricsRegistry registry = new MetricsRegistry();
        try {
            try (FakeMetadataLoaderMetrics fakeMetrics = new FakeMetadataLoaderMetrics(registry);){
                ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.server", new HashSet<String>(List.of("kafka.server:type=MetadataLoader,name=CurrentControllerId", "kafka.server:type=MetadataLoader,name=CurrentMetadataVersion", "kafka.server:type=MetadataLoader,name=HandleLoadSnapshotCount")));
            }
            ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.server", Set.of());
        }
        finally {
            registry.shutdown();
        }
    }

    @Test
    public void testUpdateBatchProcessingTimeNs() {
        MetricsRegistry registry = new MetricsRegistry();
        try (FakeMetadataLoaderMetrics fakeMetrics = new FakeMetadataLoaderMetrics(registry);){
            fakeMetrics.metrics.updateBatchProcessingTimeNs(123L);
            Assertions.assertEquals((long)123L, (long)fakeMetrics.batchProcessingTimeNs.get());
        }
    }

    @Test
    public void testUpdateBatchSize() {
        MetricsRegistry registry = new MetricsRegistry();
        try (FakeMetadataLoaderMetrics fakeMetrics = new FakeMetadataLoaderMetrics(registry);){
            fakeMetrics.metrics.updateBatchSize(50);
            Assertions.assertEquals((int)50, (int)fakeMetrics.batchSize.get());
        }
    }

    @Test
    public void testUpdateLastAppliedImageProvenance() {
        MetricsRegistry registry = new MetricsRegistry();
        try (FakeMetadataLoaderMetrics fakeMetrics = new FakeMetadataLoaderMetrics(registry);){
            MetadataProvenance provenance = new MetadataProvenance(1L, 2, 3L, true);
            fakeMetrics.metrics.updateLastAppliedImageProvenance(provenance);
            Assertions.assertEquals((Object)provenance, (Object)fakeMetrics.provenance.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManagedMetrics() {
        MetricsRegistry registry = new MetricsRegistry();
        try {
            try (FakeMetadataLoaderMetrics fakeMetrics = new FakeMetadataLoaderMetrics(registry);){
                fakeMetrics.metrics.setCurrentMetadataVersion(MetadataVersion.MINIMUM_VERSION);
                fakeMetrics.metrics.incrementHandleLoadSnapshotCount();
                fakeMetrics.metrics.incrementHandleLoadSnapshotCount();
                Gauge currentMetadataVersion = (Gauge)registry.allMetrics().get(MetadataLoaderMetricsTest.metricName("MetadataLoader", "CurrentMetadataVersion"));
                Assertions.assertEquals((short)MetadataVersion.MINIMUM_VERSION.featureLevel(), (short)((Integer)currentMetadataVersion.value()).shortValue());
                Gauge loadSnapshotCount = (Gauge)registry.allMetrics().get(MetadataLoaderMetricsTest.metricName("MetadataLoader", "HandleLoadSnapshotCount"));
                Assertions.assertEquals((long)2L, (long)((Long)loadSnapshotCount.value()));
            }
            ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.server", Set.of());
        }
        finally {
            registry.shutdown();
        }
    }

    @Test
    public void testInitialValueOfCurrentControllerId() {
        try (FakeMetadataLoaderMetrics fakeMetrics = new FakeMetadataLoaderMetrics(Optional.empty());){
            Assertions.assertEquals((int)-1, (int)fakeMetrics.metrics.currentControllerId());
        }
    }

    @Test
    public void testSetValueOfCurrentControllerId() {
        try (FakeMetadataLoaderMetrics fakeMetrics = new FakeMetadataLoaderMetrics(Optional.empty());){
            fakeMetrics.metrics.setCurrentControllerId(1001);
            Assertions.assertEquals((int)1001, (int)fakeMetrics.metrics.currentControllerId());
        }
    }

    private static MetricName metricName(String type, String name) {
        String mBeanName = String.format("kafka.server:type=%s,name=%s", type, name);
        return new MetricName("kafka.server", type, name, null, mBeanName);
    }

    private static class FakeMetadataLoaderMetrics
    implements AutoCloseable {
        final AtomicLong batchProcessingTimeNs = new AtomicLong(0L);
        final AtomicInteger batchSize = new AtomicInteger(0);
        final AtomicReference<MetadataProvenance> provenance = new AtomicReference<MetadataProvenance>(MetadataProvenance.EMPTY);
        final MetadataLoaderMetrics metrics;

        FakeMetadataLoaderMetrics(MetricsRegistry registry) {
            this(Optional.of(registry));
        }

        FakeMetadataLoaderMetrics(Optional<MetricsRegistry> registry) {
            this.metrics = new MetadataLoaderMetrics(registry, this.batchProcessingTimeNs::set, this.batchSize::set, this.provenance);
        }

        @Override
        public void close() {
            this.metrics.close();
        }
    }
}

