/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.AbortTransactionRecord;
import org.apache.kafka.common.metadata.BeginTransactionRecord;
import org.apache.kafka.common.metadata.EndTransactionRecord;
import org.apache.kafka.common.metadata.NoOpRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LogDeltaManifest;
import org.apache.kafka.image.loader.MetadataBatchLoader;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class MetadataBatchLoaderTest {
    static final Uuid TOPIC_FOO = Uuid.fromString((String)"c6uHMgPkRp2Urjlh-RxMNQ");
    static final Uuid TOPIC_BAR = Uuid.fromString((String)"tUWOOPvzQhmZZ_eXmTCcig");
    static final List<ApiMessageAndVersion> TOPIC_TXN_BATCH_1;
    static final List<ApiMessageAndVersion> TOPIC_TXN_BATCH_2;
    static final List<ApiMessageAndVersion> TOPIC_NO_TXN_BATCH;
    static final List<ApiMessageAndVersion> TXN_BEGIN_SINGLETON;
    static final List<ApiMessageAndVersion> TXN_END_SINGLETON;
    static final List<ApiMessageAndVersion> TXN_ABORT_SINGLETON;
    static final LeaderAndEpoch LEADER_AND_EPOCH;

    static List<ApiMessageAndVersion> noOpRecords(int n) {
        return IntStream.range(0, n).mapToObj(__ -> new ApiMessageAndVersion((ApiMessage)new NoOpRecord(), 0)).toList();
    }

    @Test
    public void testAlignedTransactionBatches() {
        Batch batch1 = Batch.data((long)10L, (int)1, (long)0L, (int)10, TOPIC_TXN_BATCH_1);
        Batch batch2 = Batch.data((long)13L, (int)2, (long)0L, (int)10, MetadataBatchLoaderTest.noOpRecords(3));
        Batch batch3 = Batch.data((long)16L, (int)2, (long)0L, (int)30, TOPIC_TXN_BATCH_2);
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MetadataBatchLoader batchLoader = new MetadataBatchLoader(new LogContext(), (Time)new MockTime(), (FaultHandler)new MockFaultHandler("testAlignedTransactionBatches"), (MetadataBatchLoader.MetadataUpdater)updater);
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(batch1, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)0, (int)updater.updates);
        batchLoader.loadBatch(batch2, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)0, (int)updater.updates);
        batchLoader.loadBatch(batch3, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)0, (int)updater.updates);
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("foo"));
        Assertions.assertEquals((long)18L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertEquals((int)2, (int)updater.latestImage.provenance().lastContainedEpoch());
        Assertions.assertTrue((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
    }

    @Test
    public void testSingletonBeginAndEnd() {
        Batch batch1 = Batch.data((long)13L, (int)1, (long)0L, (int)30, MetadataBatchLoaderTest.noOpRecords(3));
        Batch batch2 = Batch.data((long)16L, (int)2, (long)0L, (int)30, TXN_BEGIN_SINGLETON);
        Batch batch3 = Batch.data((long)17L, (int)3, (long)0L, (int)10, TOPIC_NO_TXN_BATCH);
        Batch batch4 = Batch.data((long)20L, (int)4, (long)0L, (int)10, TXN_END_SINGLETON);
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MetadataBatchLoader batchLoader = new MetadataBatchLoader(new LogContext(), (Time)new MockTime(), (FaultHandler)new MockFaultHandler("testSingletonBeginAndEnd"), (MetadataBatchLoader.MetadataUpdater)updater);
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(batch1, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)0, (int)updater.updates);
        batchLoader.loadBatch(batch2, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertTrue((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        Assertions.assertNull((Object)updater.latestImage.topics().getTopic("bar"));
        batchLoader.loadBatch(batch3, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        batchLoader.loadBatch(batch4, LEADER_AND_EPOCH);
        Assertions.assertEquals((int)1, (int)updater.updates);
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("bar"));
        Assertions.assertEquals((long)20L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertEquals((int)4, (int)updater.latestImage.provenance().lastContainedEpoch());
        updater.reset();
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(batch1, LEADER_AND_EPOCH);
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)1, (int)updater.updates);
        batchLoader.loadBatch(batch2, LEADER_AND_EPOCH);
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)1, (int)updater.updates);
        batchLoader.loadBatch(batch3, LEADER_AND_EPOCH);
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)1, (int)updater.updates);
        batchLoader.loadBatch(batch4, LEADER_AND_EPOCH);
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)2, (int)updater.updates);
    }

    @Test
    public void testUnexpectedBeginTransaction() {
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MockFaultHandler faultHandler = new MockFaultHandler("testUnexpectedBeginTransaction");
        MetadataBatchLoader batchLoader = new MetadataBatchLoader(new LogContext(), (Time)new MockTime(), (FaultHandler)faultHandler, (MetadataBatchLoader.MetadataUpdater)updater);
        Batch batch1 = Batch.data((long)10L, (int)2, (long)0L, (int)30, TOPIC_TXN_BATCH_1);
        Batch batch2 = Batch.data((long)13L, (int)2, (long)0L, (int)30, TXN_BEGIN_SINGLETON);
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(batch1, LEADER_AND_EPOCH);
        Assertions.assertNull((Object)faultHandler.firstException());
        batchLoader.loadBatch(batch2, LEADER_AND_EPOCH);
        Assertions.assertEquals(RuntimeException.class, faultHandler.firstException().getCause().getClass());
        Assertions.assertEquals((Object)"Encountered BeginTransactionRecord while already in a transaction", (Object)faultHandler.firstException().getCause().getMessage());
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)0, (int)updater.updates);
    }

    @Test
    public void testUnexpectedEndTransaction() {
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MockFaultHandler faultHandler = new MockFaultHandler("testUnexpectedAbortTransaction");
        MetadataBatchLoader batchLoader = new MetadataBatchLoader(new LogContext(), (Time)new MockTime(), (FaultHandler)faultHandler, (MetadataBatchLoader.MetadataUpdater)updater);
        Batch batch1 = Batch.data((long)10L, (int)2, (long)0L, (int)30, TOPIC_NO_TXN_BATCH);
        Batch batch2 = Batch.data((long)13L, (int)2, (long)0L, (int)30, TXN_END_SINGLETON);
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(batch1, LEADER_AND_EPOCH);
        Assertions.assertNull((Object)faultHandler.firstException());
        batchLoader.loadBatch(batch2, LEADER_AND_EPOCH);
        Assertions.assertEquals(RuntimeException.class, faultHandler.firstException().getCause().getClass());
        Assertions.assertEquals((Object)"Encountered EndTransactionRecord without having seen a BeginTransactionRecord", (Object)faultHandler.firstException().getCause().getMessage());
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("bar"));
    }

    @Test
    public void testUnexpectedAbortTransaction() {
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MockFaultHandler faultHandler = new MockFaultHandler("testUnexpectedAbortTransaction");
        MetadataBatchLoader batchLoader = new MetadataBatchLoader(new LogContext(), (Time)new MockTime(), (FaultHandler)faultHandler, (MetadataBatchLoader.MetadataUpdater)updater);
        Batch batch1 = Batch.data((long)10L, (int)2, (long)0L, (int)30, TOPIC_NO_TXN_BATCH);
        Batch batch2 = Batch.data((long)13L, (int)2, (long)0L, (int)30, TXN_ABORT_SINGLETON);
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(batch1, LEADER_AND_EPOCH);
        Assertions.assertNull((Object)faultHandler.firstException());
        batchLoader.loadBatch(batch2, LEADER_AND_EPOCH);
        Assertions.assertEquals(RuntimeException.class, faultHandler.firstException().getCause().getClass());
        Assertions.assertEquals((Object)"Encountered AbortTransactionRecord without having seen a BeginTransactionRecord", (Object)faultHandler.firstException().getCause().getMessage());
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("bar"));
    }

    private MetadataBatchLoader loadSingleBatch(MockMetadataUpdater updater, MockFaultHandler faultHandler, List<ApiMessageAndVersion> batchRecords) {
        Batch batch = Batch.data((long)10L, (int)42, (long)0L, (int)100, batchRecords);
        MetadataBatchLoader batchLoader = new MetadataBatchLoader(new LogContext(), (Time)new MockTime(), (FaultHandler)faultHandler, (MetadataBatchLoader.MetadataUpdater)updater);
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(batch, LEADER_AND_EPOCH);
        return batchLoader;
    }

    @Test
    public void testMultipleTransactionsInOneBatch() {
        ArrayList<ApiMessageAndVersion> batchRecords = new ArrayList<ApiMessageAndVersion>();
        batchRecords.addAll(TOPIC_TXN_BATCH_1);
        batchRecords.addAll(TOPIC_TXN_BATCH_2);
        batchRecords.addAll(TXN_BEGIN_SINGLETON);
        batchRecords.addAll(TOPIC_NO_TXN_BATCH);
        batchRecords.addAll(TXN_END_SINGLETON);
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MockFaultHandler faultHandler = new MockFaultHandler("testMultipleTransactionsInOneBatch");
        MetadataBatchLoader batchLoader = this.loadSingleBatch(updater, faultHandler, batchRecords);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertEquals((long)0L, (long)updater.latestManifest.numBytes());
        Assertions.assertEquals((long)15L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertFalse((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        Assertions.assertEquals((int)42, (int)updater.latestImage.provenance().lastContainedEpoch());
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("foo"));
        Assertions.assertNull((Object)updater.latestImage.topics().getTopic("bar"));
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)2, (int)updater.updates);
        Assertions.assertEquals((long)100L, (long)updater.latestManifest.numBytes());
        Assertions.assertEquals((long)20L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertEquals((int)42, (int)updater.latestImage.provenance().lastContainedEpoch());
        Assertions.assertTrue((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("foo"));
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("bar"));
    }

    @Test
    public void testMultipleTransactionsInOneBatchesWithNoOp() {
        ArrayList<ApiMessageAndVersion> batchRecords = new ArrayList<ApiMessageAndVersion>();
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(1));
        batchRecords.addAll(TOPIC_TXN_BATCH_1);
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(1));
        batchRecords.addAll(TOPIC_TXN_BATCH_2);
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(1));
        batchRecords.addAll(TXN_BEGIN_SINGLETON);
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(1));
        batchRecords.addAll(TOPIC_NO_TXN_BATCH);
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(1));
        batchRecords.addAll(TXN_END_SINGLETON);
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(1));
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MockFaultHandler faultHandler = new MockFaultHandler("testMultipleTransactionsInOneBatches");
        MetadataBatchLoader batchLoader = this.loadSingleBatch(updater, faultHandler, batchRecords);
        Assertions.assertEquals((int)2, (int)updater.updates);
        Assertions.assertEquals((long)0L, (long)updater.latestManifest.numBytes());
        Assertions.assertEquals((long)18L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertEquals((int)42, (int)updater.latestImage.provenance().lastContainedEpoch());
        Assertions.assertFalse((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("foo"));
        Assertions.assertNull((Object)updater.latestImage.topics().getTopic("bar"));
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((int)3, (int)updater.updates);
        Assertions.assertEquals((long)100L, (long)updater.latestManifest.numBytes());
        Assertions.assertEquals((long)26L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertEquals((int)42, (int)updater.latestImage.provenance().lastContainedEpoch());
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("foo"));
        Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("bar"));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOneTransactionInMultipleBatches(boolean abortTxn) {
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MetadataBatchLoader batchLoader = new MetadataBatchLoader(new LogContext(), (Time)new MockTime(), (FaultHandler)new MockFaultHandler("testOneTransactionInMultipleBatches"), (MetadataBatchLoader.MetadataUpdater)updater);
        batchLoader.resetToImage(MetadataImage.EMPTY);
        batchLoader.loadBatch(Batch.data((long)16L, (int)2, (long)0L, (int)10, TXN_BEGIN_SINGLETON), LEADER_AND_EPOCH);
        Assertions.assertEquals((int)0, (int)updater.updates);
        batchLoader.loadBatch(Batch.data((long)17L, (int)3, (long)0L, (int)30, TOPIC_NO_TXN_BATCH), LEADER_AND_EPOCH);
        Assertions.assertEquals((int)0, (int)updater.updates);
        if (abortTxn) {
            batchLoader.loadBatch(Batch.data((long)20L, (int)4, (long)0L, (int)10, TXN_ABORT_SINGLETON), LEADER_AND_EPOCH);
        } else {
            batchLoader.loadBatch(Batch.data((long)20L, (int)4, (long)0L, (int)10, TXN_END_SINGLETON), LEADER_AND_EPOCH);
        }
        Assertions.assertEquals((int)0, (int)updater.updates);
        batchLoader.maybeFlushBatches(LEADER_AND_EPOCH, true);
        Assertions.assertEquals((long)50L, (long)updater.latestManifest.numBytes());
        Assertions.assertEquals((int)3, (int)updater.latestManifest.numBatches());
        Assertions.assertEquals((long)20L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertEquals((int)4, (int)updater.latestImage.provenance().lastContainedEpoch());
        if (abortTxn) {
            Assertions.assertNull((Object)updater.latestImage.topics().getTopic("bar"));
        } else {
            Assertions.assertNotNull((Object)updater.latestImage.topics().getTopic("bar"));
        }
    }

    @Test
    public void testTransactionAlignmentOnBatchBoundary() {
        ArrayList<ApiMessageAndVersion> batchRecords = new ArrayList<ApiMessageAndVersion>();
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(3));
        batchRecords.addAll(TOPIC_TXN_BATCH_1);
        batchRecords.addAll(TOPIC_TXN_BATCH_2);
        batchRecords.addAll(MetadataBatchLoaderTest.noOpRecords(3));
        MockMetadataUpdater updater = new MockMetadataUpdater();
        MockFaultHandler faultHandler = new MockFaultHandler("testMultipleTransactionsInOneBatch");
        MetadataBatchLoader batchLoader = this.loadSingleBatch(updater, faultHandler, batchRecords);
        Assertions.assertEquals((int)1, (int)updater.updates);
        Assertions.assertEquals((long)0L, (long)updater.latestManifest.numBytes());
        Assertions.assertEquals((long)12L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertFalse((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
        batchLoader.loadBatch(Batch.data((long)22L, (int)42, (long)0L, (int)10, TXN_BEGIN_SINGLETON), LEADER_AND_EPOCH);
        Assertions.assertEquals((int)2, (int)updater.updates);
        Assertions.assertEquals((long)100L, (long)updater.latestManifest.numBytes());
        Assertions.assertEquals((long)21L, (long)updater.latestImage.provenance().lastContainedOffset());
        Assertions.assertTrue((boolean)updater.latestImage.provenance().isOffsetBatchAligned());
    }

    static {
        LEADER_AND_EPOCH = new LeaderAndEpoch(OptionalInt.of(1), 42);
        TOPIC_TXN_BATCH_1 = List.of(new ApiMessageAndVersion((ApiMessage)new BeginTransactionRecord().setName("txn-1"), 0), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(TOPIC_FOO), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(TOPIC_FOO), 0));
        TOPIC_TXN_BATCH_2 = List.of(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(1).setTopicId(TOPIC_FOO), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(2).setTopicId(TOPIC_FOO), 0), new ApiMessageAndVersion((ApiMessage)new EndTransactionRecord(), 0));
        TOPIC_NO_TXN_BATCH = List.of(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("bar").setTopicId(TOPIC_BAR), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(TOPIC_BAR), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(1).setTopicId(TOPIC_BAR), 0));
        TXN_BEGIN_SINGLETON = List.of(new ApiMessageAndVersion((ApiMessage)new BeginTransactionRecord().setName("txn-1"), 0));
        TXN_END_SINGLETON = List.of(new ApiMessageAndVersion((ApiMessage)new EndTransactionRecord(), 0));
        TXN_ABORT_SINGLETON = List.of(new ApiMessageAndVersion((ApiMessage)new AbortTransactionRecord(), 0));
    }

    static class MockMetadataUpdater
    implements MetadataBatchLoader.MetadataUpdater {
        MetadataImage latestImage = null;
        MetadataDelta latestDelta = null;
        LogDeltaManifest latestManifest = null;
        int updates = 0;

        MockMetadataUpdater() {
        }

        public void update(MetadataDelta delta, MetadataImage image, LogDeltaManifest manifest) {
            this.latestDelta = delta;
            this.latestImage = image;
            this.latestManifest = manifest;
            ++this.updates;
        }

        public void reset() {
            this.latestImage = null;
            this.latestDelta = null;
            this.latestManifest = null;
            this.updates = 0;
        }
    }
}

