/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClearElrRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class TopicsImageTest {
    public static final TopicsImage IMAGE1;
    public static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final TopicsDelta DELTA1;
    static final TopicsImage IMAGE2;
    static final List<TopicImage> TOPIC_IMAGES1;
    public static final Uuid FOO_UUID;
    private static final Uuid FOO_UUID2;
    private static final Uuid BAR_UUID;
    private static final Uuid BAZ_UUID;
    private static final Uuid BAM_UUID;
    private static final Uuid BAM_UUID2;

    private static TopicImage newTopicImage(String name, Uuid id, PartitionRegistration ... partitions) {
        HashMap<Integer, PartitionRegistration> partitionMap = new HashMap<Integer, PartitionRegistration>();
        int i = 0;
        for (PartitionRegistration partition : partitions) {
            partitionMap.put(i++, partition);
        }
        return new TopicImage(name, id, partitionMap);
    }

    private static ImmutableMap<Uuid, TopicImage> newTopicsByIdMap(Collection<TopicImage> topics) {
        ImmutableMap map = TopicsImage.EMPTY.topicsById();
        for (TopicImage topic : topics) {
            map = map.updated((Object)topic.id(), (Object)topic);
        }
        return map;
    }

    private static ImmutableMap<String, TopicImage> newTopicsByNameMap(Collection<TopicImage> topics) {
        ImmutableMap map = TopicsImage.EMPTY.topicsByName();
        for (TopicImage topic : topics) {
            map = map.updated((Object)topic.name(), (Object)topic);
        }
        return map;
    }

    private ApiMessageAndVersion newPartitionRecord(Uuid topicId, int partitionId, List<Integer> replicas) {
        return new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(partitionId).setTopicId(topicId).setReplicas(replicas).setIsr(replicas).setLeader(replicas.get(0).intValue()).setLeaderEpoch(1).setPartitionEpoch(1), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion());
    }

    private PartitionRegistration newPartition(int[] replicas) {
        Uuid[] directories = new Uuid[replicas.length];
        for (int i = 0; i < replicas.length; ++i) {
            directories[i] = DirectoryId.random();
        }
        return new PartitionRegistration.Builder().setReplicas(replicas).setDirectories(directories).setIsr(replicas).setLeader(Integer.valueOf(replicas[0])).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(1)).build();
    }

    @Test
    public void testBasicLocalChanges() {
        int localId = 3;
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>(DELTA1_RECORDS);
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("bam").setTopicId(BAM_UUID2), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()));
        topicRecords.add(this.newPartitionRecord(BAM_UUID2, 0, List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))));
        topicRecords.add(this.newPartitionRecord(BAM_UUID2, 1, List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(localId))));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(1).setTopicId(BAZ_UUID).setReplicas(List.of(Integer.valueOf(4), Integer.valueOf(2), Integer.valueOf(localId))).setIsr(List.of(Integer.valueOf(4), Integer.valueOf(2), Integer.valueOf(localId))).setLeader(4).setLeaderEpoch(2).setPartitionEpoch(1), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(IMAGE1);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(new HashSet<TopicPartition>(List.of(new TopicPartition("baz", 0))), changes.electedLeaders().keySet());
        Assertions.assertEquals(new HashSet<TopicPartition>(List.of(new TopicPartition("baz", 0))), changes.leaders().keySet());
        Assertions.assertEquals(new HashSet<TopicPartition>(List.of(new TopicPartition("baz", 1), new TopicPartition("bar", 0), new TopicPartition("bam", 1))), changes.followers().keySet());
        TopicsImage finalImage = delta.apply();
        List<ApiMessageAndVersion> imageRecords = TopicsImageTest.getImageRecords(IMAGE1);
        imageRecords.addAll(topicRecords);
        TopicsImageTest.testToImage(finalImage, Optional.of(imageRecords));
    }

    @Test
    public void testDeleteAfterChanges() {
        int localId = 3;
        Uuid zooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("zoo", zooId, this.newPartition(new int[]{localId, 1, 2})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics));
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(0).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(zooId), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(new HashSet<TopicPartition>(List.of(new TopicPartition("zoo", 0))), (Object)changes.deletes());
        Assertions.assertEquals(Map.of(), (Object)changes.electedLeaders());
        Assertions.assertEquals(Map.of(), (Object)changes.leaders());
        Assertions.assertEquals(Map.of(), (Object)changes.followers());
        TopicsImage finalImage = delta.apply();
        List<ApiMessageAndVersion> imageRecords = TopicsImageTest.getImageRecords(image);
        imageRecords.addAll(topicRecords);
        TopicsImageTest.testToImage(finalImage, Optional.of(imageRecords));
    }

    @Test
    public void testUpdatedLeaders() {
        int localId = 3;
        Uuid zooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("zoo", zooId, this.newPartition(new int[]{localId, 1, 2})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics));
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(0).setIsr(List.of(Integer.valueOf(localId), Integer.valueOf(1))), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(Set.of(), (Object)changes.deletes());
        Assertions.assertEquals(Map.of(), (Object)changes.electedLeaders());
        Assertions.assertEquals(new HashSet<TopicPartition>(List.of(new TopicPartition("zoo", 0))), changes.leaders().keySet());
        Assertions.assertEquals(Map.of(), (Object)changes.followers());
    }

    @Test
    public void testClearElrRecords() {
        Uuid fooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        Uuid barId = Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw");
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("foo", fooId, this.newPartition(new int[]{0, 1, 2, 3})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics));
        ArrayList<Object> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(fooId).setPartitionId(0).setIsr(List.of(Integer.valueOf(0), Integer.valueOf(1))).setEligibleLeaderReplicas(List.of(Integer.valueOf(2))).setLastKnownElr(List.of(Integer.valueOf(3))), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image);
        RecordTestUtils.replayAll(delta, topicRecords);
        image = delta.apply();
        Assertions.assertEquals((int)1, (int)((PartitionRegistration)image.getTopic((Uuid)fooId).partitions().get((Object)Integer.valueOf((int)0))).elr.length);
        Assertions.assertEquals((int)1, (int)((PartitionRegistration)image.getTopic((Uuid)fooId).partitions().get((Object)Integer.valueOf((int)0))).lastKnownElr.length);
        topicRecords = new ArrayList();
        topicRecords.addAll(List.of(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setTopicId(barId).setName("bar"), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setTopicId(barId).setPartitionId(0).setLeader(0).setIsr(List.of(Integer.valueOf(1))).setEligibleLeaderReplicas(List.of(Integer.valueOf(2))).setLastKnownElr(List.of(Integer.valueOf(3))), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new ClearElrRecord().setTopicName("bar"), MetadataRecordType.CLEAR_ELR_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new ClearElrRecord(), MetadataRecordType.CLEAR_ELR_RECORD.highestSupportedVersion())));
        delta = new TopicsDelta(image);
        RecordTestUtils.replayAll(delta, topicRecords);
        image = delta.apply();
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)fooId).partitions().get((Object)Integer.valueOf((int)0))).elr.length);
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)fooId).partitions().get((Object)Integer.valueOf((int)0))).lastKnownElr.length);
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)barId).partitions().get((Object)Integer.valueOf((int)0))).elr.length);
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)barId).partitions().get((Object)Integer.valueOf((int)0))).lastKnownElr.length);
    }

    @Test
    public void testClearElrRecordOnNonExistingTopic() {
        TopicsImage image = TopicsImage.EMPTY;
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.addAll(List.of(new ApiMessageAndVersion((ApiMessage)new ClearElrRecord().setTopicName("foo"), MetadataRecordType.CLEAR_ELR_RECORD.highestSupportedVersion())));
        TopicsDelta delta = new TopicsDelta(image);
        Assertions.assertThrows(RuntimeException.class, () -> RecordTestUtils.replayAll(delta, topicRecords));
    }

    @Test
    public void testClearElrRecords_All_ForDeletedTopics() {
        Uuid fooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        Uuid fooId2 = Uuid.randomUuid();
        Uuid barId = Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw");
        Uuid barId2 = Uuid.randomUuid();
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("foo", fooId, this.newPartition(new int[]{0, 1, 2, 3})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics));
        ArrayList<Object> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setTopicId(fooId).setPartitionId(0).setLeader(0).setIsr(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image);
        RecordTestUtils.replayAll(delta, topicRecords);
        image = delta.apply();
        topicRecords = new ArrayList();
        topicRecords.addAll(List.of(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(fooId), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setTopicId(fooId2).setName("foo"), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setTopicId(fooId2).setPartitionId(0).setIsr(List.of(Integer.valueOf(0), Integer.valueOf(1))).setEligibleLeaderReplicas(List.of(Integer.valueOf(2))).setLastKnownElr(List.of(Integer.valueOf(3))), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setTopicId(barId).setName("bar"), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setTopicId(barId).setPartitionId(0).setLeader(0).setIsr(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(barId), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setTopicId(barId2).setName("bar"), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setTopicId(barId2).setPartitionId(0).setLeader(0).setIsr(List.of(Integer.valueOf(1))).setEligibleLeaderReplicas(List.of(Integer.valueOf(2))).setLastKnownElr(List.of(Integer.valueOf(3))), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new ClearElrRecord(), MetadataRecordType.CLEAR_ELR_RECORD.highestSupportedVersion())));
        delta = new TopicsDelta(image);
        RecordTestUtils.replayAll(delta, topicRecords);
        image = delta.apply();
        Assertions.assertEquals((int)2, (int)image.topicsById().size());
        Assertions.assertEquals((int)2, (int)image.topicsByName().size());
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)fooId2).partitions().get((Object)Integer.valueOf((int)0))).elr.length);
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)fooId2).partitions().get((Object)Integer.valueOf((int)0))).lastKnownElr.length);
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)barId2).partitions().get((Object)Integer.valueOf((int)0))).elr.length);
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)barId2).partitions().get((Object)Integer.valueOf((int)0))).lastKnownElr.length);
    }

    @Test
    public void testClearElrRecords_Single_ForDeletedTopics() {
        Uuid fooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        Uuid fooId2 = Uuid.randomUuid();
        Uuid barId = Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw");
        Uuid barId2 = Uuid.randomUuid();
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("foo", fooId, this.newPartition(new int[]{0, 1, 2, 3})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics));
        ArrayList<Object> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setTopicId(fooId).setPartitionId(0).setLeader(0).setIsr(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image);
        RecordTestUtils.replayAll(delta, topicRecords);
        image = delta.apply();
        topicRecords = new ArrayList();
        topicRecords.addAll(List.of(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(fooId), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setTopicId(fooId2).setName("foo"), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setTopicId(fooId2).setPartitionId(0).setIsr(List.of(Integer.valueOf(0), Integer.valueOf(1))).setEligibleLeaderReplicas(List.of(Integer.valueOf(2))).setLastKnownElr(List.of(Integer.valueOf(3))), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setTopicId(barId).setName("bar"), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setTopicId(barId).setPartitionId(0).setLeader(0).setIsr(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(barId), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setTopicId(barId2).setName("bar"), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setTopicId(barId2).setPartitionId(0).setLeader(0).setIsr(List.of(Integer.valueOf(1))).setEligibleLeaderReplicas(List.of(Integer.valueOf(2))).setLastKnownElr(List.of(Integer.valueOf(3))), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new ClearElrRecord().setTopicName("foo"), MetadataRecordType.CLEAR_ELR_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new ClearElrRecord().setTopicName("bar"), MetadataRecordType.CLEAR_ELR_RECORD.highestSupportedVersion())));
        delta = new TopicsDelta(image);
        RecordTestUtils.replayAll(delta, topicRecords);
        image = delta.apply();
        Assertions.assertEquals((int)2, (int)image.topicsById().size());
        Assertions.assertEquals((int)2, (int)image.topicsByName().size());
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)fooId2).partitions().get((Object)Integer.valueOf((int)0))).elr.length);
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)fooId2).partitions().get((Object)Integer.valueOf((int)0))).lastKnownElr.length);
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)barId2).partitions().get((Object)Integer.valueOf((int)0))).elr.length);
        Assertions.assertEquals((int)0, (int)((PartitionRegistration)image.getTopic((Uuid)barId2).partitions().get((Object)Integer.valueOf((int)0))).lastKnownElr.length);
    }

    @Test
    public void testClearElrRecordForNonExistTopic() {
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(List.of()), TopicsImageTest.newTopicsByNameMap(List.of()));
        TopicsDelta delta = new TopicsDelta(image);
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.addAll(List.of(new ApiMessageAndVersion((ApiMessage)new ClearElrRecord().setTopicName("non-exist"), MetadataRecordType.CLEAR_ELR_RECORD.highestSupportedVersion())));
        Assertions.assertThrows(RuntimeException.class, () -> RecordTestUtils.replayAll(delta, topicRecords));
    }

    @Test
    public void testTopicDeltaElectionStatsWithEmptyImage() {
        TopicImage image = new TopicImage("topic", Uuid.randomUuid(), Map.of());
        TopicDelta delta = new TopicDelta(image);
        delta.replay(new PartitionRecord().setPartitionId(0).setLeader(0).setIsr(List.of(Integer.valueOf(0), Integer.valueOf(1))).setReplicas(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))));
        delta.replay(new PartitionChangeRecord().setPartitionId(0).setLeader(2).setIsr(List.of(Integer.valueOf(2))).setLeaderRecoveryState(LeaderRecoveryState.RECOVERING.value()));
        Assertions.assertEquals((int)1, (Integer)((Integer)delta.partitionToUncleanLeaderElectionCount().get(0)));
        delta.replay(new PartitionChangeRecord().setPartitionId(0).setIsr(List.of(Integer.valueOf(1), Integer.valueOf(2))).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()));
        Assertions.assertEquals((int)1, (Integer)((Integer)delta.partitionToUncleanLeaderElectionCount().get(0)));
        delta.replay(new PartitionChangeRecord().setPartitionId(0).setLeader(0).setIsr(List.of(Integer.valueOf(0))).setLeaderRecoveryState(LeaderRecoveryState.RECOVERING.value()));
        Assertions.assertEquals((int)2, (Integer)((Integer)delta.partitionToUncleanLeaderElectionCount().get(0)));
        delta.replay(new PartitionChangeRecord().setPartitionId(0).setLeader(1).setIsr(List.of(Integer.valueOf(1))).setLeaderRecoveryState(LeaderRecoveryState.RECOVERING.value()));
        Assertions.assertEquals((int)3, (Integer)((Integer)delta.partitionToUncleanLeaderElectionCount().get(0)));
        Assertions.assertTrue((boolean)delta.partitionToElrElectionCount().isEmpty());
        delta.replay(new PartitionRecord().setPartitionId(1).setLeader(0).setIsr(List.of(Integer.valueOf(0), Integer.valueOf(1))).setReplicas(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))));
        delta.replay(new PartitionChangeRecord().setPartitionId(1).setLeader(-1).setIsr(List.of()).setEligibleLeaderReplicas(List.of(Integer.valueOf(0), Integer.valueOf(1))));
        Assertions.assertTrue((boolean)delta.partitionToElrElectionCount().isEmpty());
        delta.replay(new PartitionChangeRecord().setPartitionId(1).setLeader(1).setIsr(List.of(Integer.valueOf(1))).setEligibleLeaderReplicas(List.of(Integer.valueOf(0), Integer.valueOf(1))));
        Assertions.assertEquals((int)1, (Integer)((Integer)delta.partitionToElrElectionCount().get(1)));
    }

    @Test
    public void testTopicDeltaElectionStatsWithNonEmptyImage() {
        TopicImage image = new TopicImage("topic", Uuid.randomUuid(), Map.of(0, new PartitionRegistration(new PartitionRecord().setPartitionId(0).setLeader(0).setIsr(List.of(Integer.valueOf(0), Integer.valueOf(1))).setReplicas(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)))), 1, new PartitionRegistration(new PartitionRecord().setPartitionId(1).setLeader(-1).setIsr(List.of()).setEligibleLeaderReplicas(List.of(Integer.valueOf(0), Integer.valueOf(1))).setReplicas(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))))));
        TopicDelta delta = new TopicDelta(image);
        delta.replay(new PartitionRecord().setPartitionId(0).setLeader(2).setIsr(List.of(Integer.valueOf(2))).setReplicas(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))).setLeaderRecoveryState(LeaderRecoveryState.RECOVERING.value()));
        Assertions.assertEquals((int)1, (Integer)((Integer)delta.partitionToUncleanLeaderElectionCount().get(0)));
        Assertions.assertTrue((boolean)delta.partitionToElrElectionCount().isEmpty());
        delta.replay(new PartitionChangeRecord().setPartitionId(1).setLeader(1).setIsr(List.of(Integer.valueOf(1))).setEligibleLeaderReplicas(List.of(Integer.valueOf(0), Integer.valueOf(1))));
        Assertions.assertEquals((int)1, (Integer)((Integer)delta.partitionToElrElectionCount().get(1)));
    }

    @Test
    public void testLocalReassignmentChanges() {
        int localId = 3;
        Uuid zooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("zoo", zooId, this.newPartition(new int[]{0, 1, localId}), this.newPartition(new int[]{localId, 1, 2}), this.newPartition(new int[]{0, 1, localId}), this.newPartition(new int[]{localId, 1, 2}), this.newPartition(new int[]{0, 1, 2}), this.newPartition(new int[]{0, 1, 2})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics));
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(0).setLeader(localId), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(1).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(2).setIsr(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))).setReplicas(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(3).setLeader(0).setIsr(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))).setReplicas(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(4).setLeader(localId).setIsr(List.of(Integer.valueOf(localId), Integer.valueOf(1), Integer.valueOf(2))).setReplicas(List.of(Integer.valueOf(localId), Integer.valueOf(1), Integer.valueOf(2))), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(5).setIsr(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(localId))).setReplicas(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(localId))), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(new HashSet<TopicPartition>(List.of(new TopicPartition("zoo", 2), new TopicPartition("zoo", 3))), (Object)changes.deletes());
        Assertions.assertEquals(new HashSet<TopicPartition>(List.of(new TopicPartition("zoo", 0), new TopicPartition("zoo", 4))), changes.electedLeaders().keySet());
        Assertions.assertEquals(new HashSet<TopicPartition>(List.of(new TopicPartition("zoo", 0), new TopicPartition("zoo", 4))), changes.leaders().keySet());
        Assertions.assertEquals(new HashSet<TopicPartition>(List.of(new TopicPartition("zoo", 1), new TopicPartition("zoo", 5))), changes.followers().keySet());
        TopicsImage finalImage = delta.apply();
        List<ApiMessageAndVersion> imageRecords = TopicsImageTest.getImageRecords(image);
        imageRecords.addAll(topicRecords);
        TopicsImageTest.testToImage(finalImage, Optional.of(imageRecords));
    }

    @Test
    public void testEmptyImageRoundTrip() {
        TopicsImageTest.testToImage(TopicsImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() {
        TopicsImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testApplyDelta1() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
        List<ApiMessageAndVersion> records = TopicsImageTest.getImageRecords(IMAGE1);
        records.addAll(DELTA1_RECORDS);
        TopicsImageTest.testToImage(IMAGE2, records);
    }

    @Test
    public void testImage2RoundTrip() {
        TopicsImageTest.testToImage(IMAGE2);
    }

    private static void testToImage(TopicsImage image) {
        TopicsImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(TopicsImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        TopicsImageTest.testToImage(image, fromRecords.orElseGet(() -> TopicsImageTest.getImageRecords(image)));
    }

    private static void testToImage(TopicsImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<TopicsDelta, TopicsImage>(() -> TopicsImage.EMPTY, TopicsDelta::new).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(TopicsImage image) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(MetadataVersion.latestProduction()).build());
        return writer.records();
    }

    @Test
    public void testTopicNameToIdView() {
        Map map = IMAGE1.topicNameToIdView();
        Assertions.assertTrue((boolean)map.containsKey("foo"));
        Assertions.assertEquals((Object)FOO_UUID, map.get("foo"));
        Assertions.assertTrue((boolean)map.containsKey("bar"));
        Assertions.assertEquals((Object)BAR_UUID, map.get("bar"));
        Assertions.assertFalse((boolean)map.containsKey("baz"));
        Assertions.assertNull(map.get("baz"));
        HashSet uuids = new HashSet();
        map.values().iterator().forEachRemaining(uuids::add);
        HashSet<Uuid> expectedUuids = new HashSet<Uuid>(List.of(Uuid.fromString((String)"ThIaNwRnSM2Nt9Mx1v0RvA"), Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw")));
        Assertions.assertEquals(expectedUuids, uuids);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.remove("foo"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put("bar", FOO_UUID));
    }

    @Test
    public void testTopicIdToNameView() {
        Map map = IMAGE1.topicIdToNameView();
        Assertions.assertTrue((boolean)map.containsKey(FOO_UUID));
        Assertions.assertEquals((Object)"foo", map.get(FOO_UUID));
        Assertions.assertTrue((boolean)map.containsKey(BAR_UUID));
        Assertions.assertEquals((Object)"bar", map.get(BAR_UUID));
        Assertions.assertFalse((boolean)map.containsKey(BAZ_UUID));
        Assertions.assertNull(map.get(BAZ_UUID));
        HashSet names = new HashSet();
        map.values().iterator().forEachRemaining(names::add);
        HashSet<String> expectedNames = new HashSet<String>(List.of("foo", "bar"));
        Assertions.assertEquals(expectedNames, names);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.remove(FOO_UUID));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put(FOO_UUID, "bar"));
    }

    static {
        FOO_UUID = Uuid.fromString((String)"ThIaNwRnSM2Nt9Mx1v0RvA");
        FOO_UUID2 = Uuid.fromString((String)"9d3lha5qv8DoIl93jf8pbX");
        BAR_UUID = Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw");
        BAZ_UUID = Uuid.fromString((String)"tgHBnRglT5W_RlENnuG5vg");
        BAM_UUID = Uuid.fromString((String)"b66ybsWIQoygs01vdjH07A");
        BAM_UUID2 = Uuid.fromString((String)"yd6Sq3a9aK1G8snlKv7ag5");
        TOPIC_IMAGES1 = List.of(TopicsImageTest.newTopicImage("foo", FOO_UUID, new PartitionRegistration.Builder().setReplicas(new int[]{2, 3, 4}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{2, 3}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(345)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{3, 4, 5}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{3, 4, 5}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(4)).setPartitionEpoch(Integer.valueOf(684)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{2, 4, 5}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{2, 4, 5}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(10)).setPartitionEpoch(Integer.valueOf(84)).build()), TopicsImageTest.newTopicImage("bar", BAR_UUID, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2, 3, 4}).setDirectories(DirectoryId.migratingArray((int)5)).setIsr(new int[]{0, 1, 2, 3}).setRemovingReplicas(new int[]{1}).setAddingReplicas(new int[]{3, 4}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(345)).build()));
        IMAGE1 = new TopicsImage(TopicsImageTest.newTopicsByIdMap(TOPIC_IMAGES1), TopicsImageTest.newTopicsByNameMap(TOPIC_IMAGES1));
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(FOO_UUID), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(BAR_UUID).setPartitionId(0).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("baz").setTopicId(BAZ_UUID), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(BAZ_UUID).setReplicas(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4))).setIsr(List.of(Integer.valueOf(3), Integer.valueOf(4))).setRemovingReplicas(List.of(Integer.valueOf(2))).setAddingReplicas(List.of(Integer.valueOf(1))).setLeader(3).setLeaderEpoch(2).setPartitionEpoch(1), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(FOO_UUID2), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("bam").setTopicId(BAM_UUID), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(BAM_UUID), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()));
        DELTA1 = new TopicsDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        List<TopicImage> topics2 = List.of(TopicsImageTest.newTopicImage("foo", FOO_UUID2, new PartitionRegistration[0]), TopicsImageTest.newTopicImage("bar", BAR_UUID, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2, 3, 4}).setDirectories(DirectoryId.migratingArray((int)5)).setIsr(new int[]{0, 1, 2, 3}).setRemovingReplicas(new int[]{1}).setAddingReplicas(new int[]{3, 4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(2)).setPartitionEpoch(Integer.valueOf(346)).build()), TopicsImageTest.newTopicImage("baz", BAZ_UUID, new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setDirectories(DirectoryId.migratingArray((int)4)).setIsr(new int[]{3, 4}).setRemovingReplicas(new int[]{2}).setAddingReplicas(new int[]{1}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(2)).setPartitionEpoch(Integer.valueOf(1)).build()));
        IMAGE2 = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics2), TopicsImageTest.newTopicsByNameMap(topics2));
    }
}

