/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import org.apache.kafka.image.MetadataVersionChange;
import org.apache.kafka.image.MetadataVersionChangeException;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class MetadataVersionChangeTest {
    private static final MetadataVersionChange CHANGE_MINIMUM_TO_LATEST = new MetadataVersionChange(MetadataVersion.MINIMUM_VERSION, MetadataVersion.latestProduction());
    private static final MetadataVersionChange CHANGE_LATEST_TO_MINIMUM = new MetadataVersionChange(MetadataVersion.latestProduction(), MetadataVersion.MINIMUM_VERSION);

    @Test
    public void testIsUpgrade() {
        Assertions.assertTrue((boolean)CHANGE_MINIMUM_TO_LATEST.isUpgrade());
        Assertions.assertFalse((boolean)CHANGE_LATEST_TO_MINIMUM.isUpgrade());
    }

    @Test
    public void testIsDowngrade() {
        Assertions.assertFalse((boolean)CHANGE_MINIMUM_TO_LATEST.isDowngrade());
        Assertions.assertTrue((boolean)CHANGE_LATEST_TO_MINIMUM.isDowngrade());
    }

    @Test
    public void testMetadataVersionChangeExceptionToString() {
        Assertions.assertEquals((Object)("org.apache.kafka.image.MetadataVersionChangeException: The metadata.version is changing from " + String.valueOf(MetadataVersion.MINIMUM_VERSION) + " to " + String.valueOf(MetadataVersion.latestProduction())), (Object)new MetadataVersionChangeException(CHANGE_MINIMUM_TO_LATEST).toString());
        Assertions.assertEquals((Object)("org.apache.kafka.image.MetadataVersionChangeException: The metadata.version is changing from " + String.valueOf(MetadataVersion.latestProduction()) + " to " + String.valueOf(MetadataVersion.MINIMUM_VERSION)), (Object)new MetadataVersionChangeException(CHANGE_LATEST_TO_MINIMUM).toString());
    }
}

