/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.AclsImageTest;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClientQuotasImageTest;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterImageTest;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.ConfigurationsImageTest;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.DelegationTokenImageTest;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.FeaturesImageTest;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ProducerIdsImageTest;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.ScramImageTest;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.TopicsImageTest;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class MetadataImageTest {
    public static final MetadataImage IMAGE1 = new MetadataImage(new MetadataProvenance(100L, 4, 2000L, true), FeaturesImageTest.IMAGE1, ClusterImageTest.IMAGE1, TopicsImageTest.IMAGE1, ConfigurationsImageTest.IMAGE1, ClientQuotasImageTest.IMAGE1, ProducerIdsImageTest.IMAGE1, AclsImageTest.IMAGE1, ScramImageTest.IMAGE1, DelegationTokenImageTest.IMAGE1);
    public static final MetadataDelta DELTA1 = new MetadataDelta.Builder().setImage(IMAGE1).build();
    public static final MetadataImage IMAGE2;

    @Test
    public void testEmptyImageRoundTrip() {
        MetadataImage image = MetadataImage.EMPTY;
        MetadataVersion metadataVersion = MetadataVersion.MINIMUM_VERSION;
        ImageWriterOptions options = new ImageWriterOptions.Builder(metadataVersion).build();
        MetadataImage expectedImage = new MetadataImage(MetadataProvenance.EMPTY, new FeaturesImage(Map.of(), metadataVersion), ClusterImage.EMPTY, TopicsImage.EMPTY, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY);
        MetadataImageTest.testToImage(expectedImage, MetadataImageTest.getImageRecords(image, options));
    }

    @Test
    public void testImage1RoundTrip() {
        MetadataImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testApplyDelta1() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply(IMAGE2.provenance()));
        ImageWriterOptions options = new ImageWriterOptions.Builder(IMAGE1.features().metadataVersionOrThrow()).build();
        List<ApiMessageAndVersion> records = MetadataImageTest.getImageRecords(IMAGE1, options);
        records.addAll(FeaturesImageTest.DELTA1_RECORDS);
        records.addAll(ClusterImageTest.DELTA1_RECORDS);
        records.addAll(TopicsImageTest.DELTA1_RECORDS);
        records.addAll(ConfigurationsImageTest.DELTA1_RECORDS);
        records.addAll(ClientQuotasImageTest.DELTA1_RECORDS);
        records.addAll(ProducerIdsImageTest.DELTA1_RECORDS);
        records.addAll(AclsImageTest.DELTA1_RECORDS);
        records.addAll(ScramImageTest.DELTA1_RECORDS);
        records.addAll(DelegationTokenImageTest.DELTA1_RECORDS);
        MetadataImageTest.testToImage(IMAGE2, records);
    }

    @Test
    public void testImage2RoundTrip() {
        MetadataImageTest.testToImage(IMAGE2);
    }

    private static void testToImage(MetadataImage image) {
        MetadataImageTest.testToImage(image, new ImageWriterOptions.Builder(image.features().metadataVersionOrThrow()).build(), Optional.empty());
    }

    static void testToImage(MetadataImage image, ImageWriterOptions options, Optional<List<ApiMessageAndVersion>> fromRecords) {
        MetadataImageTest.testToImage(image, fromRecords.orElseGet(() -> MetadataImageTest.getImageRecords(image, options)));
    }

    private static void testToImage(final MetadataImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<MetadataDelta, MetadataImage>(() -> MetadataImage.EMPTY, MetadataDelta::new){

            @Override
            public MetadataImage createImageByApplyingDelta(MetadataDelta delta) {
                return delta.apply(image.provenance());
            }
        }.test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(MetadataImage image, ImageWriterOptions options) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, options);
        return writer.records();
    }

    static {
        RecordTestUtils.replayAll(DELTA1, FeaturesImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, ClusterImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, TopicsImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, ConfigurationsImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, ClientQuotasImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, ProducerIdsImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, AclsImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, ScramImageTest.DELTA1_RECORDS);
        RecordTestUtils.replayAll(DELTA1, DelegationTokenImageTest.DELTA1_RECORDS);
        IMAGE2 = new MetadataImage(new MetadataProvenance(200L, 5, 4000L, true), FeaturesImageTest.IMAGE2, ClusterImageTest.IMAGE2, TopicsImageTest.IMAGE2, ConfigurationsImageTest.IMAGE2, ClientQuotasImageTest.IMAGE2, ProducerIdsImageTest.IMAGE2, AclsImageTest.IMAGE2, ScramImageTest.IMAGE2, DelegationTokenImageTest.IMAGE2);
    }
}

