/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.EligibleLeaderReplicasVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class FeaturesImageTest {
    public static final FeaturesImage IMAGE1;
    public static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final FeaturesDelta DELTA1;
    static final FeaturesImage IMAGE2;
    static final List<ApiMessageAndVersion> DELTA2_RECORDS;
    static final FeaturesDelta DELTA2;
    static final FeaturesImage IMAGE3;

    @Test
    public void testEmptyImageRoundTrip() {
        FeaturesImage image = FeaturesImage.EMPTY;
        MetadataVersion metadataVersion = MetadataVersion.MINIMUM_VERSION;
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(metadataVersion).build());
        FeaturesImage expectedImage = new FeaturesImage(Map.of(), metadataVersion);
        FeaturesImageTest.testToImage(expectedImage, writer.records());
    }

    @Test
    public void testImage1RoundTrip() {
        FeaturesImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testApplyDelta1() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
        List<ApiMessageAndVersion> records = FeaturesImageTest.getImageRecords(IMAGE1);
        records.addAll(DELTA1_RECORDS);
        FeaturesImageTest.testToImage(IMAGE2, records);
    }

    @Test
    public void testImage2RoundTrip() {
        FeaturesImageTest.testToImage(IMAGE2);
    }

    @Test
    public void testImage3RoundTrip() {
        FeaturesImageTest.testToImage(IMAGE3);
    }

    @Test
    public void testApplyDelta2() {
        Assertions.assertEquals((Object)IMAGE3, (Object)DELTA2.apply());
        List<ApiMessageAndVersion> records = FeaturesImageTest.getImageRecords(IMAGE2);
        records.addAll(DELTA2_RECORDS);
        FeaturesImageTest.testToImage(IMAGE3, records);
    }

    private static void testToImage(FeaturesImage image) {
        FeaturesImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(FeaturesImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        FeaturesImageTest.testToImage(image, fromRecords.orElseGet(() -> FeaturesImageTest.getImageRecords(image)));
    }

    private static void testToImage(FeaturesImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<FeaturesDelta, FeaturesImage>(() -> FeaturesImage.EMPTY, FeaturesDelta::new).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(FeaturesImage image) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder(image.metadataVersionOrThrow()).build());
        return writer.records();
    }

    @Test
    public void testEmpty() {
        Assertions.assertTrue((boolean)FeaturesImage.EMPTY.isEmpty());
        Assertions.assertFalse((boolean)new FeaturesImage(Map.of("foo", (short)1), MetadataVersion.MINIMUM_VERSION).isEmpty());
        Assertions.assertFalse((boolean)new FeaturesImage(FeaturesImage.EMPTY.finalizedVersions(), MetadataVersion.MINIMUM_VERSION).isEmpty());
    }

    @Test
    public void testElrEnabled() {
        FeaturesImage image1 = new FeaturesImage(Map.of("eligible.leader.replicas.version", EligibleLeaderReplicasVersion.ELRV_0.featureLevel()), MetadataVersion.latestTesting());
        Assertions.assertFalse((boolean)image1.isElrEnabled());
        FeaturesImage image2 = new FeaturesImage(Map.of("eligible.leader.replicas.version", EligibleLeaderReplicasVersion.ELRV_1.featureLevel()), MetadataVersion.latestTesting());
        Assertions.assertTrue((boolean)image2.isElrEnabled());
    }

    static {
        HashMap<String, Short> map1 = new HashMap<String, Short>();
        map1.put("foo", (short)2);
        map1.put("bar", (short)1);
        IMAGE1 = new FeaturesImage(map1, MetadataVersion.latestTesting());
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo").setFeatureLevel((short)3), 0));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("bar").setFeatureLevel((short)0), 0));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("baz").setFeatureLevel((short)8), 0));
        DELTA1 = new FeaturesDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        HashMap<String, Short> map2 = new HashMap<String, Short>();
        map2.put("foo", (short)3);
        map2.put("baz", (short)8);
        IMAGE2 = new FeaturesImage(map2, MetadataVersion.latestTesting());
        DELTA2_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA2_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo").setFeatureLevel((short)0), 0));
        DELTA2_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("baz").setFeatureLevel((short)0), 0));
        DELTA2_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("bar").setFeatureLevel((short)1), 0));
        DELTA2 = new FeaturesDelta(IMAGE2);
        RecordTestUtils.replayAll(DELTA2, DELTA2_RECORDS);
        Map<String, Short> map3 = Map.of("bar", (short)1);
        IMAGE3 = new FeaturesImage(map3, MetadataVersion.latestTesting());
    }
}

