/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.snapshot.SnapshotWriter;

public class FakeSnapshotWriter
implements SnapshotWriter<ApiMessageAndVersion> {
    private final OffsetAndEpoch snapshotId;
    private final List<List<ApiMessageAndVersion>> batches = new ArrayList<List<ApiMessageAndVersion>>();
    private boolean frozen = false;
    private boolean closed = false;

    public List<List<ApiMessageAndVersion>> batches() {
        return this.batches.stream().map(List::copyOf).toList();
    }

    public FakeSnapshotWriter() {
        this(new OffsetAndEpoch(100L, 10));
    }

    public FakeSnapshotWriter(OffsetAndEpoch snapshotId) {
        this.snapshotId = snapshotId;
    }

    public OffsetAndEpoch snapshotId() {
        return this.snapshotId;
    }

    public long lastContainedLogOffset() {
        return this.snapshotId().offset() - 1L;
    }

    public int lastContainedLogEpoch() {
        return this.snapshotId().epoch();
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void append(List<ApiMessageAndVersion> batch) {
        if (this.frozen) {
            throw new IllegalStateException("Append not supported. Snapshot is already frozen.");
        }
        this.batches.add(batch);
    }

    public long freeze() {
        this.frozen = true;
        return (long)this.batches.size() * 100L;
    }

    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

