/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.AclsDelta;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;
import org.apache.kafka.metadata.authorizer.StandardAclWithIdTest;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class AclsImageTest {
    public static final AclsImage IMAGE1;
    public static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final AclsDelta DELTA1;
    static final AclsImage IMAGE2;

    @Test
    public void testEmptyImageRoundTrip() {
        AclsImageTest.testToImage(AclsImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() {
        AclsImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testApplyDelta1() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
        List<ApiMessageAndVersion> records = AclsImageTest.getImageRecords(IMAGE1);
        records.addAll(DELTA1_RECORDS);
        AclsImageTest.testToImage(IMAGE2, records);
    }

    @Test
    public void testImage2RoundTrip() {
        AclsImageTest.testToImage(IMAGE2);
    }

    private static void testToImage(AclsImage image) {
        AclsImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(AclsImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        AclsImageTest.testToImage(image, fromRecords.orElseGet(() -> AclsImageTest.getImageRecords(image)));
    }

    private static void testToImage(AclsImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<AclsDelta, AclsImage>(() -> AclsImage.EMPTY, AclsDelta::new).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(AclsImage image) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer);
        return writer.records();
    }

    static {
        HashMap<Uuid, StandardAcl> map = new HashMap<Uuid, StandardAcl>();
        for (int i = 0; i < 4; ++i) {
            StandardAclWithId aclWithId = StandardAclWithIdTest.TEST_ACLS.get(i);
            map.put(aclWithId.id(), aclWithId.acl());
        }
        IMAGE1 = new AclsImage(map);
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RemoveAccessControlEntryRecord().setId(Uuid.fromString((String)"QZDDv-R7SyaPgetDPGd0Mw")), 0));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)StandardAclWithIdTest.TEST_ACLS.get(4).toRecord(), 0));
        DELTA1 = new AclsDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        HashMap<Uuid, StandardAcl> map2 = new HashMap<Uuid, StandardAcl>();
        for (int i = 1; i < 5; ++i) {
            StandardAclWithId aclWithId = StandardAclWithIdTest.TEST_ACLS.get(i);
            map2.put(aclWithId.id(), aclWithId.acl());
        }
        IMAGE2 = new AclsImage(map2);
    }
}

