/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.ControllerMetricsTestUtils;
import org.apache.kafka.controller.metrics.QuorumControllerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuorumControllerMetricsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricNames() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        try {
            try (QuorumControllerMetrics metrics = new QuorumControllerMetrics(Optional.of(registry), (Time)time, 9000);){
                metrics.addTimeSinceLastHeartbeatMetric(1);
                HashSet<String> expected = new HashSet<String>(List.of("kafka.controller:type=ControllerEventManager,name=EventQueueProcessingTimeMs", "kafka.controller:type=ControllerEventManager,name=EventQueueTimeMs", "kafka.controller:type=KafkaController,name=ActiveControllerCount", "kafka.controller:type=KafkaController,name=EventQueueOperationsStartedCount", "kafka.controller:type=KafkaController,name=EventQueueOperationsTimedOutCount", "kafka.controller:type=KafkaController,name=LastAppliedRecordLagMs", "kafka.controller:type=KafkaController,name=LastAppliedRecordOffset", "kafka.controller:type=KafkaController,name=LastAppliedRecordTimestamp", "kafka.controller:type=KafkaController,name=LastCommittedRecordOffset", "kafka.controller:type=KafkaController,name=NewActiveControllersCount", "kafka.controller:type=KafkaController,name=TimedOutBrokerHeartbeatCount", "kafka.controller:type=KafkaController,name=TimeSinceLastHeartbeatReceivedMs,broker=1"));
                ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.controller", expected);
            }
            ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.controller", Set.of());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateEventQueueTime() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        try (QuorumControllerMetrics metrics = new QuorumControllerMetrics(Optional.of(registry), (Time)time, 9000);){
            metrics.updateEventQueueTime(1000L);
            QuorumControllerMetricsTest.assertMetricHistogram(registry, QuorumControllerMetricsTest.metricName("ControllerEventManager", "EventQueueTimeMs"), 1L, 1000.0);
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateEventQueueProcessingTime() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        try (QuorumControllerMetrics metrics = new QuorumControllerMetrics(Optional.of(registry), (Time)time, 9000);){
            metrics.updateEventQueueProcessingTime(1000L);
            QuorumControllerMetricsTest.assertMetricHistogram(registry, QuorumControllerMetricsTest.metricName("ControllerEventManager", "EventQueueProcessingTimeMs"), 1L, 1000.0);
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastAppliedRecordMetrics() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        time.sleep(1000L);
        try (QuorumControllerMetrics metrics = new QuorumControllerMetrics(Optional.of(registry), (Time)time, 9000);){
            int i;
            metrics.setLastAppliedRecordOffset(100L);
            metrics.setLastAppliedRecordTimestamp(500L);
            metrics.setLastCommittedRecordOffset(50L);
            metrics.setActive(true);
            for (i = 0; i < 2; ++i) {
                metrics.incrementTimedOutHeartbeats();
            }
            for (i = 0; i < 3; ++i) {
                metrics.incrementOperationsStarted();
            }
            for (i = 0; i < 4; ++i) {
                metrics.incrementOperationsTimedOut();
            }
            for (i = 0; i < 5; ++i) {
                metrics.incrementNewActiveControllers();
            }
            Gauge lastAppliedRecordOffset = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastAppliedRecordOffset"));
            Assertions.assertEquals((long)100L, (Long)((Long)lastAppliedRecordOffset.value()));
            Gauge lastAppliedRecordTimestamp = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastAppliedRecordTimestamp"));
            Assertions.assertEquals((long)500L, (Long)((Long)lastAppliedRecordTimestamp.value()));
            Gauge lastAppliedRecordLagMs = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastAppliedRecordLagMs"));
            Assertions.assertEquals((long)(time.milliseconds() - 500L), (Long)((Long)lastAppliedRecordLagMs.value()));
            Gauge lastCommittedRecordOffset = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastCommittedRecordOffset"));
            Assertions.assertEquals((long)50L, (Long)((Long)lastCommittedRecordOffset.value()));
            Gauge timedOutBrokerHeartbeats = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "TimedOutBrokerHeartbeatCount"));
            Assertions.assertEquals((long)2L, (Long)((Long)timedOutBrokerHeartbeats.value()));
            Gauge operationsStarted = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "EventQueueOperationsStartedCount"));
            Assertions.assertEquals((long)3L, (Long)((Long)operationsStarted.value()));
            Gauge operationsTimedOut = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "EventQueueOperationsTimedOutCount"));
            Assertions.assertEquals((long)4L, (Long)((Long)operationsTimedOut.value()));
            Gauge newActiveControllers = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "NewActiveControllersCount"));
            Assertions.assertEquals((long)5L, (Long)((Long)newActiveControllers.value()));
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeSinceLastHeartbeatReceivedMs() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        int brokerId = 1;
        int sessionTimeoutMs = 9000;
        try (QuorumControllerMetrics metrics = new QuorumControllerMetrics(Optional.of(registry), (Time)time, sessionTimeoutMs);){
            metrics.addTimeSinceLastHeartbeatMetric(1);
            int numMetrics = registry.allMetrics().size();
            Gauge timeSinceLastHeartbeatReceivedMs = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "TimeSinceLastHeartbeatReceivedMs", "broker=1"));
            metrics.updateBrokerContactTime(brokerId);
            time.sleep(1000L);
            Assertions.assertEquals((int)1000, (Integer)((Integer)timeSinceLastHeartbeatReceivedMs.value()));
            metrics.updateBrokerContactTime(brokerId);
            Assertions.assertEquals((int)0, (Integer)((Integer)timeSinceLastHeartbeatReceivedMs.value()));
            time.sleep(100000L);
            Assertions.assertEquals((int)sessionTimeoutMs, (Integer)((Integer)timeSinceLastHeartbeatReceivedMs.value()));
            metrics.removeTimeSinceLastHeartbeatMetrics();
            Assertions.assertEquals((int)(numMetrics - 1), (int)registry.allMetrics().size());
        }
        finally {
            registry.shutdown();
        }
    }

    private static void assertMetricHistogram(MetricsRegistry registry, MetricName metricName, long count, double sum) {
        Histogram histogram = (Histogram)registry.allMetrics().get(metricName);
        Assertions.assertEquals((long)count, (long)histogram.count());
        Assertions.assertEquals((double)sum, (double)histogram.sum(), (double)0.1);
    }

    private static MetricName metricName(String type, String name) {
        String mBeanName = String.format("kafka.controller:type=%s,name=%s", type, name);
        return new MetricName("kafka.controller", type, name, null, mBeanName);
    }

    private static MetricName metricName(String type, String name, String scope) {
        String mBeanName = String.format("kafka.controller:type=%s,name=%s,%s", type, name, scope);
        return new MetricName("kafka.controller", type, name, scope, mBeanName);
    }
}

