/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.kafka.controller.metrics.BrokerRegistrationState;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.controller.metrics.ControllerMetricsTestUtils;
import org.apache.kafka.metadata.BrokerRegistration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ControllerMetadataMetricsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricNames() {
        MetricsRegistry registry = new MetricsRegistry();
        try {
            try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
                metrics.addBrokerRegistrationStateMetric(0);
                metrics.setBrokerRegistrationState(1, this.brokerRegistration(false, false));
                metrics.addBrokerRegistrationStateMetric(1);
                metrics.setBrokerRegistrationState(2, this.brokerRegistration(false, false));
                ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.controller:", new HashSet<String>(List.of("kafka.controller:type=KafkaController,name=ActiveBrokerCount", "kafka.controller:type=KafkaController,name=FencedBrokerCount", "kafka.controller:type=KafkaController,name=ControlledShutdownBrokerCount", "kafka.controller:type=KafkaController,name=BrokerRegistrationState,broker=0", "kafka.controller:type=KafkaController,name=BrokerRegistrationState,broker=1", "kafka.controller:type=KafkaController,name=GlobalPartitionCount", "kafka.controller:type=KafkaController,name=GlobalTopicCount", "kafka.controller:type=KafkaController,name=MetadataErrorCount", "kafka.controller:type=KafkaController,name=OfflinePartitionsCount", "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount", "kafka.controller:type=KafkaController,name=IgnoredStaticVoters", "kafka.controller:type=ControllerStats,name=UncleanLeaderElectionsPerSec", "kafka.controller:type=ControllerStats,name=ElectionFromEligibleLeaderReplicasPerSec")));
            }
            ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "KafkaController", Set.of());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadataErrorCount() {
        MetricsRegistry registry = new MetricsRegistry();
        try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
            Gauge metadataErrorCount = (Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "MetadataErrorCount"));
            Assertions.assertEquals((int)0, (Integer)((Integer)metadataErrorCount.value()));
            metrics.incrementMetadataErrorCount();
            Assertions.assertEquals((int)1, (Integer)((Integer)metadataErrorCount.value()));
        }
        finally {
            registry.shutdown();
        }
    }

    private static MetricName metricName(String type, String name) {
        String mBeanName = String.format("kafka.controller:type=%s,name=%s", type, name);
        return new MetricName("kafka.controller", type, name, null, mBeanName);
    }

    private static MetricName metricName(String type, String name, String scope) {
        String mBeanName = String.format("kafka.controller:type=%s,name=%s,%s", type, name, scope);
        return new MetricName("kafka.controller", type, name, scope, mBeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testIntGaugeMetric(Function<ControllerMetadataMetrics, Integer> metricsGetter, Function<MetricsRegistry, Integer> registryGetter, BiConsumer<ControllerMetadataMetrics, Integer> setter, BiConsumer<ControllerMetadataMetrics, Integer> incrementer) {
        MetricsRegistry registry = new MetricsRegistry();
        try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
            Assertions.assertEquals((int)0, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)0, (Integer)registryGetter.apply(registry));
            setter.accept(metrics, 123);
            Assertions.assertEquals((int)123, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)123, (Integer)registryGetter.apply(registry));
            incrementer.accept(metrics, 123);
            Assertions.assertEquals((int)246, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)246, (Integer)registryGetter.apply(registry));
            incrementer.accept(metrics, -246);
            Assertions.assertEquals((int)0, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)0, (Integer)registryGetter.apply(registry));
        }
        finally {
            registry.shutdown();
        }
    }

    @Test
    public void testFencedBrokerMetric() {
        this.testIntGaugeMetric(m -> m.fencedBrokerCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "FencedBrokerCount"))).value(), (m, v) -> m.setFencedBrokerCount(v.intValue()), (m, v) -> m.addToFencedBrokerCount(v.intValue()));
    }

    @Test
    public void testActiveBrokerCountMetric() {
        this.testIntGaugeMetric(m -> m.activeBrokerCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "ActiveBrokerCount"))).value(), (m, v) -> m.setActiveBrokerCount(v.intValue()), (m, v) -> m.addToActiveBrokerCount(v.intValue()));
    }

    @Test
    public void testControlledShutdownCountMetric() {
        this.testIntGaugeMetric(m -> m.controlledShutdownBrokerCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "ControlledShutdownBrokerCount"))).value(), (m, v) -> m.setControlledShutdownBrokerCount(v.intValue()), (m, v) -> m.addToControlledShutdownBrokerCount(v.intValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBrokerRegistrationStateMetrics() {
        MetricsRegistry registry = new MetricsRegistry();
        try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
            int brokerId = 1;
            MetricName name = ControllerMetadataMetricsTest.metricName("KafkaController", "BrokerRegistrationState", "broker=1");
            metrics.addBrokerRegistrationStateMetric(brokerId);
            Gauge registrationState = (Gauge)registry.allMetrics().get(name);
            metrics.setBrokerRegistrationState(brokerId, this.brokerRegistration(false, false));
            Assertions.assertEquals((int)BrokerRegistrationState.ACTIVE.state(), (Integer)((Integer)registrationState.value()));
            metrics.setBrokerRegistrationState(brokerId, this.brokerRegistration(true, false));
            Assertions.assertEquals((int)BrokerRegistrationState.FENCED.state(), (Integer)((Integer)registrationState.value()));
            metrics.setBrokerRegistrationState(brokerId, this.brokerRegistration(false, true));
            Assertions.assertEquals((int)BrokerRegistrationState.CONTROLLED_SHUTDOWN.state(), (Integer)((Integer)registrationState.value()));
            metrics.setBrokerRegistrationState(brokerId, null);
            Assertions.assertEquals((int)BrokerRegistrationState.UNREGISTERED.state(), (Integer)((Integer)registrationState.value()));
            Assertions.assertNull(registry.allMetrics().get(name));
        }
        finally {
            registry.shutdown();
        }
    }

    private BrokerRegistration brokerRegistration(boolean fenced, boolean inControlledShutdown) {
        return new BrokerRegistration.Builder().setFenced(fenced).setInControlledShutdown(inControlledShutdown).build();
    }

    @Test
    public void testGlobalTopicCountMetric() {
        this.testIntGaugeMetric(m -> m.globalTopicCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "GlobalTopicCount"))).value(), (m, v) -> m.setGlobalTopicCount(v.intValue()), (m, v) -> m.addToGlobalTopicCount(v.intValue()));
    }

    @Test
    public void testGlobalPartitionCountMetric() {
        this.testIntGaugeMetric(m -> m.globalPartitionCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "GlobalPartitionCount"))).value(), (m, v) -> m.setGlobalPartitionCount(v.intValue()), (m, v) -> m.addToGlobalPartitionCount(v.intValue()));
    }

    @Test
    public void testOfflinePartitionCountMetric() {
        this.testIntGaugeMetric(m -> m.offlinePartitionCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "OfflinePartitionsCount"))).value(), (m, v) -> m.setOfflinePartitionCount(v.intValue()), (m, v) -> m.addToOfflinePartitionCount(v.intValue()));
    }

    @Test
    public void testPreferredReplicaImbalanceCountMetric() {
        this.testIntGaugeMetric(m -> m.preferredReplicaImbalanceCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "PreferredReplicaImbalanceCount"))).value(), (m, v) -> m.setPreferredReplicaImbalanceCount(v.intValue()), (m, v) -> m.addToPreferredReplicaImbalanceCount(v.intValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateUncleanLeaderElection() {
        MetricsRegistry registry = new MetricsRegistry();
        try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
            Meter UncleanLeaderElectionsPerSec = (Meter)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("ControllerStats", "UncleanLeaderElectionsPerSec"));
            Assertions.assertEquals((long)0L, (long)UncleanLeaderElectionsPerSec.count());
            metrics.updateUncleanLeaderElection(2);
            Assertions.assertEquals((long)2L, (long)UncleanLeaderElectionsPerSec.count());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateElectionFromEligibleLeaderReplicasCount() {
        MetricsRegistry registry = new MetricsRegistry();
        try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
            Meter ElectionFromEligibleLeaderReplicasPerSec = (Meter)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("ControllerStats", "ElectionFromEligibleLeaderReplicasPerSec"));
            Assertions.assertEquals((long)0L, (long)ElectionFromEligibleLeaderReplicasPerSec.count());
            metrics.updateElectionFromEligibleLeaderReplicasCount(2);
            Assertions.assertEquals((long)2L, (long)ElectionFromEligibleLeaderReplicasPerSec.count());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIgnoredStaticVoters() {
        MetricsRegistry registry = new MetricsRegistry();
        try (ControllerMetadataMetrics metrics = new ControllerMetadataMetrics(Optional.of(registry));){
            Gauge ignoredStaticVoters = (Gauge)registry.allMetrics().get(ControllerMetadataMetricsTest.metricName("KafkaController", "IgnoredStaticVoters"));
            Assertions.assertEquals((int)0, (Integer)((Integer)ignoredStaticVoters.value()));
            metrics.setIgnoredStaticVoters(true);
            Assertions.assertEquals((int)1, (Integer)((Integer)ignoredStaticVoters.value()));
            metrics.setIgnoredStaticVoters(false);
            Assertions.assertEquals((int)0, (Integer)((Integer)ignoredStaticVoters.value()));
        }
        finally {
            registry.shutdown();
        }
    }
}

