/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.controller.ControllerRequestContextUtil;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.server.common.EligibleLeaderReplicasVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumControllerIntegrationTestUtils {
    private static final Logger log = LoggerFactory.getLogger(QuorumControllerIntegrationTestUtils.class);

    static BrokerRegistrationRequestData.FeatureCollection brokerFeatures(MetadataVersion minVersion, MetadataVersion maxVersion) {
        BrokerRegistrationRequestData.FeatureCollection features = new BrokerRegistrationRequestData.FeatureCollection();
        features.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(minVersion.featureLevel()).setMaxSupportedVersion(maxVersion.featureLevel()));
        return features;
    }

    static BrokerRegistrationRequestData.FeatureCollection brokerFeaturesPlusFeatureVersions(MetadataVersion minVersion, MetadataVersion maxVersion, Map<String, Short> featureMaxVersions) {
        BrokerRegistrationRequestData.FeatureCollection features = new BrokerRegistrationRequestData.FeatureCollection();
        features.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(minVersion.featureLevel()).setMaxSupportedVersion(maxVersion.featureLevel()));
        featureMaxVersions.forEach((key, value) -> features.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName(key).setMaxSupportedVersion(value.shortValue()).setMinSupportedVersion((short)0)));
        return features;
    }

    static Map<Integer, Long> registerBrokersAndUnfence(QuorumController controller, int numBrokers) throws Exception {
        HashMap<Integer, Long> brokerEpochs = new HashMap<Integer, Long>();
        for (int brokerId = 0; brokerId < numBrokers; ++brokerId) {
            BrokerRegistrationReply reply = (BrokerRegistrationReply)controller.registerBroker(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, new BrokerRegistrationRequestData().setBrokerId(brokerId).setRack(null).setClusterId(controller.clusterId()).setFeatures(QuorumControllerIntegrationTestUtils.brokerFeaturesPlusFeatureVersions(MetadataVersion.MINIMUM_VERSION, MetadataVersion.latestTesting(), Map.of("eligible.leader.replicas.version", EligibleLeaderReplicasVersion.ELRV_1.featureLevel()))).setIncarnationId(Uuid.fromString((String)("kxAT73dKQsitIedpiPtwB" + brokerId))).setLogDirs(List.of(Uuid.fromString((String)("TESTBROKER" + Integer.toString(100000 + brokerId).substring(1) + "DIRAAAA")))).setListeners(new BrokerRegistrationRequestData.ListenerCollection(List.of(new BrokerRegistrationRequestData.Listener().setName("PLAINTEXT").setHost("localhost").setPort(9092 + brokerId)).iterator()))).get();
            brokerEpochs.put(brokerId, reply.epoch());
            controller.processBrokerHeartbeat(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, new BrokerHeartbeatRequestData().setWantFence(false).setBrokerEpoch(((Long)brokerEpochs.get(brokerId)).longValue()).setBrokerId(brokerId).setCurrentMetadataOffset(100000L)).get();
        }
        return brokerEpochs;
    }

    static void sendBrokerHeartbeatToUnfenceBrokers(QuorumController controller, List<Integer> brokers, Map<Integer, Long> brokerEpochs) throws Exception {
        if (brokers.isEmpty()) {
            return;
        }
        for (Integer brokerId : brokers) {
            BrokerHeartbeatReply reply = (BrokerHeartbeatReply)controller.processBrokerHeartbeat(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, new BrokerHeartbeatRequestData().setWantFence(false).setBrokerEpoch(brokerEpochs.get(brokerId).longValue()).setBrokerId(brokerId.intValue()).setCurrentMetadataOffset(100000L)).get();
            Assertions.assertEquals((Object)new BrokerHeartbeatReply(true, false, false, false), (Object)reply);
        }
    }

    static void createTopics(QuorumController controller, String prefix, int numTopics, int replicationFactor) throws Exception {
        HashSet<CallSite> describable = new HashSet<CallSite>();
        for (int i = 0; i < numTopics; ++i) {
            describable.add((CallSite)((Object)(prefix + i)));
        }
        CreateTopicsRequestData request = new CreateTopicsRequestData();
        for (int i = 0; i < numTopics; ++i) {
            request.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName(prefix + i).setNumPartitions(1).setReplicationFactor((short)replicationFactor));
        }
        CreateTopicsResponseData response = (CreateTopicsResponseData)controller.createTopics(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, request, describable).get();
        for (int i = 0; i < numTopics; ++i) {
            CreateTopicsResponseData.CreatableTopicResult result = response.topics().find(prefix + i);
            if (result.errorCode() == Errors.TOPIC_ALREADY_EXISTS.code()) continue;
            Assertions.assertEquals((short)0, (short)result.errorCode());
        }
    }

    public static CountDownLatch pause(QuorumController controller) {
        CountDownLatch latch = new CountDownLatch(1);
        controller.appendControlEvent("pause", () -> {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                log.info("Interrupted while waiting for unpause.", (Throwable)e);
            }
        });
        return latch;
    }

    static void forceRenounce(QuorumController controller) throws Exception {
        CompletableFuture future = new CompletableFuture();
        controller.appendControlEvent("forceRenounce", () -> {
            controller.renounce();
            future.complete(null);
        });
        future.get(30L, TimeUnit.SECONDS);
    }
}

