/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.PeriodicTask;
import org.apache.kafka.controller.PeriodicTaskControlManager;
import org.apache.kafka.controller.PeriodicTaskFlag;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=10L)
public class PeriodicTaskControlManagerTest {
    @Test
    public void testActivate() {
        PeriodicTaskControlManagerTestEnv env = new PeriodicTaskControlManagerTestEnv();
        Assertions.assertFalse((boolean)env.manager.active());
        env.manager.activate();
        Assertions.assertTrue((boolean)env.manager.active());
        Assertions.assertEquals((int)0, (int)env.numDeferred());
    }

    @Test
    public void testDeactivate() {
        PeriodicTaskControlManagerTestEnv env = new PeriodicTaskControlManagerTestEnv();
        Assertions.assertFalse((boolean)env.manager.active());
        env.manager.activate();
        env.manager.deactivate();
        Assertions.assertFalse((boolean)env.manager.active());
        Assertions.assertEquals((int)0, (int)env.numDeferred());
    }

    @Test
    public void testRegisterTaskWhenDeactivated() {
        FakePeriodicTask foo = new FakePeriodicTask("foo", TimeUnit.MILLISECONDS.toNanos(100L));
        PeriodicTaskControlManagerTestEnv env = new PeriodicTaskControlManagerTestEnv();
        env.manager.registerTask(foo.task);
        Assertions.assertEquals((int)0, (int)env.numDeferred());
    }

    @Test
    public void testRegisterTaskWhenActivated() {
        FakePeriodicTask foo = new FakePeriodicTask("foo", TimeUnit.MILLISECONDS.toNanos(100L));
        PeriodicTaskControlManagerTestEnv env = new PeriodicTaskControlManagerTestEnv();
        env.manager.activate();
        env.manager.registerTask(foo.task);
        Assertions.assertEquals((int)1, (int)env.numDeferred());
    }

    @Test
    public void testRegisterTaskWhenActivatedThenDeactivate() {
        FakePeriodicTask foo = new FakePeriodicTask("foo", TimeUnit.MILLISECONDS.toNanos(100L));
        PeriodicTaskControlManagerTestEnv env = new PeriodicTaskControlManagerTestEnv();
        env.manager.activate();
        env.manager.registerTask(foo.task);
        env.manager.deactivate();
        Assertions.assertEquals((int)0, (int)env.numDeferred());
    }

    @Test
    public void testRegisterTaskAndAdvanceTime() {
        FakePeriodicTask foo = new FakePeriodicTask("foo", TimeUnit.MILLISECONDS.toNanos(100L));
        FakePeriodicTask bar = new FakePeriodicTask("bar", TimeUnit.MILLISECONDS.toNanos(50L));
        PeriodicTaskControlManagerTestEnv env = new PeriodicTaskControlManagerTestEnv();
        env.manager.activate();
        env.manager.registerTask(foo.task);
        env.manager.registerTask(bar.task);
        Assertions.assertEquals((int)2, (int)env.numDeferred());
        env.advanceTime(50L);
        Assertions.assertEquals((int)0, (int)foo.numCalls.get());
        Assertions.assertEquals((int)1, (int)bar.numCalls.get());
        Assertions.assertEquals((int)2, (int)env.numDeferred());
        env.advanceTime(50L);
        Assertions.assertEquals((int)1, (int)foo.numCalls.get());
        Assertions.assertEquals((int)2, (int)bar.numCalls.get());
        Assertions.assertEquals((int)2, (int)env.numDeferred());
        env.manager.deactivate();
    }

    @Test
    public void testContinuation() {
        FakePeriodicTask foo = new FakePeriodicTask("foo", TimeUnit.MILLISECONDS.toNanos(100L));
        FakePeriodicTask bar = new FakePeriodicTask("bar", TimeUnit.MILLISECONDS.toNanos(50L));
        bar.continuation.set(true);
        PeriodicTaskControlManagerTestEnv env = new PeriodicTaskControlManagerTestEnv();
        env.manager.activate();
        env.manager.registerTask(foo.task);
        env.manager.registerTask(bar.task);
        Assertions.assertEquals((int)2, (int)env.numDeferred());
        env.advanceTime(50L);
        Assertions.assertEquals((int)0, (int)foo.numCalls.get());
        Assertions.assertEquals((int)1, (int)bar.numCalls.get());
        Assertions.assertEquals((int)2, (int)env.numDeferred());
        env.advanceTime(10L);
        Assertions.assertEquals((int)2, (int)bar.numCalls.get());
        env.advanceTime(40L);
        Assertions.assertEquals((int)1, (int)foo.numCalls.get());
        Assertions.assertEquals((int)2, (int)bar.numCalls.get());
        Assertions.assertEquals((int)2, (int)env.numDeferred());
        env.advanceTime(10L);
        Assertions.assertEquals((int)3, (int)bar.numCalls.get());
        env.manager.deactivate();
    }

    @Test
    public void testRegisterTaskAndUnregister() {
        FakePeriodicTask foo = new FakePeriodicTask("foo", TimeUnit.MILLISECONDS.toNanos(100L));
        FakePeriodicTask bar = new FakePeriodicTask("bar", TimeUnit.MILLISECONDS.toNanos(50L));
        PeriodicTaskControlManagerTestEnv env = new PeriodicTaskControlManagerTestEnv();
        env.manager.activate();
        env.manager.registerTask(foo.task);
        env.manager.registerTask(bar.task);
        Assertions.assertEquals((int)2, (int)env.numDeferred());
        env.advanceTime(50L);
        Assertions.assertEquals((int)0, (int)foo.numCalls.get());
        Assertions.assertEquals((int)1, (int)bar.numCalls.get());
        env.manager.unregisterTask(foo.task.name());
        Assertions.assertEquals((int)1, (int)env.numDeferred());
        env.manager.unregisterTask(bar.task.name());
        Assertions.assertEquals((int)0, (int)env.numDeferred());
        env.advanceTime(200L);
        Assertions.assertEquals((int)0, (int)foo.numCalls.get());
        Assertions.assertEquals((int)1, (int)bar.numCalls.get());
        env.manager.deactivate();
    }

    @Test
    public void testReschedulingAfterFailure() {
        FakePeriodicTask foo = new FakePeriodicTask("foo", TimeUnit.MILLISECONDS.toNanos(100L));
        foo.shouldFail.set(true);
        PeriodicTaskControlManagerTestEnv env = new PeriodicTaskControlManagerTestEnv();
        env.manager.activate();
        env.manager.registerTask(foo.task);
        Assertions.assertEquals((int)1, (int)env.numDeferred());
        env.advanceTime(100L);
        Assertions.assertEquals((int)1, (int)foo.numCalls.get());
        env.advanceTime(300000L);
        Assertions.assertEquals((int)2, (int)foo.numCalls.get());
        env.manager.deactivate();
    }

    static class PeriodicTaskControlManagerTestEnv
    implements PeriodicTaskControlManager.QueueAccessor {
        final MockTime time = new MockTime(0L, 0L, 0L);
        final PeriodicTaskControlManager manager = new PeriodicTaskControlManager.Builder().setTime((Time)this.time).setQueueAccessor((PeriodicTaskControlManager.QueueAccessor)this).build();
        final TreeMap<Long, List<TrackedTask>> tasks = new TreeMap();
        int numCalls = 10000;

        PeriodicTaskControlManagerTestEnv() {
        }

        public void scheduleDeferred(String tag, long deadlineNs, Supplier<ControllerResult<Void>> op) {
            if (this.numCalls <= 0) {
                throw new RuntimeException("too many deferred calls.");
            }
            --this.numCalls;
            this.cancelDeferred(tag);
            TrackedTask task = new TrackedTask(tag, deadlineNs, op);
            this.tasks.computeIfAbsent(deadlineNs, __ -> new ArrayList()).add(task);
        }

        public void cancelDeferred(String tag) {
            Iterator<Map.Entry<Long, List<TrackedTask>>> iter = this.tasks.entrySet().iterator();
            boolean foundTask = false;
            while (iter.hasNext() && !foundTask) {
                Map.Entry<Long, List<TrackedTask>> entry = iter.next();
                Iterator<TrackedTask> taskIter = entry.getValue().iterator();
                while (taskIter.hasNext()) {
                    TrackedTask task = taskIter.next();
                    if (!task.tag.equals(tag)) continue;
                    taskIter.remove();
                    foundTask = true;
                    break;
                }
                if (!entry.getValue().isEmpty()) continue;
                iter.remove();
            }
        }

        int numDeferred() {
            int count = 0;
            for (List<TrackedTask> taskList : this.tasks.values()) {
                count += taskList.size();
            }
            return count;
        }

        void advanceTime(long ms) {
            this.time.sleep(ms);
            Iterator<Map.Entry<Long, List<TrackedTask>>> iter;
            while ((iter = this.tasks.entrySet().iterator()).hasNext()) {
                Map.Entry<Long, List<TrackedTask>> entry = iter.next();
                if (this.time.nanoseconds() < entry.getKey()) {
                    return;
                }
                if (!entry.getValue().isEmpty()) {
                    Iterator<TrackedTask> taskIter = entry.getValue().iterator();
                    TrackedTask task = taskIter.next();
                    taskIter.remove();
                    try {
                        task.op.get();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                iter.remove();
            }
            return;
        }
    }

    static class FakePeriodicTask {
        final AtomicInteger numCalls;
        final AtomicBoolean continuation = new AtomicBoolean(false);
        final PeriodicTask task;
        final AtomicBoolean shouldFail = new AtomicBoolean(false);

        FakePeriodicTask(String name, long periodNs) {
            this.numCalls = new AtomicInteger();
            this.task = new PeriodicTask(name, () -> {
                this.numCalls.addAndGet(1);
                if (this.shouldFail.getAndSet(false)) {
                    throw new NullPointerException("uh oh");
                }
                return ControllerResult.of(List.of(), (Object)this.continuation.getAndSet(false));
            }, periodNs, EnumSet.noneOf(PeriodicTaskFlag.class));
        }
    }

    static class TrackedTask {
        final String tag;
        final long deadlineNs;
        final Supplier<ControllerResult<Void>> op;

        TrackedTask(String tag, long deadlineNs, Supplier<ControllerResult<Void>> op) {
            this.tag = tag;
            this.deadlineNs = deadlineNs;
            this.op = op;
        }
    }
}

