/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.controller.PartitionReassignmentReplicas;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.placement.PartitionAssignmentTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class PartitionReassignmentReplicasTest {
    @Test
    public void testNoneAddedOrRemoved() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1))), PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1))));
        Assertions.assertEquals(List.of(), (Object)replicas.removing());
        Assertions.assertEquals(List.of(), (Object)replicas.adding());
        Assertions.assertEquals(List.of(Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1)), (Object)replicas.replicas());
    }

    @Test
    public void testAdditions() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1))), PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(3), Integer.valueOf(6), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(5))));
        Assertions.assertEquals(List.of(), (Object)replicas.removing());
        Assertions.assertEquals(List.of(Integer.valueOf(5), Integer.valueOf(6)), (Object)replicas.adding());
        Assertions.assertEquals(List.of(Integer.valueOf(3), Integer.valueOf(6), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(5)), (Object)replicas.replicas());
    }

    @Test
    public void testRemovals() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0))), PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(3), Integer.valueOf(1))));
        Assertions.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(2)), (Object)replicas.removing());
        Assertions.assertEquals(List.of(), (Object)replicas.adding());
        Assertions.assertEquals(List.of(Integer.valueOf(3), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(2)), (Object)replicas.replicas());
    }

    @Test
    public void testAdditionsAndRemovals() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0))), PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(7), Integer.valueOf(3), Integer.valueOf(1), Integer.valueOf(9))));
        Assertions.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(2)), (Object)replicas.removing());
        Assertions.assertEquals(List.of(Integer.valueOf(7), Integer.valueOf(9)), (Object)replicas.adding());
        Assertions.assertEquals(List.of(Integer.valueOf(7), Integer.valueOf(3), Integer.valueOf(1), Integer.valueOf(9), Integer.valueOf(0), Integer.valueOf(2)), (Object)replicas.replicas());
    }

    @Test
    public void testRearrangement() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0))), PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(2))));
        Assertions.assertEquals(List.of(), (Object)replicas.removing());
        Assertions.assertEquals(List.of(), (Object)replicas.adding());
        Assertions.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(2)), (Object)replicas.replicas());
    }

    @Test
    public void testDoesNotCompleteReassignment() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))), PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5))));
        Assertions.assertTrue((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)));
        Assertions.assertFalse((boolean)reassignmentOptional.isPresent());
    }

    @Test
    public void testDoesNotCompleteReassignmentIfNoneOngoing() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(List.of(), List.of(), List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)));
        Assertions.assertFalse((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)));
        Assertions.assertFalse((boolean)reassignmentOptional.isPresent());
    }

    @Test
    public void testDoesCompleteReassignmentAllNewReplicas() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))), PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5))));
        Assertions.assertTrue((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)));
        Assertions.assertTrue((boolean)reassignmentOptional.isPresent());
        PartitionReassignmentReplicas.CompletedReassignment completedReassignment = (PartitionReassignmentReplicas.CompletedReassignment)reassignmentOptional.get();
        Assertions.assertEquals(List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)), (Object)completedReassignment.isr);
        Assertions.assertEquals(List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)), (Object)completedReassignment.replicas);
    }

    @Test
    public void testDoesCompleteReassignmentSomeNewReplicas() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))), PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(3))));
        Assertions.assertTrue((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
        Assertions.assertTrue((boolean)reassignmentOptional.isPresent());
        PartitionReassignmentReplicas.CompletedReassignment completedReassignment = (PartitionReassignmentReplicas.CompletedReassignment)reassignmentOptional.get();
        Assertions.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(3)), (Object)completedReassignment.isr);
        Assertions.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(3)), (Object)completedReassignment.replicas);
    }

    @Test
    public void testIsReassignmentInProgress() {
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 3, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"HEKOeWDdQOqr2cmHrnjqjA"), Uuid.fromString((String)"I8kmmcM5TjOwNFnGvJLCjA"), Uuid.fromString((String)"x8osEoRkQdupZNYpU5c3Lw"), Uuid.fromString((String)"OT6qgtRqTiuiX8EikvAVow")}).setIsr(new int[]{0, 1, 3, 2}).setRemovingReplicas(new int[]{2}).setAddingReplicas(new int[]{3}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build()));
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 3, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"QrbOddSYQg6JgFu7hLvOTg"), Uuid.fromString((String)"S585FNNoSmiSH6ZYCrNqCg"), Uuid.fromString((String)"wjT5ieLARfKYMWIzTFwcag"), Uuid.fromString((String)"qzX9qWPVTWuLbiEQL0cgeg")}).setIsr(new int[]{0, 1, 3, 2}).setRemovingReplicas(new int[]{2}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build()));
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 3, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"QIyJnfdUSz6laFLCgj3AjA"), Uuid.fromString((String)"1QIvvBx2QVqNw2dsnYXUZg"), Uuid.fromString((String)"yPvPnGrxR0q8KC2Q5k0FIg"), Uuid.fromString((String)"a0lnxzleTcWVf1IyalE9cA")}).setIsr(new int[]{0, 1, 3, 2}).setAddingReplicas(new int[]{3}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build()));
        Assertions.assertFalse((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"I4qCCBe9TYGOB0xvmvTI7w"), Uuid.fromString((String)"JvzGem0nTxiNPM5jIzNzlA"), Uuid.fromString((String)"EfWjZ2EsSKSvEn9PkG7lWQ")}).setIsr(new int[]{0, 1, 2}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build()));
    }

    @Test
    public void testDoesNotCompleteReassignmentIfIsrDoesNotHaveAllTargetReplicas() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))), PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(3))));
        Assertions.assertTrue((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(List.of(Integer.valueOf(3)));
        Assertions.assertFalse((boolean)reassignmentOptional.isPresent());
    }

    @Test
    public void testOriginalReplicas() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))), PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(3))));
        Assertions.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)), (Object)replicas.originalReplicas());
    }
}

