/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.types.TaggedFields;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.controller.PartitionChangeBuilder;
import org.apache.kafka.controller.PartitionReassignmentReplicas;
import org.apache.kafka.controller.PartitionReassignmentRevert;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.metadata.placement.DefaultDirProvider;
import org.apache.kafka.metadata.placement.PartitionAssignmentTest;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class PartitionChangeBuilderTest {
    private static final DefaultDirProvider DEFAULT_DIR_PROVIDER = brokerId -> DirectoryId.UNASSIGNED;
    private static final PartitionRegistration FOO = new PartitionRegistration.Builder().setReplicas(new int[]{2, 1, 3}).setDirectories(new Uuid[]{Uuid.fromString((String)"dpdvA5AZSWySmnPFTnu5Kw"), Uuid.fromString((String)"V60B3cglScq3Xk8BX1NxAQ"), DirectoryId.UNASSIGNED}).setIsr(new int[]{2, 1, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
    private static final Uuid FOO_ID = Uuid.fromString((String)"FbrrdcfiR-KC2CPSTHaJrg");
    private static final PartitionRegistration BAR = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setDirectories(new Uuid[]{DirectoryId.UNASSIGNED, Uuid.fromString((String)"X5FnAcIgTheWgTMzeO5WHw"), Uuid.fromString((String)"GtrcdoSOTm2vFMGFeZq0eg"), Uuid.fromString((String)"YcOqPw5ARmeKr1y9W3AkFw")}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{1}).setAddingReplicas(new int[]{4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
    private static final Uuid BAR_ID = Uuid.fromString((String)"LKfUsCBnQKekvL9O5dY9nw");
    private static final PartitionRegistration BAZ = new PartitionRegistration.Builder().setReplicas(new int[]{2, 1, 3}).setDirectories(new Uuid[]{Uuid.fromString((String)"ywnfFpTBTbOsFdZ6uAdOmw"), Uuid.fromString((String)"Th0x70ecRbWvZNNV33jyRA"), Uuid.fromString((String)"j216tuSoQsC9JFd1Z5ZP6w")}).setIsr(new int[]{1, 3}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
    private static final Uuid BAZ_ID = Uuid.fromString((String)"wQzt5gkSTwuQNXZF5gIw7A");
    private static final PartitionRegistration OFFLINE_WITHOUT_ELR = new PartitionRegistration.Builder().setReplicas(new int[]{2, 1, 3}).setDirectories(new Uuid[]{Uuid.fromString((String)"iYGgiDV5Sb2EtH6hbgYnCA"), Uuid.fromString((String)"XI2t4qAUSkGlLZSKeEVf8g"), Uuid.fromString((String)"eqRW24kIRlitzQFzmovE0Q")}).setIsr(new int[]{3}).setLeader(Integer.valueOf(-1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
    private static final PartitionRegistration OFFLINE_WITH_ELR = new PartitionRegistration.Builder().setReplicas(new int[]{2, 1, 3}).setDirectories(new Uuid[]{Uuid.fromString((String)"CQEqt7trRrmqyNxUT1CY0g"), Uuid.fromString((String)"59Mb9smoSsC0bGUP2FYV8A"), Uuid.fromString((String)"LBTmsCVJREqJuIEtwqxRDg")}).setElr(new int[]{3}).setIsr(new int[0]).setLastKnownElr(new int[]{2}).setLeader(Integer.valueOf(-1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
    private static final Uuid OFFLINE_ID = Uuid.fromString((String)"LKfUsCBnQKekvL9O5dY9nw");

    private static Stream<Arguments> partitionChangeRecordVersions() {
        return IntStream.range(0, 3).mapToObj(version -> Arguments.of((Object[])new Object[]{(short)version}));
    }

    @Test
    public void testChangeRecordIsNoOp() {
        Assertions.assertEquals((int)2, (int)2);
        Assertions.assertEquals((int)0, (int)0);
        TaggedFields taggedFields = (TaggedFields)PartitionChangeRecord.SCHEMA_0.get((int)2).def.type;
        Assertions.assertEquals((int)6, (int)taggedFields.numFields());
        Assertions.assertTrue((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord()));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setLeader(1)));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setIsr(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)))));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setRemovingReplicas(List.of(Integer.valueOf(1)))));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setAddingReplicas(List.of(Integer.valueOf(4)))));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setEligibleLeaderReplicas(List.of(Integer.valueOf(5)))));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setLastKnownElr(List.of(Integer.valueOf(6)))));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value())));
        Assertions.assertFalse((boolean)PartitionChangeBuilder.changeRecordIsNoOp((PartitionChangeRecord)new PartitionChangeRecord().setDirectories(List.of(Uuid.fromString((String)"5JwD0VNXRV2Wr9CCON38Tw"), Uuid.fromString((String)"zpL1bRzTQXmmgdxlLHOWuw"), Uuid.fromString((String)"6iGUpAkHQXC6bY0FTcPRDw")))));
    }

    private static MetadataVersion metadataVersionForPartitionChangeRecordVersion(short version) {
        switch (version) {
            case 0: {
                return MetadataVersion.IBP_3_7_IV0;
            }
            case 1: {
                return MetadataVersion.IBP_3_7_IV2;
            }
            case 2: {
                return MetadataVersion.IBP_4_0_IV1;
            }
        }
        throw new RuntimeException("Unknown PartitionChangeRecord version " + version);
    }

    private static PartitionChangeBuilder createFooBuilder(MetadataVersion metadataVersion) {
        return new PartitionChangeBuilder(FOO, FOO_ID, 0, r -> r != 3, metadataVersion, 2).setEligibleLeaderReplicasEnabled(metadataVersion.isElrSupported()).setDefaultDirProvider(DEFAULT_DIR_PROVIDER);
    }

    private static PartitionChangeBuilder createFooBuilder(short partitionChangeRecordVersion) {
        return PartitionChangeBuilderTest.createFooBuilder(PartitionChangeBuilderTest.metadataVersionForPartitionChangeRecordVersion(partitionChangeRecordVersion));
    }

    private static boolean isElrEnabled(short partitionChangeRecordVersion) {
        return partitionChangeRecordVersion >= 2;
    }

    private static PartitionChangeBuilder createBarBuilder(short version) {
        return new PartitionChangeBuilder(BAR, BAR_ID, 0, r -> r != 3, PartitionChangeBuilderTest.metadataVersionForPartitionChangeRecordVersion(version), 2).setEligibleLeaderReplicasEnabled(PartitionChangeBuilderTest.isElrEnabled(version)).setDefaultDirProvider(DEFAULT_DIR_PROVIDER);
    }

    private static PartitionChangeBuilder createBazBuilder(short version) {
        return new PartitionChangeBuilder(BAZ, BAZ_ID, 0, __ -> true, PartitionChangeBuilderTest.metadataVersionForPartitionChangeRecordVersion(version), 2).setEligibleLeaderReplicasEnabled(PartitionChangeBuilderTest.isElrEnabled(version)).setDefaultDirProvider(DEFAULT_DIR_PROVIDER);
    }

    private static PartitionChangeBuilder createOfflineBuilder(short partitionChangeRecordVersion) {
        MetadataVersion metadataVersion = PartitionChangeBuilderTest.metadataVersionForPartitionChangeRecordVersion(partitionChangeRecordVersion);
        if (metadataVersion.isElrSupported()) {
            return new PartitionChangeBuilder(OFFLINE_WITH_ELR, OFFLINE_ID, 0, r -> r == 1, metadataVersion, 2).setEligibleLeaderReplicasEnabled(true).setDefaultDirProvider(DEFAULT_DIR_PROVIDER);
        }
        return new PartitionChangeBuilder(OFFLINE_WITHOUT_ELR, OFFLINE_ID, 0, r -> r == 1, metadataVersion, 2).setEligibleLeaderReplicasEnabled(false).setDefaultDirProvider(DEFAULT_DIR_PROVIDER);
    }

    private static void assertElectLeaderEquals(PartitionChangeBuilder builder, int expectedNode, boolean expectedUnclean) {
        PartitionChangeBuilder.ElectionResult electionResult = builder.electLeader();
        Assertions.assertEquals((int)expectedNode, (int)electionResult.node);
        Assertions.assertEquals((Object)expectedUnclean, (Object)electionResult.unclean);
    }

    @ParameterizedTest
    @MethodSource(value={"partitionChangeRecordVersions"})
    public void testElectLeader(short version) {
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(version).setElection(PartitionChangeBuilder.Election.PREFERRED), 2, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(version), 1, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(version).setElection(PartitionChangeBuilder.Election.UNCLEAN), 1, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(version).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(1), Integer.valueOf(3)))), 1, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(version).setElection(PartitionChangeBuilder.Election.UNCLEAN).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(1), Integer.valueOf(3)))), 1, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(version).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(3)))), -1, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(version).setElection(PartitionChangeBuilder.Election.UNCLEAN).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(3)))), 2, true);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createFooBuilder(version).setElection(PartitionChangeBuilder.Election.UNCLEAN).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(4)))).setTargetReplicas(List.of(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(4))), 4, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createBazBuilder(version).setElection(PartitionChangeBuilder.Election.PREFERRED), 3, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createBazBuilder(version), 3, false);
        PartitionChangeBuilderTest.assertElectLeaderEquals(PartitionChangeBuilderTest.createBazBuilder(version).setElection(PartitionChangeBuilder.Election.UNCLEAN), 3, false);
    }

    private static void testTriggerLeaderEpochBumpIfNeeded(PartitionChangeBuilder builder, PartitionChangeRecord record, int expectedLeader) {
        builder.triggerLeaderEpochBumpForReplicaReassignmentIfNeeded(record);
        record.setIsr(builder.targetIsr());
        builder.triggerLeaderEpochBumpForIsrShrinkIfNeeded(record);
        Assertions.assertEquals((int)expectedLeader, (int)record.leader());
    }

    @ParameterizedTest
    @MethodSource(value={"partitionChangeRecordVersions"})
    public void testNoLeaderEpochBumpIfNothingChanged(short version) {
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeeded(PartitionChangeBuilderTest.createFooBuilder(version), new PartitionChangeRecord(), -2);
    }

    @ParameterizedTest
    @ValueSource(strings={"3.6-IV0", "3.7-IV2", "4.0-IV0"})
    public void testNoLeaderEpochBumpOnIsrShrink(String metadataVersionString) {
        MetadataVersion metadataVersion = MetadataVersion.fromVersionString((String)metadataVersionString);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeeded(PartitionChangeBuilderTest.createFooBuilder(metadataVersion).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(2), Integer.valueOf(1)))), new PartitionChangeRecord(), -2);
    }

    @ParameterizedTest
    @ValueSource(strings={"3.4-IV0", "3.5-IV2"})
    public void testLeaderEpochBumpOnIsrShrink(String metadataVersionString) {
        MetadataVersion metadataVersion = MetadataVersion.fromVersionString((String)metadataVersionString);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeeded(PartitionChangeBuilderTest.createFooBuilder(metadataVersion).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(2), Integer.valueOf(1)))), new PartitionChangeRecord(), 1);
    }

    @ParameterizedTest
    @ValueSource(strings={"3.4-IV0", "3.5-IV2", "3.6-IV0", "3.7-IV2", "4.0-IV0"})
    public void testNoLeaderEpochBumpOnIsrExpansion(String metadataVersionString) {
        MetadataVersion metadataVersion = MetadataVersion.fromVersionString((String)metadataVersionString);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeeded(PartitionChangeBuilderTest.createFooBuilder(metadataVersion).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(4)))), new PartitionChangeRecord(), -2);
    }

    @ParameterizedTest
    @ValueSource(strings={"3.4-IV0", "3.5-IV2", "3.6-IV0", "3.7-IV2", "4.0-IV0"})
    public void testLeaderEpochBumpOnNewReplicaSetDisjoint(String metadataVersionString) {
        MetadataVersion metadataVersion = MetadataVersion.fromVersionString((String)metadataVersionString);
        PartitionChangeBuilderTest.testTriggerLeaderEpochBumpIfNeeded(PartitionChangeBuilderTest.createFooBuilder(metadataVersion).setTargetReplicas(List.of(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(4))), new PartitionChangeRecord(), 1);
    }

    @ParameterizedTest
    @ValueSource(strings={"3.4-IV0", "3.5-IV2", "3.6-IV0", "3.7-IV2"})
    public void testNoLeaderEpochBumpOnEmptyTargetIsr(String metadataVersionString) {
        MetadataVersion metadataVersion = MetadataVersion.fromVersionString((String)metadataVersionString);
        PartitionRegistration partition = new PartitionRegistration.Builder().setReplicas(new int[]{2}).setDirectories(new Uuid[]{Uuid.fromString((String)"dpdvA5AZSWySmnPFTnu5Kw")}).setIsr(new int[]{2}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionChangeBuilder builder = new PartitionChangeBuilder(partition, FOO_ID, 0, r -> true, metadataVersion, 2).setEligibleLeaderReplicasEnabled(metadataVersion.isElrSupported()).setDefaultDirProvider(DEFAULT_DIR_PROVIDER).setTargetReplicas(List.of());
        PartitionChangeRecord record = new PartitionChangeRecord();
        builder.triggerLeaderEpochBumpForIsrShrinkIfNeeded(record);
        Assertions.assertEquals((int)-2, (int)record.leader());
    }

    @ParameterizedTest
    @MethodSource(value={"partitionChangeRecordVersions"})
    public void testNoChange(short version) {
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createFooBuilder(version).build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createFooBuilder(version).setElection(PartitionChangeBuilder.Election.UNCLEAN).build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createBarBuilder(version).build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createBarBuilder(version).setElection(PartitionChangeBuilder.Election.UNCLEAN).build());
        Assertions.assertEquals(Optional.empty(), (Object)PartitionChangeBuilderTest.createBazBuilder(version).setElection(PartitionChangeBuilder.Election.PREFERRED).build());
    }

    @ParameterizedTest
    @MethodSource(value={"partitionChangeRecordVersions"})
    public void testIsrChangeDoesntBumpLeaderEpoch(short version) {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setIsr(List.of(Integer.valueOf(2), Integer.valueOf(1))), version)), (Object)PartitionChangeBuilderTest.createFooBuilder(version).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(2), Integer.valueOf(1)))).build());
    }

    @ParameterizedTest
    @MethodSource(value={"partitionChangeRecordVersions"})
    public void testIsrChangeAndLeaderChange(short version) {
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setIsr(List.of(Integer.valueOf(2), Integer.valueOf(3))).setLeader(2), version)), (Object)PartitionChangeBuilderTest.createFooBuilder(version).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(2), Integer.valueOf(3)))).build());
    }

    @ParameterizedTest
    @MethodSource(value={"partitionChangeRecordVersions"})
    public void testReassignmentRearrangesReplicas(short version) {
        PartitionChangeRecord expectedRecord = new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(List.of(Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1)));
        if (version >= 1) {
            Map dirs = DirectoryId.createAssignmentMap((int[])PartitionChangeBuilderTest.FOO.replicas, (Uuid[])PartitionChangeBuilderTest.FOO.directories);
            expectedRecord.setDirectories(List.of((Uuid)dirs.get(3), (Uuid)dirs.get(2), (Uuid)dirs.get(1)));
        }
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)expectedRecord, version)), (Object)PartitionChangeBuilderTest.createFooBuilder(version).setTargetReplicas(List.of(Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1))).build());
    }

    @ParameterizedTest
    @MethodSource(value={"partitionChangeRecordVersions"})
    public void testIsrEnlargementCompletesReassignment(short version) {
        PartitionChangeRecord expectedRecord = new PartitionChangeRecord().setTopicId(BAR_ID).setPartitionId(0).setReplicas(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4))).setIsr(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4))).setLeader(2).setRemovingReplicas(List.of()).setAddingReplicas(List.of());
        if (version >= 1) {
            Map dirs = DirectoryId.createAssignmentMap((int[])PartitionChangeBuilderTest.BAR.replicas, (Uuid[])PartitionChangeBuilderTest.BAR.directories);
            expectedRecord.setDirectories(List.of((Uuid)dirs.get(2), (Uuid)dirs.get(3), (Uuid)dirs.get(4)));
        }
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)expectedRecord, version)), (Object)PartitionChangeBuilderTest.createBarBuilder(version).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)))).build());
    }

    @ParameterizedTest
    @MethodSource(value={"partitionChangeRecordVersions"})
    public void testRevertReassignment(short version) {
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(BAR);
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), (Object)revert.replicas());
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), (Object)revert.isr());
        PartitionChangeRecord expectedRecord = new PartitionChangeRecord().setTopicId(BAR_ID).setPartitionId(0).setReplicas(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))).setLeader(1).setRemovingReplicas(List.of()).setAddingReplicas(List.of());
        if (version >= 1) {
            Map dirs = DirectoryId.createAssignmentMap((int[])PartitionChangeBuilderTest.BAR.replicas, (Uuid[])PartitionChangeBuilderTest.BAR.directories);
            expectedRecord.setDirectories(List.of((Uuid)dirs.get(1), (Uuid)dirs.get(2), (Uuid)dirs.get(3)));
        }
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)expectedRecord, version)), (Object)PartitionChangeBuilderTest.createBarBuilder(version).setTargetReplicas(revert.replicas()).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs((List)revert.isr())).setTargetRemoving(List.of()).setTargetAdding(List.of()).build());
    }

    @ParameterizedTest
    @MethodSource(value={"partitionChangeRecordVersions"})
    public void testRemovingReplicaReassignment(short version) {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(Replicas.toList((int[])PartitionChangeBuilderTest.FOO.replicas)), PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(1), Integer.valueOf(2))));
        Assertions.assertEquals(List.of(Integer.valueOf(3)), (Object)replicas.removing());
        Assertions.assertEquals(List.of(), (Object)replicas.adding());
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), (Object)replicas.replicas());
        PartitionChangeRecord expectedRecord = new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(List.of(Integer.valueOf(1), Integer.valueOf(2))).setIsr(List.of(Integer.valueOf(2), Integer.valueOf(1))).setLeader(1);
        if (version >= 1) {
            Map dirs = DirectoryId.createAssignmentMap((int[])PartitionChangeBuilderTest.FOO.replicas, (Uuid[])PartitionChangeBuilderTest.FOO.directories);
            expectedRecord.setDirectories(List.of((Uuid)dirs.get(1), (Uuid)dirs.get(2)));
        }
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)expectedRecord, version)), (Object)PartitionChangeBuilderTest.createFooBuilder(version).setTargetReplicas(replicas.replicas()).setTargetRemoving(replicas.removing()).build());
    }

    @ParameterizedTest
    @MethodSource(value={"partitionChangeRecordVersions"})
    public void testAddingReplicaReassignment(short version) {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(Replicas.toList((int[])PartitionChangeBuilderTest.FOO.replicas)), PartitionAssignmentTest.partitionAssignment(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4))));
        Assertions.assertEquals(List.of(), (Object)replicas.removing());
        Assertions.assertEquals(List.of(Integer.valueOf(4)), (Object)replicas.adding());
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), (Object)replicas.replicas());
        PartitionChangeRecord expectedRecord = new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setReplicas(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4))).setAddingReplicas(List.of(Integer.valueOf(4)));
        if (version >= 1) {
            Map dirs = DirectoryId.createAssignmentMap((int[])PartitionChangeBuilderTest.FOO.replicas, (Uuid[])PartitionChangeBuilderTest.FOO.directories);
            expectedRecord.setDirectories(List.of((Uuid)dirs.get(1), (Uuid)dirs.get(2), (Uuid)dirs.get(3), DirectoryId.UNASSIGNED));
        }
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)expectedRecord, version)), (Object)PartitionChangeBuilderTest.createFooBuilder(version).setTargetReplicas(replicas.replicas()).setTargetAdding(replicas.adding()).build());
    }

    @ParameterizedTest
    @MethodSource(value={"partitionChangeRecordVersions"})
    public void testUncleanLeaderElection(short version) {
        ApiMessageAndVersion expectedRecord = new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setIsr(List.of(Integer.valueOf(2))).setLeader(2).setLeaderRecoveryState(LeaderRecoveryState.RECOVERING.value()), version);
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)PartitionChangeBuilderTest.createFooBuilder(version).setElection(PartitionChangeBuilder.Election.UNCLEAN).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(3)))).build());
        PartitionChangeRecord record = new PartitionChangeRecord().setTopicId(OFFLINE_ID).setPartitionId(0).setIsr(List.of(Integer.valueOf(1))).setLeader(1).setLeaderRecoveryState(LeaderRecoveryState.RECOVERING.value());
        if (version >= 2) {
            record.setEligibleLeaderReplicas(List.of()).setLastKnownElr(List.of());
        }
        expectedRecord = new ApiMessageAndVersion((ApiMessage)record, version);
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)PartitionChangeBuilderTest.createOfflineBuilder(version).setElection(PartitionChangeBuilder.Election.UNCLEAN).build());
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)PartitionChangeBuilderTest.createOfflineBuilder(version).setElection(PartitionChangeBuilder.Election.UNCLEAN).setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(2)))).build());
    }

    @Test
    public void testChangeInLeadershipDoesNotChangeRecoveryState() {
        int noChange = -1;
        int leaderId = 1;
        LeaderRecoveryState recoveryState = LeaderRecoveryState.RECOVERING;
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{leaderId, leaderId + 1, leaderId + 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"1sF6XXLkSN2LtDums7CJ8Q"), Uuid.fromString((String)"iaBBVsoHQR6NDKXwliKMqw"), Uuid.fromString((String)"sHaBwjdrR2S3bL4E1RKC8Q")}).setIsr(new int[]{leaderId}).setLeader(Integer.valueOf(leaderId)).setLeaderRecoveryState(recoveryState).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        MetadataVersion metadataVersion = MetadataVersion.MINIMUM_VERSION;
        PartitionChangeBuilder offlineBuilder = new PartitionChangeBuilder(registration, FOO_ID, 0, brokerId -> false, metadataVersion, 2);
        offlineBuilder.setTargetIsrWithBrokerStates(List.of());
        PartitionChangeRecord changeRecord = (PartitionChangeRecord)((ApiMessageAndVersion)offlineBuilder.build().get()).message();
        Assertions.assertEquals((byte)-1, (byte)changeRecord.leaderRecoveryState());
        Assertions.assertEquals((int)-1, (int)changeRecord.leader());
        registration = registration.merge(changeRecord);
        Assertions.assertEquals((int)-1, (int)registration.leader);
        Assertions.assertEquals((int)leaderId, (int)registration.isr[0]);
        Assertions.assertEquals((Object)recoveryState, (Object)registration.leaderRecoveryState);
        PartitionChangeBuilder onlineBuilder = new PartitionChangeBuilder(registration, FOO_ID, 0, brokerId -> true, metadataVersion, 2);
        changeRecord = (PartitionChangeRecord)((ApiMessageAndVersion)onlineBuilder.build().get()).message();
        Assertions.assertEquals((byte)-1, (byte)changeRecord.leaderRecoveryState());
        registration = registration.merge(changeRecord);
        Assertions.assertEquals((int)leaderId, (int)registration.leader);
        Assertions.assertEquals((int)leaderId, (int)registration.isr[0]);
        Assertions.assertEquals((Object)recoveryState, (Object)registration.leaderRecoveryState);
    }

    @Test
    void testUncleanSetsLeaderRecoveringState() {
        int leaderId = 1;
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{leaderId, leaderId + 1, leaderId + 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"uYpxts0pS4K4bk5XOoXB4g"), Uuid.fromString((String)"kS6fHEqwRYucduWkmvsevw"), Uuid.fromString((String)"De9RqRThQRGjKg3i3yzUxA")}).setIsr(new int[]{leaderId + 1, leaderId + 2}).setLeader(Integer.valueOf(-1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        MetadataVersion metadataVersion = MetadataVersion.MINIMUM_VERSION;
        PartitionChangeBuilder onlineBuilder = new PartitionChangeBuilder(registration, FOO_ID, 0, brokerId -> brokerId == leaderId, metadataVersion, 2).setElection(PartitionChangeBuilder.Election.UNCLEAN);
        PartitionChangeRecord changeRecord = (PartitionChangeRecord)((ApiMessageAndVersion)onlineBuilder.build().get()).message();
        Assertions.assertEquals((byte)LeaderRecoveryState.RECOVERING.value(), (byte)changeRecord.leaderRecoveryState());
        Assertions.assertEquals((int)leaderId, (int)changeRecord.leader());
        Assertions.assertEquals((int)1, (int)changeRecord.isr().size());
        Assertions.assertEquals((int)leaderId, (Integer)((Integer)changeRecord.isr().get(0)));
        registration = registration.merge(changeRecord);
        Assertions.assertEquals((int)leaderId, (int)registration.leader);
        Assertions.assertEquals((int)leaderId, (int)registration.isr[0]);
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERING, (Object)registration.leaderRecoveryState);
    }

    @Test
    public void testStoppedLeaderIsDemotedAfterReassignmentCompletesEvenIfNoNewEligibleLeaders() {
        int[] replicas = new int[]{2, 3, 0, 1};
        Uuid[] directories = new Uuid[]{Uuid.fromString((String)"XCBQClkBSZyphD87QUXzDA"), Uuid.fromString((String)"Or2Rp9tTQOSVuy12hsfmTA"), Uuid.fromString((String)"pThsodMNSwGvljTfc1RNVQ"), Uuid.fromString((String)"d8CGoNJmS5mJdF20tc8P7g")};
        int[] isr = new int[]{0, 1};
        int[] removingReplicas = new int[]{0, 1};
        int[] addingReplicas = new int[]{2, 3};
        int leader = 0;
        LeaderRecoveryState leaderRecoveryState = LeaderRecoveryState.RECOVERED;
        int leaderEpoch = 0;
        int partitionEpoch = 0;
        PartitionRegistration part = new PartitionRegistration.Builder().setReplicas(replicas).setDirectories(directories).setIsr(isr).setRemovingReplicas(removingReplicas).setAddingReplicas(addingReplicas).setLeader(Integer.valueOf(leader)).setLeaderRecoveryState(leaderRecoveryState).setLeaderEpoch(Integer.valueOf(leaderEpoch)).setPartitionEpoch(Integer.valueOf(partitionEpoch)).build();
        Uuid topicId = Uuid.randomUuid();
        IntPredicate isValidLeader = l -> false;
        PartitionChangeBuilder partitionChangeBuilder = new PartitionChangeBuilder(part, topicId, 0, isValidLeader, MetadataVersion.MINIMUM_VERSION, 2);
        Assertions.assertEquals((int)0, (int)part.leader);
        Assertions.assertEquals(Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setReplicas(List.of(Integer.valueOf(2), Integer.valueOf(3))).setIsr(List.of(Integer.valueOf(2), Integer.valueOf(3))).setRemovingReplicas(List.of()).setAddingReplicas(List.of()).setLeader(-1), 0)), (Object)partitionChangeBuilder.setTargetIsr(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))).build());
    }

    @ParameterizedTest
    @MethodSource(value={"partitionChangeRecordVersions"})
    public void testEligibleLeaderReplicas_IsrShrinkBelowMinISR(short version) {
        PartitionRegistration partition = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setDirectories(new Uuid[]{Uuid.fromString((String)"NeQeLdHhSXi4tQGaFcszKA"), Uuid.fromString((String)"LsVrQZ73RSSuEWA8hhqQhg"), Uuid.fromString((String)"0IaY4zXKRR6sROgE8yHfnw"), Uuid.fromString((String)"1WxphfLCSZqMHKK4JMppuw")}).setIsr(new int[]{1, 2, 3, 4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Uuid topicId = Uuid.fromString((String)"FbrrdcfiR-KC2CPSTHaJrg");
        PartitionChangeBuilder builder = new PartitionChangeBuilder(partition, topicId, 0, r -> r != 3, PartitionChangeBuilderTest.metadataVersionForPartitionChangeRecordVersion(version), 3).setElection(PartitionChangeBuilder.Election.PREFERRED).setEligibleLeaderReplicasEnabled(PartitionChangeBuilderTest.isElrEnabled(version)).setDefaultDirProvider(DEFAULT_DIR_PROVIDER).setUseLastKnownLeaderInBalancedRecovery(false);
        builder.setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(1), Integer.valueOf(2))));
        PartitionChangeRecord record = new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setIsr(List.of(Integer.valueOf(1), Integer.valueOf(2))).setLeader(-2).setLeaderRecoveryState((byte)-1);
        if (version >= 2) {
            record.setEligibleLeaderReplicas(List.of(Integer.valueOf(3), Integer.valueOf(4)));
        }
        ApiMessageAndVersion expectedRecord = new ApiMessageAndVersion((ApiMessage)record, version);
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)builder.build());
        partition = partition.merge((PartitionChangeRecord)((ApiMessageAndVersion)builder.build().get()).message());
        if (version >= 2) {
            Assertions.assertArrayEquals((int[])new int[]{3, 4}, (int[])partition.elr, (String)partition.toString());
            Assertions.assertArrayEquals((int[])new int[0], (int[])partition.lastKnownElr, (String)partition.toString());
        } else {
            Assertions.assertEquals((int)0, (int)partition.elr.length);
            Assertions.assertEquals((int)0, (int)partition.lastKnownElr.length);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"partitionChangeRecordVersions"})
    public void testEligibleLeaderReplicas_IsrExpandAboveMinISR(short version) {
        PartitionRegistration partition = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setDirectories(new Uuid[]{Uuid.fromString((String)"CWgRKBKkToGn1HKzNb2qqQ"), Uuid.fromString((String)"SCnk7zfSQSmlKqvV702d3A"), Uuid.fromString((String)"9tO0QHlJRhimjKfH8m9d8A"), Uuid.fromString((String)"JaaqVOxNT2OGVNCCIFA2JQ")}).setIsr(new int[]{1, 2}).setElr(new int[]{3}).setLastKnownElr(new int[]{4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Uuid topicId = Uuid.fromString((String)"FbrrdcfiR-KC2CPSTHaJrg");
        PartitionChangeBuilder builder = new PartitionChangeBuilder(partition, topicId, 0, r -> r != 3, PartitionChangeBuilderTest.metadataVersionForPartitionChangeRecordVersion(version), 3).setElection(PartitionChangeBuilder.Election.PREFERRED).setEligibleLeaderReplicasEnabled(PartitionChangeBuilderTest.isElrEnabled(version)).setDefaultDirProvider(DEFAULT_DIR_PROVIDER).setUseLastKnownLeaderInBalancedRecovery(false);
        builder.setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))));
        PartitionChangeRecord record = new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setIsr(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))).setLeader(-2).setLeaderRecoveryState((byte)-1);
        record.setEligibleLeaderReplicas(List.of()).setLastKnownElr(List.of());
        ApiMessageAndVersion expectedRecord = new ApiMessageAndVersion((ApiMessage)record, version);
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)builder.build());
        partition = partition.merge((PartitionChangeRecord)((ApiMessageAndVersion)builder.build().get()).message());
        Assertions.assertEquals((int)0, (int)partition.elr.length);
        Assertions.assertEquals((int)0, (int)partition.lastKnownElr.length);
    }

    @ParameterizedTest
    @MethodSource(value={"partitionChangeRecordVersions"})
    public void testEligibleLeaderReplicas_IsrAddNewMemberNotInELR(short version) {
        PartitionRegistration partition = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setDirectories(new Uuid[]{Uuid.fromString((String)"gPcIwlldQXikdUB3F4GB6w"), Uuid.fromString((String)"gFs7V8mKR66z8e5qwtjIMA"), Uuid.fromString((String)"zKHU2fwrRkuypqTgITl46g"), Uuid.fromString((String)"zEgmBBh8QJGqbBIvzvH7JA")}).setIsr(new int[]{1}).setElr(new int[]{3}).setLastKnownElr(new int[]{2}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Uuid topicId = Uuid.fromString((String)"FbrrdcfiR-KC2CPSTHaJrg");
        PartitionChangeBuilder builder = new PartitionChangeBuilder(partition, topicId, 0, r -> r != 3, PartitionChangeBuilderTest.metadataVersionForPartitionChangeRecordVersion(version), 3).setElection(PartitionChangeBuilder.Election.PREFERRED).setEligibleLeaderReplicasEnabled(PartitionChangeBuilderTest.isElrEnabled(version)).setDefaultDirProvider(DEFAULT_DIR_PROVIDER).setUseLastKnownLeaderInBalancedRecovery(false);
        builder.setTargetIsrWithBrokerStates(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(List.of(Integer.valueOf(1), Integer.valueOf(4))));
        PartitionChangeRecord record = new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setIsr(List.of(Integer.valueOf(1), Integer.valueOf(4))).setLeader(-2).setLeaderRecoveryState((byte)-1);
        if (version < 2) {
            record.setEligibleLeaderReplicas(List.of());
            record.setLastKnownElr(List.of());
        }
        ApiMessageAndVersion expectedRecord = new ApiMessageAndVersion((ApiMessage)record, version);
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)builder.build());
        partition = partition.merge((PartitionChangeRecord)((ApiMessageAndVersion)builder.build().get()).message());
        if (version >= 2) {
            Assertions.assertArrayEquals((int[])new int[]{3}, (int[])partition.elr, (String)partition.toString());
            Assertions.assertArrayEquals((int[])new int[]{2}, (int[])partition.lastKnownElr, (String)partition.toString());
        } else {
            Assertions.assertArrayEquals((int[])new int[0], (int[])partition.elr, (String)partition.toString());
            Assertions.assertArrayEquals((int[])new int[0], (int[])partition.lastKnownElr, (String)partition.toString());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"partitionChangeRecordVersions"})
    public void testEligibleLeaderReplicas_RemoveUncleanShutdownReplicasFromElr(short version) {
        PartitionRegistration partition = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setDirectories(new Uuid[]{Uuid.fromString((String)"keB9ssIPRlibyVJT5FcBVA"), Uuid.fromString((String)"FhezfoReTSmHoKxi8wOIOg"), Uuid.fromString((String)"QHtFxu8LShm6RiyAP6PxYg"), Uuid.fromString((String)"tUJOMtvMQkGga30ydluvbQ")}).setIsr(new int[]{1}).setElr(new int[]{2, 3}).setLastKnownElr(new int[0]).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Uuid topicId = Uuid.fromString((String)"FbrrdcfiR-KC2CPSTHaJrg");
        PartitionChangeBuilder builder = new PartitionChangeBuilder(partition, topicId, 0, r -> r != 3, PartitionChangeBuilderTest.metadataVersionForPartitionChangeRecordVersion(version), 3).setElection(PartitionChangeBuilder.Election.PREFERRED).setEligibleLeaderReplicasEnabled(PartitionChangeBuilderTest.isElrEnabled(version)).setDefaultDirProvider(DEFAULT_DIR_PROVIDER).setUseLastKnownLeaderInBalancedRecovery(false);
        builder.setUncleanShutdownReplicas(List.of(Integer.valueOf(3)));
        PartitionChangeRecord record = new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setLeader(-2).setLeaderRecoveryState((byte)-1);
        if (version >= 2) {
            record.setEligibleLeaderReplicas(List.of(Integer.valueOf(2))).setLastKnownElr(List.of(Integer.valueOf(3)));
        } else {
            record.setEligibleLeaderReplicas(List.of());
        }
        ApiMessageAndVersion expectedRecord = new ApiMessageAndVersion((ApiMessage)record, version);
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)builder.build());
        partition = partition.merge((PartitionChangeRecord)((ApiMessageAndVersion)builder.build().get()).message());
        if (version >= 2) {
            Assertions.assertArrayEquals((int[])new int[]{2}, (int[])partition.elr, (String)partition.toString());
            Assertions.assertArrayEquals((int[])new int[]{3}, (int[])partition.lastKnownElr, (String)partition.toString());
        } else {
            Assertions.assertArrayEquals((int[])new int[0], (int[])partition.elr, (String)partition.toString());
            Assertions.assertArrayEquals((int[])new int[0], (int[])partition.lastKnownElr, (String)partition.toString());
        }
    }

    @Test
    public void testKeepsDirectoriesAfterReassignment() {
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{2, 1, 3}).setDirectories(new Uuid[]{Uuid.fromString((String)"v1PVrX6uS5m8CByXlLfmWg"), Uuid.fromString((String)"iU2znv45Q9yQkOpkTSy3jA"), Uuid.fromString((String)"fM5NKyWTQHqEihjIkUl99Q")}).setIsr(new int[]{2, 1, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Optional built = new PartitionChangeBuilder(registration, FOO_ID, 0, r -> true, MetadataVersion.IBP_3_7_IV2, 2).setTargetReplicas(List.of(Integer.valueOf(3), Integer.valueOf(1), Integer.valueOf(5), Integer.valueOf(4))).setDirectory(5, Uuid.fromString((String)"RNJ5oFjjSSWMMFRwqdCfJg")).setDefaultDirProvider(DEFAULT_DIR_PROVIDER).build();
        Optional<ApiMessageAndVersion> expected = Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setLeader(1).setReplicas(List.of(Integer.valueOf(3), Integer.valueOf(1), Integer.valueOf(5), Integer.valueOf(4))).setDirectories(List.of(Uuid.fromString((String)"fM5NKyWTQHqEihjIkUl99Q"), Uuid.fromString((String)"iU2znv45Q9yQkOpkTSy3jA"), Uuid.fromString((String)"RNJ5oFjjSSWMMFRwqdCfJg"), DirectoryId.UNASSIGNED)), 1));
        Assertions.assertEquals(expected, (Object)built);
    }

    @Test
    public void testUpdateDirectories() {
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{2, 1, 3}).setDirectories(new Uuid[]{Uuid.fromString((String)"S1zMYZczRjWmucidLqGA5g"), Uuid.fromString((String)"9eRNXTvFTsWUJObvW51V5A"), Uuid.fromString((String)"UpePYVBgRAi3c4ujQrf3Kg")}).setIsr(new int[]{2, 1, 3}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Optional built = new PartitionChangeBuilder(registration, FOO_ID, 0, r -> true, MetadataVersion.latestTesting(), 2).setDirectory(3, Uuid.fromString((String)"pN1VKs9zRzK4APflpegAVg")).setDirectory(1, DirectoryId.LOST).setDefaultDirProvider(DEFAULT_DIR_PROVIDER).build();
        Optional<ApiMessageAndVersion> expected = Optional.of(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(FOO_ID).setPartitionId(0).setDirectories(List.of(Uuid.fromString((String)"S1zMYZczRjWmucidLqGA5g"), DirectoryId.LOST, Uuid.fromString((String)"pN1VKs9zRzK4APflpegAVg"))), 2));
        Assertions.assertEquals(expected, (Object)built);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testEligibleLeaderReplicas_ElrCanBeElected(boolean lastKnownLeaderEnabled) {
        int[] nArray;
        int[] nArray2;
        short version = 2;
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setDirectories(DirectoryId.migratingArray((int)4)).setIsr(new int[]{1}).setElr(new int[]{3});
        if (lastKnownLeaderEnabled) {
            nArray2 = new int[]{};
        } else {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = 2;
        }
        PartitionRegistration partition = builder.setLastKnownElr(nArray2).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Uuid topicId = Uuid.fromString((String)"FbrrdcfiR-KC2CPSTHaJrg");
        PartitionChangeBuilder builder2 = new PartitionChangeBuilder(partition, topicId, 0, r -> r != 1, PartitionChangeBuilderTest.metadataVersionForPartitionChangeRecordVersion(version), 3).setElection(PartitionChangeBuilder.Election.PREFERRED).setEligibleLeaderReplicasEnabled(PartitionChangeBuilderTest.isElrEnabled(version)).setUseLastKnownLeaderInBalancedRecovery(lastKnownLeaderEnabled).setDefaultDirProvider(DEFAULT_DIR_PROVIDER);
        builder2.setTargetIsr(List.of());
        ApiMessageAndVersion expectedRecord = new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setIsr(List.of(Integer.valueOf(3))).setEligibleLeaderReplicas(List.of(Integer.valueOf(1))).setLeader(3).setLeaderRecoveryState((byte)-1), version);
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)builder2.build());
        partition = partition.merge((PartitionChangeRecord)((ApiMessageAndVersion)builder2.build().get()).message());
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])partition.elr, (String)partition.toString());
        if (lastKnownLeaderEnabled) {
            nArray = new int[]{};
        } else {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = 2;
        }
        Assertions.assertArrayEquals((int[])nArray, (int[])partition.lastKnownElr, (String)partition.toString());
        Assertions.assertArrayEquals((int[])new int[]{3}, (int[])partition.isr, (String)partition.toString());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testEligibleLeaderReplicas_IsrCanShrinkToZero(boolean lastKnownLeaderEnabled) {
        short version = 2;
        PartitionRegistration partition = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setDirectories(new Uuid[]{Uuid.fromString((String)"MrTKKPEpRv66ZpWv4V7EBQ"), Uuid.fromString((String)"CkvgdEcWTVmdhfNuJXL0xA"), Uuid.fromString((String)"4a2coMsPRkSCsiTVWSksSw"), Uuid.fromString((String)"tmPdVjzASZ2ZqiS0cVJvtQ")}).setIsr(new int[]{1, 2, 3, 4}).setElr(new int[0]).setLastKnownElr(new int[0]).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Uuid topicId = Uuid.fromString((String)"FbrrdcfiR-KC2CPSTHaJrg");
        PartitionChangeBuilder builder = new PartitionChangeBuilder(partition, topicId, 0, r -> false, PartitionChangeBuilderTest.metadataVersionForPartitionChangeRecordVersion(version), 3).setElection(PartitionChangeBuilder.Election.PREFERRED).setEligibleLeaderReplicasEnabled(true).setDefaultDirProvider(DEFAULT_DIR_PROVIDER).setUseLastKnownLeaderInBalancedRecovery(lastKnownLeaderEnabled);
        builder.setTargetIsr(List.of());
        PartitionChangeRecord record = new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setIsr(List.of()).setLeader(-1).setLeaderRecoveryState((byte)-1).setEligibleLeaderReplicas(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)));
        if (lastKnownLeaderEnabled) {
            record.setLastKnownElr(List.of(Integer.valueOf(1)));
        }
        ApiMessageAndVersion expectedRecord = new ApiMessageAndVersion((ApiMessage)record, version);
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)builder.build());
        partition = partition.merge((PartitionChangeRecord)((ApiMessageAndVersion)builder.build().get()).message());
        Assertions.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])partition.elr, (String)partition.toString());
        if (lastKnownLeaderEnabled) {
            Assertions.assertArrayEquals((int[])new int[]{1}, (int[])partition.lastKnownElr, (String)partition.toString());
            builder = new PartitionChangeBuilder(partition, topicId, 0, r -> false, PartitionChangeBuilderTest.metadataVersionForPartitionChangeRecordVersion(version), 3).setElection(PartitionChangeBuilder.Election.PREFERRED).setEligibleLeaderReplicasEnabled(true).setUncleanShutdownReplicas(List.of(Integer.valueOf(2))).setDefaultDirProvider(DEFAULT_DIR_PROVIDER).setUseLastKnownLeaderInBalancedRecovery(lastKnownLeaderEnabled);
            PartitionChangeRecord changeRecord = (PartitionChangeRecord)((ApiMessageAndVersion)builder.build().get()).message();
            Assertions.assertNull((Object)changeRecord.lastKnownElr(), (String)changeRecord.toString());
        } else {
            Assertions.assertArrayEquals((int[])new int[0], (int[])partition.lastKnownElr, (String)partition.toString());
        }
        Assertions.assertArrayEquals((int[])new int[0], (int[])partition.isr, (String)partition.toString());
    }

    @Test
    public void testEligibleLeaderReplicas_ElectLastKnownLeader() {
        short version = 2;
        PartitionRegistration partition = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setDirectories(DirectoryId.migratingArray((int)4)).setIsr(new int[0]).setElr(new int[0]).setLastKnownElr(new int[]{1}).setLeader(Integer.valueOf(-1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Uuid topicId = Uuid.fromString((String)"FbrrdcfiR-KC2CPSTHaJrg");
        PartitionChangeBuilder builder = new PartitionChangeBuilder(partition, topicId, 0, r -> true, PartitionChangeBuilderTest.metadataVersionForPartitionChangeRecordVersion(version), 3).setElection(PartitionChangeBuilder.Election.PREFERRED).setUseLastKnownLeaderInBalancedRecovery(true).setDefaultDirProvider(DEFAULT_DIR_PROVIDER).setEligibleLeaderReplicasEnabled(true);
        builder.setTargetIsr(List.of());
        ApiMessageAndVersion expectedRecord = new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setIsr(List.of(Integer.valueOf(1))).setLeader(1).setLeaderRecoveryState(LeaderRecoveryState.RECOVERING.value()).setLastKnownElr(List.of()), version);
        Assertions.assertEquals(Optional.of(expectedRecord), (Object)builder.build());
        partition = partition.merge((PartitionChangeRecord)((ApiMessageAndVersion)builder.build().get()).message());
        Assertions.assertArrayEquals((int[])new int[0], (int[])partition.elr, (String)partition.toString());
        Assertions.assertArrayEquals((int[])new int[0], (int[])partition.lastKnownElr, (String)partition.toString());
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])partition.isr, (String)partition.toString());
    }

    @Test
    public void testEligibleLeaderReplicas_ElectLastKnownLeaderShouldFail() {
        short version = 2;
        PartitionRegistration partition = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setDirectories(new Uuid[]{Uuid.fromString((String)"zANDdMukTEqefOvHpmniMg"), Uuid.fromString((String)"Ui2Eq8rbRiuW7m7uiPTRyg"), Uuid.fromString((String)"MhgJOZrrTsKNcGM0XKK4aA"), Uuid.fromString((String)"Y25PaCAmRfyGIKxAThhBAw")}).setIsr(new int[0]).setElr(new int[]{3}).setLastKnownElr(new int[]{1}).setLeader(Integer.valueOf(-1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Uuid topicId = Uuid.fromString((String)"FbrrdcfiR-KC2CPSTHaJrg");
        PartitionChangeBuilder builder = new PartitionChangeBuilder(partition, topicId, 0, r -> r != 3, PartitionChangeBuilderTest.metadataVersionForPartitionChangeRecordVersion(version), 3).setElection(PartitionChangeBuilder.Election.PREFERRED).setEligibleLeaderReplicasEnabled(true).setDefaultDirProvider(DEFAULT_DIR_PROVIDER).setUseLastKnownLeaderInBalancedRecovery(true);
        builder.setTargetIsr(List.of());
        Assertions.assertEquals(Optional.empty(), (Object)builder.build());
    }

    @ParameterizedTest
    @EnumSource(value=PartitionChangeBuilder.Election.class)
    public void testEligibleLeaderReplicas_NotEligibleLastKnownLeader(PartitionChangeBuilder.Election type) {
        short version = 2;
        PartitionRegistration partition = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setDirectories(new Uuid[]{Uuid.fromString((String)"zANDdMukTEqefOvHpmniMg"), Uuid.fromString((String)"Ui2Eq8rbRiuW7m7uiPTRyg"), Uuid.fromString((String)"MhgJOZrrTsKNcGM0XKK4aA"), Uuid.fromString((String)"Y25PaCAmRfyGIKxAThhBAw")}).setIsr(new int[0]).setElr(new int[0]).setLastKnownElr(new int[]{1}).setLeader(Integer.valueOf(-1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Uuid topicId = Uuid.fromString((String)"FbrrdcfiR-KC2CPSTHaJrg");
        PartitionChangeBuilder builder = new PartitionChangeBuilder(partition, topicId, 0, r -> false, PartitionChangeBuilderTest.metadataVersionForPartitionChangeRecordVersion(version), 3).setElection(type).setEligibleLeaderReplicasEnabled(true).setDefaultDirProvider(DEFAULT_DIR_PROVIDER).setUseLastKnownLeaderInBalancedRecovery(true);
        builder.setTargetIsr(List.of());
        Assertions.assertEquals(Optional.empty(), (Object)builder.build());
    }
}

