/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.AbstractMap;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.controller.EventPerformanceMonitor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EventPerformanceMonitorTest {
    @Test
    public void testDefaultPeriodNs() {
        Assertions.assertEquals((long)TimeUnit.SECONDS.toNanos(60L), (long)new EventPerformanceMonitor.Builder().build().periodNs());
    }

    @Test
    public void testSlowestEventWithNoEvents() {
        EventPerformanceMonitor monitor = new EventPerformanceMonitor.Builder().build();
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<Object, Long>(null, 0L), (Object)monitor.slowestEvent());
    }

    @Test
    public void testSlowestEventWithThreeEvents() {
        EventPerformanceMonitor monitor = new EventPerformanceMonitor.Builder().build();
        monitor.observeEvent("fastEvent", TimeUnit.MILLISECONDS.toNanos(2L));
        monitor.observeEvent("slowEvent", TimeUnit.MILLISECONDS.toNanos(100L));
        Assertions.assertEquals(new AbstractMap.SimpleImmutableEntry<String, Long>("slowEvent", TimeUnit.MILLISECONDS.toNanos(100L)), (Object)monitor.slowestEvent());
    }

    @Test
    public void testLogSlowEvent() {
        EventPerformanceMonitor monitor = new EventPerformanceMonitor.Builder().build();
        Assertions.assertEquals((Object)"Exceptionally slow controller event slowEvent took 5000 ms.", (Object)monitor.doObserveEvent("slowEvent", TimeUnit.SECONDS.toNanos(5L)));
    }

    @Test
    public void testDoNotLogFastEvent() {
        EventPerformanceMonitor monitor = new EventPerformanceMonitor.Builder().build();
        Assertions.assertNull((Object)monitor.doObserveEvent("slowEvent", TimeUnit.MILLISECONDS.toNanos(250L)));
    }

    @Test
    public void testFormatNsAsDecimalMsWithZero() {
        Assertions.assertEquals((Object)"0.00", (Object)EventPerformanceMonitor.formatNsAsDecimalMs((long)0L));
    }

    @Test
    public void testFormatNsAsDecimalMsWith100() {
        Assertions.assertEquals((Object)"100.00", (Object)EventPerformanceMonitor.formatNsAsDecimalMs((long)TimeUnit.MILLISECONDS.toNanos(100L)));
    }

    @Test
    public void testFormatNsAsDecimalMsWith123456789() {
        Assertions.assertEquals((Object)"123.46", (Object)EventPerformanceMonitor.formatNsAsDecimalMs((long)123456789L));
    }

    @Test
    public void testPeriodicPerformanceMessageWithNoEvents() {
        EventPerformanceMonitor monitor = new EventPerformanceMonitor.Builder().build();
        Assertions.assertEquals((Object)"In the last 60000 ms period, there were no controller events completed.", (Object)monitor.periodicPerformanceMessage());
    }

    @Test
    public void testPeriodicPerformanceMessageWithOneEvent() {
        EventPerformanceMonitor monitor = new EventPerformanceMonitor.Builder().build();
        monitor.observeEvent("myEvent", TimeUnit.MILLISECONDS.toNanos(12L));
        Assertions.assertEquals((Object)"In the last 60000 ms period, 1 controller events were completed, which took an average of 12.00 ms each. The slowest event was myEvent, which took 12.00 ms.", (Object)monitor.periodicPerformanceMessage());
    }

    @Test
    public void testPeriodicPerformanceMessageWithThreeEvents() {
        EventPerformanceMonitor monitor = new EventPerformanceMonitor.Builder().build();
        monitor.observeEvent("myEvent", TimeUnit.MILLISECONDS.toNanos(12L));
        monitor.observeEvent("myEvent2", TimeUnit.MILLISECONDS.toNanos(19L));
        monitor.observeEvent("myEvent3", TimeUnit.MILLISECONDS.toNanos(1L));
        Assertions.assertEquals((Object)"In the last 60000 ms period, 3 controller events were completed, which took an average of 10.67 ms each. The slowest event was myEvent2, which took 19.00 ms.", (Object)monitor.periodicPerformanceMessage());
    }

    @Test
    public void testGeneratePeriodicPerformanceMessageResetsState() {
        EventPerformanceMonitor monitor = new EventPerformanceMonitor.Builder().build();
        monitor.observeEvent("myEvent", TimeUnit.MILLISECONDS.toNanos(12L));
        monitor.observeEvent("myEvent2", TimeUnit.MILLISECONDS.toNanos(19L));
        monitor.observeEvent("myEvent3", TimeUnit.MILLISECONDS.toNanos(1L));
        monitor.generatePeriodicPerformanceMessage();
        Assertions.assertEquals((Object)"In the last 60000 ms period, there were no controller events completed.", (Object)monitor.periodicPerformanceMessage());
    }
}

