/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.controller.ConfigurationControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.EligibleLeaderReplicasVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.config.ConfigSynonym;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class ConfigurationControlManagerTest {
    static final Map<ConfigResource.Type, ConfigDef> CONFIGS = new HashMap<ConfigResource.Type, ConfigDef>();
    public static final Map<String, List<ConfigSynonym>> SYNONYMS;
    static final KafkaConfigSchema SCHEMA;
    static final ConfigResource BROKER0;
    static final ConfigResource MYTOPIC;

    static <A, B> Map<A, B> toMap(Map.Entry ... entries) {
        LinkedHashMap map = new LinkedHashMap();
        for (Map.Entry entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    static <A, B> Map.Entry<A, B> entry(A a, B b) {
        return new AbstractMap.SimpleImmutableEntry<A, B>(a, b);
    }

    @Test
    public void testReplay() {
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setKafkaConfigSchema(SCHEMA).build();
        Assertions.assertEquals(Map.of(), (Object)manager.getConfigs(BROKER0));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("foo.bar").setValue("1,2"));
        Assertions.assertEquals(Map.of("foo.bar", "1,2"), (Object)manager.getConfigs(BROKER0));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("foo.bar").setValue(null));
        Assertions.assertEquals(Map.of(), (Object)manager.getConfigs(BROKER0));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("x,y,z"));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("def").setValue("blah"));
        Assertions.assertEquals(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", "x,y,z"), ConfigurationControlManagerTest.entry("def", "blah")), (Object)manager.getConfigs(MYTOPIC));
        Assertions.assertEquals((Object)"x,y,z", (Object)manager.getTopicConfig(MYTOPIC.name(), "abc").value());
    }

    @Test
    public void testIncrementalAlterConfigs() {
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setFeatureControl(this.createFeatureControlManager()).setKafkaConfigSchema(SCHEMA).build();
        ControllerResult result = manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(BROKER0, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("baz", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SUBTRACT, "abc")), ConfigurationControlManagerTest.entry("quux", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "abc")))), ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.APPEND, "123"))))), true);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(List.of(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("123"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(BROKER0, new ApiError(Errors.INVALID_CONFIG, "Can't SUBTRACT to key baz because its type is not LIST.")), ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)result);
        RecordTestUtils.replayAll(manager, result.records());
        Assertions.assertEquals((Object)ControllerResult.atomicOf(List.of(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue(null), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.DELETE, "xyz"))))), true));
    }

    @Test
    public void testIncrementalAlterConfig() {
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setFeatureControl(this.createFeatureControlManager()).setKafkaConfigSchema(SCHEMA).build();
        Map keyToOps = ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.APPEND, "123")));
        ControllerResult result = manager.incrementalAlterConfig(MYTOPIC, keyToOps, true);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(List.of(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("123"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), (Object)ApiError.NONE), (Object)result);
        RecordTestUtils.replayAll(manager, result.records());
        Assertions.assertEquals((Object)ControllerResult.atomicOf(List.of(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue(null), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), (Object)ApiError.NONE), (Object)manager.incrementalAlterConfig(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.DELETE, "xyz"))), true));
        String largeValue = new String(new char[Short.MAX_VALUE - AlterConfigOp.OpType.APPEND.id() - 1]);
        Map largeValueOfOps = ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.APPEND, largeValue)));
        ControllerResult invalidConfigValueResult = manager.incrementalAlterConfig(MYTOPIC, largeValueOfOps, true);
        Assertions.assertEquals((Object)Errors.INVALID_CONFIG, (Object)((ApiError)invalidConfigValueResult.response()).error());
        Assertions.assertEquals((Object)"The configuration value cannot be added because it exceeds the maximum value size of 32767 bytes.", (Object)((ApiError)invalidConfigValueResult.response()).message());
    }

    @Test
    public void testIncrementalAlterMultipleConfigValues() {
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setFeatureControl(this.createFeatureControlManager()).setKafkaConfigSchema(SCHEMA).build();
        ControllerResult result = manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.APPEND, "123,456,789"))))), true);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(List.of(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("123,456,789"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)result);
        RecordTestUtils.replayAll(manager, result.records());
        result = manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.APPEND, "123,456"))))), true);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(List.of(), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)result);
        RecordTestUtils.replayAll(manager, result.records());
        result = manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SUBTRACT, "123,456"))))), true);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(List.of(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("789"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)result);
        RecordTestUtils.replayAll(manager, result.records());
        result = manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SUBTRACT, "123456"))))), true);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(List.of(), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)result);
        RecordTestUtils.replayAll(manager, result.records());
        Assertions.assertEquals((Object)"789", manager.getConfigs(MYTOPIC).get("abc"));
    }

    @Test
    public void testIncrementalAlterConfigsWithoutExistence() {
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setFeatureControl(this.createFeatureControlManager()).setKafkaConfigSchema(SCHEMA).setExistenceChecker((Consumer)TestExistenceChecker.INSTANCE).build();
        ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, "ExistingTopic");
        ControllerResult result = manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(BROKER0, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("quux", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "1")))), ConfigurationControlManagerTest.entry(existingTopic, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("def", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "newVal"))))), false);
        Assertions.assertEquals((Object)ControllerResult.atomicOf(List.of(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("ExistingTopic").setName("def").setValue("newVal"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(BROKER0, new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, "Unknown resource.")), ConfigurationControlManagerTest.entry(existingTopic, ApiError.NONE))), (Object)result);
    }

    @Test
    public void testIncrementalAlterConfigsWithPolicy() {
        MockAlterConfigsPolicy policy = new MockAlterConfigsPolicy(List.of(new AlterConfigPolicy.RequestMetadata(MYTOPIC, Map.of()), new AlterConfigPolicy.RequestMetadata(BROKER0, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("foo.bar", "123"), ConfigurationControlManagerTest.entry("quux", "456"), ConfigurationControlManagerTest.entry("broker.config.to.remove", null)))));
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setFeatureControl(this.createFeatureControlManager()).setKafkaConfigSchema(SCHEMA).setAlterConfigPolicy(Optional.of(policy)).build();
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("broker.config").setValue("123"));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(MYTOPIC.name()).setName("topic.config").setValue("123"));
        manager.replay(new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("broker.config.to.remove").setValue("123"));
        Assertions.assertEquals((Object)ControllerResult.atomicOf(List.of(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("foo.bar").setValue("123"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("quux").setValue("456"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setName("broker.config.to.remove").setValue(null), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, new ApiError(Errors.POLICY_VIOLATION, "Expected: AlterConfigPolicy.RequestMetadata(resource=ConfigResource(type=TOPIC, name='mytopic'), configs={}). Got: AlterConfigPolicy.RequestMetadata(resource=ConfigResource(type=TOPIC, name='mytopic'), configs={foo.bar=123})")), ConfigurationControlManagerTest.entry(BROKER0, ApiError.NONE))), (Object)manager.incrementalAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("foo.bar", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "123")))), ConfigurationControlManagerTest.entry(BROKER0, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("foo.bar", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "123")), ConfigurationControlManagerTest.entry("quux", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "456")), ConfigurationControlManagerTest.entry("broker.config.to.remove", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.DELETE, null))))), true));
    }

    @Test
    public void testLegacyAlterConfigs() {
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setFeatureControl(this.createFeatureControlManager()).setKafkaConfigSchema(SCHEMA).setAlterConfigPolicy(Optional.of(new CheckForNullValuesPolicy())).build();
        List<ApiMessageAndVersion> expectedRecords1 = List.of(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue("456"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("def").setValue("901"), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion()));
        Assertions.assertEquals((Object)ControllerResult.atomicOf(expectedRecords1, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)manager.legacyAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("abc", "456"), ConfigurationControlManagerTest.entry("def", "901")))), true));
        for (ApiMessageAndVersion message : expectedRecords1) {
            manager.replay((ConfigRecord)message.message());
        }
        Assertions.assertEquals((Object)ControllerResult.atomicOf(List.of(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("mytopic").setName("abc").setValue(null), MetadataRecordType.CONFIG_RECORD.highestSupportedVersion())), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ApiError.NONE))), (Object)manager.legacyAlterConfigs(ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry(MYTOPIC, ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("def", "901")))), true));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testMaybeGenerateElrSafetyRecords(boolean setStaticConfig) {
        ConfigurationControlManager.Builder builder = new ConfigurationControlManager.Builder().setFeatureControl(this.createFeatureControlManager()).setKafkaConfigSchema(SCHEMA);
        if (setStaticConfig) {
            builder.setStaticConfig(Map.of("min.insync.replicas", "2"));
        }
        ConfigurationControlManager manager = builder.build();
        Map keyToOps = ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("min.insync.replicas", ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "3")));
        ConfigResource brokerConfigResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        ControllerResult result = manager.incrementalAlterConfig(brokerConfigResource, keyToOps, true);
        Assertions.assertEquals(Set.of(), (Object)manager.brokersWithConfigs());
        Assertions.assertEquals((Object)ControllerResult.atomicOf(List.of(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("1").setName("min.insync.replicas").setValue("3"), 0)), (Object)ApiError.NONE), (Object)result);
        RecordTestUtils.replayAll(manager, result.records());
        Assertions.assertEquals(Set.of(Integer.valueOf(1)), (Object)manager.brokersWithConfigs());
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        String effectiveMinInsync = setStaticConfig ? "2" : "1";
        Assertions.assertEquals((Object)("Generating cluster-level min.insync.replicas of " + effectiveMinInsync + ". Removing broker-level min.insync.replicas for brokers: 1."), (Object)manager.maybeGenerateElrSafetyRecords(records));
        Assertions.assertEquals(List.of(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setName("min.insync.replicas").setValue(effectiveMinInsync), 0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("1").setName("min.insync.replicas").setValue(null), 0)), records);
        RecordTestUtils.replayAll(manager, records);
        Assertions.assertEquals(Set.of(), (Object)manager.brokersWithConfigs());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testRejectMinIsrChangeWhenElrEnabled(boolean removal) {
        FeatureControlManager featureManager = new FeatureControlManager.Builder().setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), List.of())).build();
        featureManager.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.LATEST_PRODUCTION.featureLevel()));
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setStaticConfig(Map.of("min.insync.replicas", "2")).setFeatureControl(featureManager).setKafkaConfigSchema(SCHEMA).build();
        ControllerResult result = manager.updateFeatures(Map.of("eligible.leader.replicas.version", EligibleLeaderReplicasVersion.ELRV_1.featureLevel()), Map.of("eligible.leader.replicas.version", FeatureUpdate.UpgradeType.UPGRADE), false, 0);
        Assertions.assertNotNull((Object)result.response());
        Assertions.assertEquals((Object)Errors.NONE, (Object)((ApiError)result.response()).error());
        RecordTestUtils.replayAll(manager, result.records());
        RecordTestUtils.replayAll(featureManager, result.records());
        result = manager.incrementalAlterConfig(new ConfigResource(ConfigResource.Type.BROKER, "1"), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("min.insync.replicas", removal ? ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.DELETE, null) : ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "3"))), true);
        Assertions.assertEquals((Object)Errors.INVALID_CONFIG, (Object)((ApiError)result.response()).error());
        Assertions.assertEquals((Object)"Broker-level min.insync.replicas cannot be altered while ELR is enabled.", (Object)((ApiError)result.response()).message());
        result = manager.incrementalAlterConfig(new ConfigResource(ConfigResource.Type.BROKER, ""), ConfigurationControlManagerTest.toMap(ConfigurationControlManagerTest.entry("min.insync.replicas", removal ? ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.DELETE, null) : ConfigurationControlManagerTest.entry(AlterConfigOp.OpType.SET, "3"))), true);
        if (removal) {
            Assertions.assertEquals((Object)Errors.INVALID_CONFIG, (Object)((ApiError)result.response()).error());
            Assertions.assertEquals((Object)"Cluster-level min.insync.replicas cannot be removed while ELR is enabled.", (Object)((ApiError)result.response()).message());
        } else {
            Assertions.assertEquals((Object)Errors.NONE, (Object)((ApiError)result.response()).error());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testElrUpgrade(boolean isMetadataVersionElrEnabled) {
        FeatureControlManager featureManager = new FeatureControlManager.Builder().setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), List.of())).build();
        featureManager.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(isMetadataVersionElrEnabled ? MetadataVersion.IBP_4_0_IV1.featureLevel() : MetadataVersion.IBP_4_0_IV0.featureLevel()));
        ConfigurationControlManager manager = new ConfigurationControlManager.Builder().setStaticConfig(Map.of("min.insync.replicas", "2")).setFeatureControl(featureManager).setKafkaConfigSchema(SCHEMA).build();
        Assertions.assertFalse((boolean)featureManager.isElrFeatureEnabled());
        ControllerResult result = manager.updateFeatures(Map.of("eligible.leader.replicas.version", EligibleLeaderReplicasVersion.ELRV_1.featureLevel()), Map.of("eligible.leader.replicas.version", FeatureUpdate.UpgradeType.UPGRADE), false, 0);
        Assertions.assertNotNull((Object)result.response());
        if (isMetadataVersionElrEnabled) {
            Assertions.assertEquals((Object)Errors.NONE, (Object)((ApiError)result.response()).error());
            RecordTestUtils.replayAll(manager, result.records());
            RecordTestUtils.replayAll(featureManager, result.records());
            Assertions.assertTrue((boolean)featureManager.isElrFeatureEnabled());
        } else {
            Assertions.assertEquals((Object)Errors.INVALID_UPDATE_VERSION, (Object)((ApiError)result.response()).error());
        }
    }

    private FeatureControlManager createFeatureControlManager() {
        FeatureControlManager featureControlManager = new FeatureControlManager.Builder().build();
        featureControlManager.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.LATEST_PRODUCTION.featureLevel()));
        return featureControlManager;
    }

    static {
        CONFIGS.put(ConfigResource.Type.BROKER, new ConfigDef().define("foo.bar", ConfigDef.Type.LIST, (Object)"1", ConfigDef.Importance.HIGH, "foo bar").define("baz", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "baz").define("quux", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "quux").define("min.insync.replicas", ConfigDef.Type.INT, (Object)"1", ConfigDef.Importance.HIGH, "min.isr"));
        CONFIGS.put(ConfigResource.Type.TOPIC, new ConfigDef().define("abc", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "abc").define("def", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "def").define("ghi", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.HIGH, "ghi").define("quuux", ConfigDef.Type.LONG, ConfigDef.Importance.HIGH, "quux").define("min.insync.replicas", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, ""));
        SYNONYMS = new HashMap<String, List<ConfigSynonym>>();
        SYNONYMS.put("abc", List.of(new ConfigSynonym("foo.bar")));
        SYNONYMS.put("def", List.of(new ConfigSynonym("baz")));
        SYNONYMS.put("quuux", List.of(new ConfigSynonym("quux", ConfigSynonym.HOURS_TO_MILLISECONDS)));
        SYNONYMS.put("min.insync.replicas", List.of(new ConfigSynonym("min.insync.replicas")));
        SCHEMA = new KafkaConfigSchema(CONFIGS, SYNONYMS);
        BROKER0 = new ConfigResource(ConfigResource.Type.BROKER, "0");
        MYTOPIC = new ConfigResource(ConfigResource.Type.TOPIC, "mytopic");
    }

    static class TestExistenceChecker
    implements Consumer<ConfigResource> {
        static final TestExistenceChecker INSTANCE = new TestExistenceChecker();

        TestExistenceChecker() {
        }

        @Override
        public void accept(ConfigResource resource) {
            if (!resource.name().startsWith("Existing")) {
                throw new UnknownTopicOrPartitionException("Unknown resource.");
            }
        }
    }

    private static class MockAlterConfigsPolicy
    implements AlterConfigPolicy {
        private final List<AlterConfigPolicy.RequestMetadata> expecteds;
        private final AtomicLong index = new AtomicLong(0L);

        MockAlterConfigsPolicy(List<AlterConfigPolicy.RequestMetadata> expecteds) {
            this.expecteds = expecteds;
        }

        public void validate(AlterConfigPolicy.RequestMetadata actual) throws PolicyViolationException {
            long curIndex = this.index.getAndIncrement();
            if (curIndex >= (long)this.expecteds.size()) {
                throw new PolicyViolationException("Unexpected config alteration: index out of range at " + curIndex);
            }
            AlterConfigPolicy.RequestMetadata expected = this.expecteds.get((int)curIndex);
            if (!expected.equals((Object)actual)) {
                throw new PolicyViolationException("Expected: " + String.valueOf(expected) + ". Got: " + String.valueOf(actual));
            }
        }

        public void close() {
        }

        public void configure(Map<String, ?> configs) {
        }
    }

    private static class CheckForNullValuesPolicy
    implements AlterConfigPolicy {
        private CheckForNullValuesPolicy() {
        }

        public void validate(AlterConfigPolicy.RequestMetadata actual) throws PolicyViolationException {
            actual.configs().forEach((key, value) -> {
                if (value == null) {
                    throw new PolicyViolationException("Legacy Alter Configs should not see null values");
                }
            });
        }

        public void close() {
        }

        public void configure(Map<String, ?> configs) {
        }
    }
}

