/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.DuplicateBrokerRegistrationException;
import org.apache.kafka.common.errors.InconsistentClusterIdException;
import org.apache.kafka.common.errors.InvalidRegistrationException;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.ControllerRegistrationRequestData;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.BrokerIdAndEpoch;
import org.apache.kafka.controller.ClusterControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerRegistrationFencingChange;
import org.apache.kafka.metadata.BrokerRegistrationInControlledShutdownChange;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.apache.kafka.metadata.placement.PlacementSpec;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.TestFeatureVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class ClusterControlManagerTest {
    @Test
    public void testReplay() {
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), List.of(Integer.valueOf(0)))).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(1);
        brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord, 100L);
        clusterControl.checkBrokerEpoch(1, 100L);
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> clusterControl.checkBrokerEpoch(1, 101L));
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> clusterControl.checkBrokerEpoch(2, 100L));
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(1));
        BrokerRegistrationChangeRecord changeRecord = new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(100L).setFenced(BrokerRegistrationFencingChange.UNFENCE.value());
        clusterControl.replay(changeRecord);
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(1));
        changeRecord = new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(100L).setFenced(BrokerRegistrationFencingChange.FENCE.value());
        clusterControl.replay(changeRecord);
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(1));
    }

    @Test
    public void testReplayRegisterBrokerRecord() {
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), List.of(Integer.valueOf(0)))).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setFenced(true).setInControlledShutdown(true);
        brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.inControlledShutdown(0));
        brokerRecord.setInControlledShutdown(false);
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        Assertions.assertEquals((long)100L, (long)clusterControl.registerBrokerRecordOffset(brokerRecord.brokerId()).getAsLong());
        brokerRecord.setFenced(false);
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
    }

    @Test
    public void testReplayBrokerRegistrationChangeRecord() {
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), List.of(Integer.valueOf(0)))).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setFenced(false);
        brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertFalse((boolean)clusterControl.inControlledShutdown(0));
        BrokerRegistrationChangeRecord registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setInControlledShutdown(BrokerRegistrationInControlledShutdownChange.IN_CONTROLLED_SHUTDOWN.value());
        clusterControl.replay(registrationChangeRecord);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.inControlledShutdown(0));
        registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(BrokerRegistrationFencingChange.UNFENCE.value());
        clusterControl.replay(registrationChangeRecord);
        Assertions.assertTrue((boolean)clusterControl.isUnfenced(0));
        Assertions.assertTrue((boolean)clusterControl.inControlledShutdown(0));
    }

    @Test
    public void testRegistrationWithIncorrectClusterId() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), List.of(Integer.valueOf(0)))).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        Assertions.assertThrows(InconsistentClusterIdException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("WIjw3grwRZmR2uOpdpVXbg").setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, new FinalizedControllerFeatures(Map.of(), 456L), false));
    }

    private static Stream<Arguments> metadataVersions() {
        return Stream.of(MetadataVersion.MINIMUM_VERSION, MetadataVersion.IBP_3_7_IV2, MetadataVersion.latestTesting()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"metadataVersions"})
    public void testRegisterBrokerRecordVersion(MetadataVersion metadataVersion) {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), List.of(Integer.valueOf(0)))).build();
        featureControl.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(metadataVersion.featureLevel()));
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        List logDirs = metadataVersion.isDirectoryAssignmentSupported() ? List.of(Uuid.fromString((String)"63k9SN1nQOS0dFHSCIMA0A"), Uuid.fromString((String)"Vm1MjsOCR1OjDDydOsDbzg")) : List.of();
        ControllerResult result = clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setLogDirs(logDirs).setRack(null).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Set.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(metadataVersion.featureLevel()).setMaxSupportedVersion(metadataVersion.featureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, new FinalizedControllerFeatures(Map.of("metadata.version", metadataVersion.featureLevel()), 456L), false);
        short expectedVersion = metadataVersion.registerBrokerRecordVersion();
        Assertions.assertEquals(List.of(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(123L).setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")).setFenced(true).setLogDirs(logDirs).setFeatures(new RegisterBrokerRecord.BrokerFeatureCollection(List.of(new RegisterBrokerRecord.BrokerFeature().setName("metadata.version").setMinSupportedVersion(metadataVersion.featureLevel()).setMaxSupportedVersion(metadataVersion.featureLevel())).iterator())).setInControlledShutdown(false), expectedVersion)), (Object)result.records());
    }

    @Test
    public void testUnregister() {
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L).setIncarnationId(Uuid.fromString((String)"fPZv1VBsRFmnlRvmGcOW9w")).setRack("arack");
        brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), List.of(Integer.valueOf(0)))).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        clusterControl.replay(brokerRecord, 100L);
        Assertions.assertEquals((Object)new BrokerRegistration.Builder().setId(1).setEpoch(100L).setIncarnationId(Uuid.fromString((String)"fPZv1VBsRFmnlRvmGcOW9w")).setListeners(Map.of("PLAINTEXT", new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "example.com", 9092))).setRack(Optional.of("arack")).setFenced(true).setInControlledShutdown(false).build(), clusterControl.brokerRegistrations().get(1));
        Assertions.assertEquals((long)100L, (long)clusterControl.registerBrokerRecordOffset(brokerRecord.brokerId()).getAsLong());
        UnregisterBrokerRecord unregisterRecord = new UnregisterBrokerRecord().setBrokerId(1).setBrokerEpoch(100L);
        clusterControl.replay(unregisterRecord);
        Assertions.assertFalse((boolean)clusterControl.brokerRegistrations().containsKey(1));
        Assertions.assertFalse((boolean)clusterControl.registerBrokerRecordOffset(brokerRecord.brokerId()).isPresent());
    }

    @ParameterizedTest
    @ValueSource(ints={3, 10})
    public void testPlaceReplicas(int numUsableBrokers) {
        int i;
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), List.of(Integer.valueOf(0)))).build();
        final ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        for (i = 0; i < numUsableBrokers; ++i) {
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(i);
            brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com"));
            clusterControl.replay(brokerRecord, 100L);
            UnfenceBrokerRecord unfenceRecord = new UnfenceBrokerRecord().setId(i).setEpoch(100L);
            clusterControl.replay(unfenceRecord);
            clusterControl.heartbeatManager().touch(i, false, 0L);
        }
        for (i = 0; i < numUsableBrokers; ++i) {
            Assertions.assertTrue((boolean)clusterControl.isUnfenced(i), (String)String.format("broker %d was not unfenced.", i));
        }
        for (i = 0; i < 100; ++i) {
            List results = clusterControl.replicaPlacer().place(new PlacementSpec(0, 1, 3), new ClusterDescriber(){

                public Iterator<UsableBroker> usableBrokers() {
                    return clusterControl.usableBrokers();
                }

                public Uuid defaultDir(int brokerId) {
                    return DirectoryId.UNASSIGNED;
                }
            }).assignments();
            HashSet<Integer> seen = new HashSet<Integer>();
            for (Integer result : ((PartitionAssignment)results.get(0)).replicas()) {
                Assertions.assertTrue((result >= 0 ? 1 : 0) != 0);
                Assertions.assertTrue((result < numUsableBrokers ? 1 : 0) != 0);
                Assertions.assertTrue((boolean)seen.add(result));
            }
        }
    }

    @Test
    public void testRegistrationsToRecords() {
        int i;
        MetadataVersion metadataVersion = MetadataVersion.MINIMUM_VERSION;
        MockTime time = new MockTime(0L, 0L, 0L);
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultSupportedFeatureMap((boolean)true), List.of(Integer.valueOf(0)))).build();
        featureControl.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(metadataVersion.featureLevel()));
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        Assertions.assertFalse((boolean)clusterControl.isUnfenced(0));
        for (i = 0; i < 3; ++i) {
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(i).setRack(null);
            brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092 + i).setName("PLAINTEXT").setHost("example.com"));
            clusterControl.replay(brokerRecord, 100L);
        }
        for (i = 0; i < 2; ++i) {
            UnfenceBrokerRecord unfenceBrokerRecord = new UnfenceBrokerRecord().setId(i).setEpoch(100L);
            clusterControl.replay(unfenceBrokerRecord);
        }
        BrokerRegistrationChangeRecord registrationChangeRecord = new BrokerRegistrationChangeRecord().setBrokerId(0).setBrokerEpoch(100L).setInControlledShutdown(BrokerRegistrationInControlledShutdownChange.IN_CONTROLLED_SHUTDOWN.value());
        clusterControl.replay(registrationChangeRecord);
        short expectedVersion = metadataVersion.registerBrokerRecordVersion();
        ImageWriterOptions options = new ImageWriterOptions.Builder(metadataVersion).setLossHandler(__ -> {}).build();
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setRack(null).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Set.of(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("example.com")).iterator())).setInControlledShutdown(true).setFenced(false), expectedVersion), (Object)((BrokerRegistration)clusterControl.brokerRegistrations().get(0)).toRecord(options));
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(1).setRack(null).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Set.of(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9093).setName("PLAINTEXT").setHost("example.com")).iterator())).setFenced(false), expectedVersion), (Object)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).toRecord(options));
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(2).setRack(null).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Set.of(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9094).setName("PLAINTEXT").setHost("example.com")).iterator())).setFenced(true), expectedVersion), (Object)((BrokerRegistration)clusterControl.brokerRegistrations().get(2)).toRecord(options));
    }

    @Test
    public void testRegistrationWithUnsupportedFeature() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        HashMap<String, VersionRange> supportedFeatures = new HashMap<String, VersionRange>();
        supportedFeatures.put("metadata.version", VersionRange.of((short)MetadataVersion.MINIMUM_VERSION.featureLevel(), (short)MetadataVersion.IBP_3_7_IV0.featureLevel()));
        supportedFeatures.put("test.feature.version", VersionRange.of((short)TestFeatureVersion.TEST_0.featureLevel(), (short)TestFeatureVersion.TEST_1.featureLevel()));
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, supportedFeatures, List.of(Integer.valueOf(0)))).build();
        featureControl.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_7_IV0.featureLevel()));
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        FeatureLevelRecord testFeatureRecord = new FeatureLevelRecord().setName("test.feature.version").setFeatureLevel((short)1);
        featureControl.replay(testFeatureRecord);
        List<Uuid> logDirs = List.of(Uuid.fromString((String)"yJGxmjfbQZSVFAlNM3uXZg"), Uuid.fromString((String)"Mj3CW3OSRi29cFeNJlXuAQ"));
        BrokerRegistrationRequestData baseRequest = new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")).setLogDirs(logDirs);
        Assertions.assertEquals((Object)"Unable to register because the broker does not support finalized version 1 of test.feature.version. The broker wants a version between 0 and 0, inclusive.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(baseRequest.setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Set.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_7_IV0.featureLevel())).iterator())), 123L, featureControl.finalizedFeatures(Long.MAX_VALUE), false))).getMessage());
    }

    @Test
    public void testRegistrationWithUnsupportedKraftVersion() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        HashMap<String, VersionRange> supportedFeatures = new HashMap<String, VersionRange>();
        supportedFeatures.put("metadata.version", VersionRange.of((short)MetadataVersion.MINIMUM_VERSION.featureLevel(), (short)MetadataVersion.IBP_3_9_IV0.featureLevel()));
        supportedFeatures.put("kraft.version", VersionRange.of((short)KRaftVersion.KRAFT_VERSION_1.featureLevel(), (short)KRaftVersion.KRAFT_VERSION_1.featureLevel()));
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, supportedFeatures, List.of(Integer.valueOf(0)))).build();
        featureControl.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_9_IV0.featureLevel()));
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        List<Uuid> logDirs = List.of(Uuid.fromString((String)"yJGxmjfbQZSVFAlNM3uXZg"), Uuid.fromString((String)"Mj3CW3OSRi29cFeNJlXuAQ"));
        BrokerRegistrationRequestData baseRequest = new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")).setLogDirs(logDirs);
        HashMap<String, Short> updatedFeaturesMap = new HashMap<String, Short>(featureControl.finalizedFeatures(Long.MAX_VALUE).featureMap());
        updatedFeaturesMap.put("kraft.version", KRaftVersion.KRAFT_VERSION_1.featureLevel());
        FinalizedControllerFeatures updatedFinalizedFeatures = new FinalizedControllerFeatures(updatedFeaturesMap, Long.MAX_VALUE);
        Assertions.assertEquals((Object)"Unable to register because the broker does not support finalized version 1 of kraft.version. The broker wants a version between 0 and 0, inclusive.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(baseRequest.setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Set.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.IBP_3_9_IV0.featureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_9_IV0.featureLevel())).iterator())), 123L, updatedFinalizedFeatures, false))).getMessage());
        Assertions.assertEquals((Object)"Unable to register because the broker does not support finalized version 1 of kraft.version. The broker wants a version between 0 and 0, inclusive.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(baseRequest.setFeatures(new BrokerRegistrationRequestData.FeatureCollection(List.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.IBP_3_9_IV0.featureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_9_IV0.featureLevel()), new BrokerRegistrationRequestData.Feature().setName("kraft.version").setMinSupportedVersion(KRaftVersion.KRAFT_VERSION_0.featureLevel()).setMaxSupportedVersion(KRaftVersion.KRAFT_VERSION_0.featureLevel())).iterator())), 123L, updatedFinalizedFeatures, false))).getMessage());
        clusterControl.registerBroker(baseRequest.setFeatures(new BrokerRegistrationRequestData.FeatureCollection(List.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.IBP_3_9_IV0.featureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_9_IV0.featureLevel()), new BrokerRegistrationRequestData.Feature().setName("kraft.version").setMinSupportedVersion(KRaftVersion.KRAFT_VERSION_1.featureLevel()).setMaxSupportedVersion(KRaftVersion.KRAFT_VERSION_1.featureLevel())).iterator())), 123L, updatedFinalizedFeatures, false);
    }

    @Test
    public void testRegistrationWithUnsupportedMetadataVersion() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, Map.of("metadata.version", VersionRange.of((short)MetadataVersion.IBP_3_5_IV0.featureLevel(), (short)MetadataVersion.IBP_3_6_IV0.featureLevel())), List.of(Integer.valueOf(0)))).build();
        featureControl.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_5_IV0.featureLevel()));
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setTime((Time)new MockTime(0L, 0L, 0L)).setSnapshotRegistry(snapshotRegistry).setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        Assertions.assertEquals((Object)"Unable to register because the broker does not support finalized version 9 of metadata.version. The broker wants a version between 7 and 7, inclusive.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Set.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel()).setMaxSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, featureControl.finalizedFeatures(Long.MAX_VALUE), false))).getMessage());
        Assertions.assertEquals((Object)"Unable to register because the broker does not support finalized version 9 of metadata.version. The broker wants a version between 8 and 8, inclusive.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setBrokerId(0).setRack(null).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Set.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.IBP_3_4_IV0.featureLevel()).setMaxSupportedVersion(MetadataVersion.IBP_3_4_IV0.featureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 123L, featureControl.finalizedFeatures(Long.MAX_VALUE), false))).getMessage());
    }

    @Test
    public void testRegisterControlWithUnsupportedMetadataVersion() {
        FeatureControlManager featureControl = new FeatureControlManager.Builder().build();
        featureControl.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_6_IV2.featureLevel()));
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("fPZv1VBsRFmnlRvmGcOW9w").setFeatureControlManager(featureControl).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        Assertions.assertEquals((Object)"The current MetadataVersion is too old to support controller registrations.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> clusterControl.registerController(new ControllerRegistrationRequestData().setControllerId(1)))).getMessage());
    }

    @Test
    public void testRegisterWithDuplicateDirectoryId() {
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("QzZZEtC7SxucRM29Xdzijw").setFeatureControlManager(this.createFeatureControlManager()).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setLogDirs(List.of(Uuid.fromString((String)"yJGxmjfbQZSVFAlNM3uXZg"), Uuid.fromString((String)"Mj3CW3OSRi29cFeNJlXuAQ")));
        brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("127.0.0.1"));
        clusterControl.replay(brokerRecord, 100L);
        clusterControl.activate();
        Assertions.assertDoesNotThrow(() -> this.registerNewBrokerWithDirs(clusterControl, 0, List.of(Uuid.fromString((String)"yJGxmjfbQZSVFAlNM3uXZg"), Uuid.fromString((String)"Mj3CW3OSRi29cFeNJlXuAQ"))), (String)"it should be possible to re-register the same broker with the same directories");
        Assertions.assertEquals((Object)"No directories specified in request", (Object)((InvalidRegistrationException)Assertions.assertThrows(InvalidRegistrationException.class, () -> this.registerNewBrokerWithDirs(clusterControl, 1, List.of()))).getMessage());
        Assertions.assertEquals((Object)"Broker 0 is already registered with directory Mj3CW3OSRi29cFeNJlXuAQ", (Object)((InvalidRegistrationException)Assertions.assertThrows(InvalidRegistrationException.class, () -> this.registerNewBrokerWithDirs(clusterControl, 1, List.of(Uuid.fromString((String)"TyNK6XSSQJaJc2q9uflNHg"), Uuid.fromString((String)"Mj3CW3OSRi29cFeNJlXuAQ"))))).getMessage());
        Assertions.assertEquals((Object)"Reserved directory ID in request", (Object)((InvalidRegistrationException)Assertions.assertThrows(InvalidRegistrationException.class, () -> this.registerNewBrokerWithDirs(clusterControl, 1, List.of(Uuid.fromString((String)"TyNK6XSSQJaJc2q9uflNHg"), DirectoryId.UNASSIGNED)))).getMessage());
        Assertions.assertEquals((Object)"Duplicate directory ID in request", (Object)((InvalidRegistrationException)Assertions.assertThrows(InvalidRegistrationException.class, () -> this.registerNewBrokerWithDirs(clusterControl, 1, List.of(Uuid.fromString((String)"aR6lssMrSeyXRf65hiUovQ"), Uuid.fromString((String)"aR6lssMrSeyXRf65hiUovQ"))))).getMessage());
    }

    void registerNewBrokerWithDirs(ClusterControlManager clusterControl, int brokerId, List<Uuid> dirs) {
        BrokerRegistrationRequestData data = new BrokerRegistrationRequestData().setBrokerId(brokerId).setClusterId(clusterControl.clusterId()).setIncarnationId(new Uuid((long)brokerId, (long)brokerId)).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Set.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel()).setMaxSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel())).iterator())).setLogDirs(dirs);
        FinalizedControllerFeatures finalizedFeatures = new FinalizedControllerFeatures(Map.of("metadata.version", MetadataVersion.MINIMUM_VERSION.featureLevel()), 456L);
        ControllerResult result = clusterControl.registerBroker(data, 123L, finalizedFeatures, false);
        RecordTestUtils.replayAll(clusterControl, result.records());
    }

    @Test
    public void testHasOnlineDir() {
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setFeatureControlManager(this.createFeatureControlManager()).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        this.registerNewBrokerWithDirs(clusterControl, 1, List.of(Uuid.fromString((String)"dir1SEbpRuG1dcpTRGOvJw"), Uuid.fromString((String)"dir2xaEwR2m3JHTiy7PWwA")));
        Assertions.assertTrue((boolean)clusterControl.registration(1).hasOnlineDir(Uuid.fromString((String)"dir1SEbpRuG1dcpTRGOvJw")));
        Assertions.assertTrue((boolean)clusterControl.hasOnlineDir(1, Uuid.fromString((String)"dir1SEbpRuG1dcpTRGOvJw")));
        Assertions.assertTrue((boolean)clusterControl.hasOnlineDir(1, Uuid.fromString((String)"dir2xaEwR2m3JHTiy7PWwA")));
        Assertions.assertTrue((boolean)clusterControl.hasOnlineDir(1, DirectoryId.UNASSIGNED));
        Assertions.assertTrue((boolean)clusterControl.hasOnlineDir(1, DirectoryId.MIGRATING));
        Assertions.assertFalse((boolean)clusterControl.hasOnlineDir(1, Uuid.fromString((String)"otherAA1QFK4U1GWzkjZ5A")));
        Assertions.assertFalse((boolean)clusterControl.hasOnlineDir(77, Uuid.fromString((String)"8xVRVs6UQHGVonA9SRYseQ")));
        Assertions.assertFalse((boolean)clusterControl.hasOnlineDir(1, DirectoryId.LOST));
    }

    @Test
    public void testDefaultDir() {
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setFeatureControlManager(this.createFeatureControlManager()).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(1).setLogDirs(List.of());
        brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost("127.0.0.1"));
        clusterControl.replay(brokerRecord, 100L);
        this.registerNewBrokerWithDirs(clusterControl, 2, List.of(Uuid.fromString((String)"singleOnlineDirectoryA")));
        this.registerNewBrokerWithDirs(clusterControl, 3, List.of(Uuid.fromString((String)"s4fRmyNFSH6J0vI8AVA5ew"), Uuid.fromString((String)"UbtxBcqYSnKUEMcnTyZFWw")));
        Assertions.assertEquals((Object)DirectoryId.MIGRATING, (Object)clusterControl.defaultDir(1));
        Assertions.assertEquals((Object)Uuid.fromString((String)"singleOnlineDirectoryA"), (Object)clusterControl.defaultDir(2));
        Assertions.assertEquals((Object)DirectoryId.UNASSIGNED, (Object)clusterControl.defaultDir(3));
        Assertions.assertEquals((Object)DirectoryId.UNASSIGNED, (Object)clusterControl.defaultDir(4));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testReRegistrationAndBrokerEpoch(boolean newIncarnationId) {
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setFeatureControlManager(this.createFeatureControlManager()).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).build();
        clusterControl.activate();
        FinalizedControllerFeatures finalizedFeatures = new FinalizedControllerFeatures(Map.of("metadata.version", MetadataVersion.MINIMUM_VERSION.featureLevel()), 100L);
        RecordTestUtils.replayAll(clusterControl, clusterControl.registerBroker(new BrokerRegistrationRequestData().setBrokerId(1).setClusterId(clusterControl.clusterId()).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Set.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel()).setMaxSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"mISEfEFwQIuaD1gKCc5tzQ")).setLogDirs(List.of(Uuid.fromString((String)"Vv1gzkM2QpuE-PPrIc6XEw"))), 100L, finalizedFeatures, false).records());
        RecordTestUtils.replayAll(clusterControl, clusterControl.registerBroker(new BrokerRegistrationRequestData().setBrokerId(1).setClusterId(clusterControl.clusterId()).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Set.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel()).setMaxSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel())).iterator())).setIncarnationId(newIncarnationId ? Uuid.fromString((String)"07OOcU7MQFeSmGAFPP2Zww") : Uuid.fromString((String)"mISEfEFwQIuaD1gKCc5tzQ")).setLogDirs(List.of(Uuid.fromString((String)"Vv1gzkM2QpuE-PPrIc6XEw"))), 111L, finalizedFeatures, false).records());
        if (newIncarnationId) {
            Assertions.assertEquals((Object)Uuid.fromString((String)"07OOcU7MQFeSmGAFPP2Zww"), (Object)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).incarnationId());
            Assertions.assertEquals((long)111L, (long)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).epoch());
        } else {
            Assertions.assertEquals((Object)Uuid.fromString((String)"mISEfEFwQIuaD1gKCc5tzQ"), (Object)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).incarnationId());
            Assertions.assertEquals((long)100L, (long)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).epoch());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testReRegistrationWithCleanShutdownDetection(boolean isCleanShutdown) {
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setFeatureControlManager(this.createFeatureControlManager()).setBrokerShutdownHandler((brokerId, cleanShutdown, records) -> {
            if (!cleanShutdown) {
                records.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord(), 2));
            }
        }).build();
        clusterControl.activate();
        FinalizedControllerFeatures finalizedFeatures = new FinalizedControllerFeatures(Map.of("metadata.version", MetadataVersion.MINIMUM_VERSION.featureLevel()), 100L);
        List records2 = clusterControl.registerBroker(new BrokerRegistrationRequestData().setBrokerId(1).setClusterId(clusterControl.clusterId()).setIncarnationId(Uuid.fromString((String)"mISEfEFwQIuaD1gKCc5tzQ")).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Set.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel()).setMaxSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel())).iterator())).setLogDirs(List.of(Uuid.fromString((String)"Vv1gzkM2QpuE-PPrIc6XEw"))), 100L, finalizedFeatures, true).records();
        records2.add(new ApiMessageAndVersion((ApiMessage)new BrokerRegistrationChangeRecord().setBrokerId(1).setBrokerEpoch(100L).setInControlledShutdown(BrokerRegistrationInControlledShutdownChange.IN_CONTROLLED_SHUTDOWN.value()), 1));
        RecordTestUtils.replayAll(clusterControl, records2);
        records2 = clusterControl.registerBroker(new BrokerRegistrationRequestData().setBrokerId(1).setClusterId(clusterControl.clusterId()).setIncarnationId(Uuid.fromString((String)"07OOcU7MQFeSmGAFPP2Zww")).setPreviousBrokerEpoch(isCleanShutdown ? 100L : 10L).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Set.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel()).setMaxSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel())).iterator())).setLogDirs(List.of(Uuid.fromString((String)"Vv1gzkM2QpuE-PPrIc6XEw"))), 111L, finalizedFeatures, true).records();
        RecordTestUtils.replayAll(clusterControl, records2);
        Assertions.assertEquals((Object)Uuid.fromString((String)"07OOcU7MQFeSmGAFPP2Zww"), (Object)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).incarnationId());
        Assertions.assertFalse((boolean)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).inControlledShutdown());
        Assertions.assertEquals((long)111L, (long)((BrokerRegistration)clusterControl.brokerRegistrations().get(1)).epoch());
        if (isCleanShutdown) {
            Assertions.assertEquals((int)1, (int)records2.size());
        } else {
            Assertions.assertEquals((int)2, (int)records2.size());
        }
    }

    @Test
    public void testBrokerContactTimesAreUpdatedOnClusterControlActivation() {
        MockTime time = new MockTime(0L, 20L, 1000L);
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setFeatureControlManager(new FeatureControlManager.Builder().build()).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).setTime((Time)time).build();
        clusterControl.replay(new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setLogDirs(List.of(Uuid.fromString((String)"Mj3CW3OSRi29cFeNJlXuAQ"))), 10002L);
        clusterControl.replay(new RegisterBrokerRecord().setBrokerEpoch(123L).setBrokerId(1).setFenced(false).setLogDirs(List.of(Uuid.fromString((String)"TyNK6XSSQJaJc2q9uflNHg"))), 10005L);
        clusterControl.activate();
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)clusterControl.heartbeatManager().tracker().contactTime(new BrokerIdAndEpoch(0, 100L)));
        Assertions.assertEquals((Object)OptionalLong.of(1000L), (Object)clusterControl.heartbeatManager().tracker().contactTime(new BrokerIdAndEpoch(1, 123L)));
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)clusterControl.heartbeatManager().tracker().contactTime(new BrokerIdAndEpoch(1, 124L)));
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)clusterControl.heartbeatManager().tracker().contactTime(new BrokerIdAndEpoch(2, 100L)));
    }

    @Test
    public void testDuplicateBrokerRegistrationWithActiveOldBroker() {
        long brokerSessionTimeoutMs = 1000L;
        MockTime time = new MockTime(0L, 20L, 1000L);
        FinalizedControllerFeatures finalizedFeatures = new FinalizedControllerFeatures(Map.of("metadata.version", MetadataVersion.LATEST_PRODUCTION.featureLevel()), 456L);
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setFeatureControlManager(this.createFeatureControlManager()).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).setSessionTimeoutNs(TimeUnit.MILLISECONDS.toNanos(brokerSessionTimeoutMs)).setTime((Time)time).build();
        clusterControl.replay(new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setLogDirs(List.of(Uuid.fromString((String)"Mj3CW3OSRi29cFeNJlXuAQ"))).setFenced(false), 10002L);
        clusterControl.activate();
        Assertions.assertEquals((Object)OptionalLong.of(1000L), (Object)clusterControl.heartbeatManager().tracker().contactTime(new BrokerIdAndEpoch(0, 100L)));
        time.sleep(brokerSessionTimeoutMs / 2L);
        Assertions.assertThrows(DuplicateBrokerRegistrationException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setBrokerId(0).setLogDirs(List.of(Uuid.fromString((String)"TyNK6XSSQJaJc2q9uflNHg"))).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Set.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel()).setMaxSupportedVersion(MetadataVersion.LATEST_PRODUCTION.featureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 101L, finalizedFeatures, false));
        time.sleep(brokerSessionTimeoutMs);
        clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setBrokerId(0).setLogDirs(List.of(Uuid.fromString((String)"TyNK6XSSQJaJc2q9uflNHg"))).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Set.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel()).setMaxSupportedVersion(MetadataVersion.LATEST_PRODUCTION.featureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 101L, finalizedFeatures, false);
    }

    @Test
    public void testDuplicateBrokerRegistrationWithInactiveBroker() {
        long brokerSessionTimeoutMs = 1000L;
        MockTime time = new MockTime(0L, 20L, 1000L);
        FinalizedControllerFeatures finalizedFeatures = new FinalizedControllerFeatures(Map.of("metadata.version", MetadataVersion.LATEST_PRODUCTION.featureLevel()), 456L);
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setFeatureControlManager(this.createFeatureControlManager()).setBrokerShutdownHandler((brokerId, isCleanShutdown, records) -> {}).setSessionTimeoutNs(TimeUnit.MILLISECONDS.toNanos(brokerSessionTimeoutMs)).setTime((Time)time).build();
        clusterControl.replay(new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(0).setLogDirs(List.of(Uuid.fromString((String)"Mj3CW3OSRi29cFeNJlXuAQ"))).setFenced(true).setInControlledShutdown(false), 10002L);
        clusterControl.replay(new RegisterBrokerRecord().setBrokerEpoch(200L).setBrokerId(1).setLogDirs(List.of(Uuid.fromString((String)"TyNK6XSSQJaJc2q9uflNHg"))).setFenced(false).setInControlledShutdown(true), 20002L);
        clusterControl.activate();
        clusterControl.heartbeatManager().maybeUpdateControlledShutdownOffset(1, 20002L);
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)clusterControl.heartbeatManager().tracker().contactTime(new BrokerIdAndEpoch(0, 100L)));
        Assertions.assertEquals((Object)OptionalLong.of(1000L), (Object)clusterControl.heartbeatManager().tracker().contactTime(new BrokerIdAndEpoch(1, 200L)));
        time.sleep(brokerSessionTimeoutMs / 2L);
        clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setBrokerId(0).setLogDirs(List.of(Uuid.fromString((String)"yJGxmjfbQZSVFAlNM3uXZg"))).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Set.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel()).setMaxSupportedVersion(MetadataVersion.LATEST_PRODUCTION.featureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"0H4fUu1xQEKXFYwB1aBjhg")), 101L, finalizedFeatures, false);
        Assertions.assertThrows(DuplicateBrokerRegistrationException.class, () -> clusterControl.registerBroker(new BrokerRegistrationRequestData().setClusterId("pjvUwj3ZTEeSVQmUiH3IJw").setBrokerId(1).setLogDirs(List.of(Uuid.fromString((String)"b66ybsWIQoygs01vdjH07A"))).setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Set.of(new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.featureLevel()).setMaxSupportedVersion(MetadataVersion.LATEST_PRODUCTION.featureLevel())).iterator())).setIncarnationId(Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q")), 201L, finalizedFeatures, false));
    }

    private FeatureControlManager createFeatureControlManager() {
        FeatureControlManager featureControlManager = new FeatureControlManager.Builder().build();
        featureControlManager.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.LATEST_PRODUCTION.featureLevel()));
        return featureControlManager;
    }
}

