/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.HashSet;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.BrokerHeartbeatTracker;
import org.apache.kafka.controller.BrokerIdAndEpoch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class BrokerHeartbeatTrackerTest {
    private static final Set<BrokerIdAndEpoch> TEST_BROKERS = Set.of(new BrokerIdAndEpoch(0, 0L), new BrokerIdAndEpoch(1, 100L), new BrokerIdAndEpoch(2, 200L));

    private static BrokerHeartbeatTracker newBrokerHeartbeatTracker() {
        MockTime time = new MockTime(0L, 1000000L, 0L);
        return new BrokerHeartbeatTracker((Time)time, 10000000L);
    }

    @Test
    public void testUpdateContactTime() {
        BrokerHeartbeatTracker tracker = BrokerHeartbeatTrackerTest.newBrokerHeartbeatTracker();
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)tracker.contactTime(new BrokerIdAndEpoch(1, 100L)));
        tracker.updateContactTime(new BrokerIdAndEpoch(1, 100L));
        Assertions.assertEquals((Object)OptionalLong.of(0L), (Object)tracker.contactTime(new BrokerIdAndEpoch(1, 100L)));
    }

    @Test
    public void testMaybeRemoveExpiredWithEmptyTracker() {
        BrokerHeartbeatTracker tracker = BrokerHeartbeatTrackerTest.newBrokerHeartbeatTracker();
        Assertions.assertEquals(Optional.empty(), (Object)tracker.maybeRemoveExpired());
    }

    @Test
    public void testMaybeRemoveExpiredWithAllUpToDate() {
        BrokerHeartbeatTracker tracker = BrokerHeartbeatTrackerTest.newBrokerHeartbeatTracker();
        TEST_BROKERS.forEach(arg_0 -> ((BrokerHeartbeatTracker)tracker).updateContactTime(arg_0));
        Assertions.assertEquals(Optional.empty(), (Object)tracker.maybeRemoveExpired());
    }

    @Test
    public void testMaybeRemoveExpiredWithAllExpired() {
        Optional idAndEpoch;
        BrokerHeartbeatTracker tracker = BrokerHeartbeatTrackerTest.newBrokerHeartbeatTracker();
        TEST_BROKERS.forEach(arg_0 -> ((BrokerHeartbeatTracker)tracker).updateContactTime(arg_0));
        tracker.time().sleep(11L);
        HashSet expired = new HashSet();
        do {
            idAndEpoch = tracker.maybeRemoveExpired();
            idAndEpoch.ifPresent(expired::add);
        } while (idAndEpoch.isPresent());
        Assertions.assertEquals(TEST_BROKERS, expired);
    }

    @Test
    public void testHasValidSessionIsTrueForKnownBroker() {
        BrokerHeartbeatTracker tracker = BrokerHeartbeatTrackerTest.newBrokerHeartbeatTracker();
        TEST_BROKERS.forEach(arg_0 -> ((BrokerHeartbeatTracker)tracker).updateContactTime(arg_0));
        Assertions.assertTrue((boolean)tracker.hasValidSession(new BrokerIdAndEpoch(2, 200L)));
    }

    @Test
    public void testHasValidSessionIsFalseForUnknownBroker() {
        BrokerHeartbeatTracker tracker = BrokerHeartbeatTrackerTest.newBrokerHeartbeatTracker();
        TEST_BROKERS.forEach(arg_0 -> ((BrokerHeartbeatTracker)tracker).updateContactTime(arg_0));
        Assertions.assertFalse((boolean)tracker.hasValidSession(new BrokerIdAndEpoch(3, 300L)));
    }

    @Test
    public void testHasValidSessionIsFalseForUnknownBrokerEpoch() {
        BrokerHeartbeatTracker tracker = BrokerHeartbeatTrackerTest.newBrokerHeartbeatTracker();
        TEST_BROKERS.forEach(arg_0 -> ((BrokerHeartbeatTracker)tracker).updateContactTime(arg_0));
        Assertions.assertFalse((boolean)tracker.hasValidSession(new BrokerIdAndEpoch(2, 100L)));
    }

    @Test
    public void testIsExpiredIsFalseForTheCurrentTime() {
        BrokerHeartbeatTracker tracker = BrokerHeartbeatTrackerTest.newBrokerHeartbeatTracker();
        Assertions.assertFalse((boolean)tracker.isExpired(456L, 456L));
    }

    @Test
    public void testIsExpiredIsFalseForTenNanosecondsAfter() {
        BrokerHeartbeatTracker tracker = BrokerHeartbeatTrackerTest.newBrokerHeartbeatTracker();
        Assertions.assertFalse((boolean)tracker.isExpired(456L, 466L));
    }

    @Test
    public void testIsExpiredIsTrueAfterExpirationTime() {
        BrokerHeartbeatTracker tracker = BrokerHeartbeatTrackerTest.newBrokerHeartbeatTracker();
        Assertions.assertTrue((boolean)tracker.isExpired(456L, 0x989849L));
    }

    @Test
    public void testIsExpiredIsFalseForPreviousTime() {
        BrokerHeartbeatTracker tracker = BrokerHeartbeatTrackerTest.newBrokerHeartbeatTracker();
        Assertions.assertFalse((boolean)tracker.isExpired(456L, 0L));
    }
}

