/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.BrokerControlState;
import org.apache.kafka.controller.BrokerControlStates;
import org.apache.kafka.controller.BrokerHeartbeatManager;
import org.apache.kafka.controller.BrokerIdAndEpoch;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class BrokerHeartbeatManagerTest {
    private static BrokerHeartbeatManager newBrokerHeartbeatManager() {
        LogContext logContext = new LogContext();
        MockTime time = new MockTime(0L, 1000000L, 0L);
        return new BrokerHeartbeatManager(logContext, (Time)time, 10000000L);
    }

    @Test
    public void testHasValidSession() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        MockTime time = (MockTime)manager.time();
        Assertions.assertFalse((boolean)manager.hasValidSession(0, 100L));
        for (int brokerId = 0; brokerId < 3; ++brokerId) {
            manager.register(brokerId, true);
        }
        manager.tracker().updateContactTime(new BrokerIdAndEpoch(0, 100L));
        manager.touch(0, false, 0L);
        time.sleep(5L);
        manager.tracker().updateContactTime(new BrokerIdAndEpoch(1, 100L));
        manager.touch(1, false, 0L);
        manager.tracker().updateContactTime(new BrokerIdAndEpoch(2, 200L));
        manager.touch(2, false, 0L);
        Assertions.assertTrue((boolean)manager.hasValidSession(0, 100L));
        Assertions.assertFalse((boolean)manager.hasValidSession(0, 200L));
        Assertions.assertTrue((boolean)manager.hasValidSession(1, 100L));
        Assertions.assertTrue((boolean)manager.hasValidSession(2, 200L));
        Assertions.assertFalse((boolean)manager.hasValidSession(3, 300L));
    }

    @Test
    public void testMetadataOffsetComparator() {
        TreeSet<BrokerHeartbeatManager.BrokerHeartbeatState> set = new TreeSet<BrokerHeartbeatManager.BrokerHeartbeatState>((Comparator<BrokerHeartbeatManager.BrokerHeartbeatState>)BrokerHeartbeatManager.MetadataOffsetComparator.INSTANCE);
        BrokerHeartbeatManager.BrokerHeartbeatState broker1 = new BrokerHeartbeatManager.BrokerHeartbeatState(1, false, -1L, -1L);
        BrokerHeartbeatManager.BrokerHeartbeatState broker2 = new BrokerHeartbeatManager.BrokerHeartbeatState(2, false, -1L, -1L);
        BrokerHeartbeatManager.BrokerHeartbeatState broker3 = new BrokerHeartbeatManager.BrokerHeartbeatState(3, false, -1L, -1L);
        set.add(broker1);
        set.add(broker2);
        set.add(broker3);
        Iterator iterator = set.iterator();
        Assertions.assertEquals((Object)broker1, iterator.next());
        Assertions.assertEquals((Object)broker2, iterator.next());
        Assertions.assertEquals((Object)broker3, iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertTrue((boolean)set.remove(broker1));
        Assertions.assertTrue((boolean)set.remove(broker2));
        Assertions.assertTrue((boolean)set.remove(broker3));
        Assertions.assertTrue((boolean)set.isEmpty());
        broker1.setMetadataOffset(800L);
        broker2.setMetadataOffset(400L);
        broker3.setMetadataOffset(100L);
        set.add(broker1);
        set.add(broker2);
        set.add(broker3);
        iterator = set.iterator();
        Assertions.assertEquals((Object)broker3, iterator.next());
        Assertions.assertEquals((Object)broker2, iterator.next());
        Assertions.assertEquals((Object)broker1, iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    private static Set<UsableBroker> usableBrokersToSet(BrokerHeartbeatManager manager) {
        HashSet<UsableBroker> brokers = new HashSet<UsableBroker>();
        BrokerHeartbeatManager.UsableBrokerIterator iterator = new BrokerHeartbeatManager.UsableBrokerIterator(manager.brokers().iterator(), id -> id % 2 == 0 ? Optional.of("rack1") : Optional.of("rack2"));
        while (iterator.hasNext()) {
            brokers.add((UsableBroker)iterator.next());
        }
        return brokers;
    }

    @Test
    public void testUsableBrokerIterator() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        Assertions.assertEquals(Set.of(), BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
        for (int brokerId = 0; brokerId < 5; ++brokerId) {
            manager.register(brokerId, true);
        }
        manager.touch(0, false, 100L);
        manager.touch(1, false, 100L);
        manager.touch(2, false, 98L);
        manager.touch(3, false, 100L);
        manager.touch(4, true, 100L);
        Assertions.assertEquals((long)98L, (long)manager.lowestActiveOffset());
        HashSet<UsableBroker> expected = new HashSet<UsableBroker>();
        expected.add(new UsableBroker(0, Optional.of("rack1"), false));
        expected.add(new UsableBroker(1, Optional.of("rack2"), false));
        expected.add(new UsableBroker(2, Optional.of("rack1"), false));
        expected.add(new UsableBroker(3, Optional.of("rack2"), false));
        expected.add(new UsableBroker(4, Optional.of("rack1"), true));
        Assertions.assertEquals(expected, BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
        manager.maybeUpdateControlledShutdownOffset(2, 0L);
        Assertions.assertEquals((long)100L, (long)manager.lowestActiveOffset());
        Assertions.assertThrows(RuntimeException.class, () -> manager.maybeUpdateControlledShutdownOffset(4, 0L));
        manager.touch(4, false, 100L);
        manager.maybeUpdateControlledShutdownOffset(4, 0L);
        expected.remove(new UsableBroker(2, Optional.of("rack1"), false));
        expected.remove(new UsableBroker(4, Optional.of("rack1"), true));
        Assertions.assertEquals(expected, BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
    }

    @Test
    public void testControlledShutdownOffsetIsOnlyUpdatedOnce() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        Assertions.assertEquals(Set.of(), BrokerHeartbeatManagerTest.usableBrokersToSet(manager));
        for (int brokerId = 0; brokerId < 5; ++brokerId) {
            manager.register(brokerId, true);
        }
        manager.touch(0, false, 100L);
        manager.touch(1, false, 100L);
        manager.touch(2, false, 98L);
        manager.touch(3, false, 100L);
        manager.touch(4, true, 100L);
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)manager.controlledShutdownOffset(2));
        manager.maybeUpdateControlledShutdownOffset(2, 98L);
        Assertions.assertEquals((Object)OptionalLong.of(98L), (Object)manager.controlledShutdownOffset(2));
        manager.maybeUpdateControlledShutdownOffset(2, 99L);
        Assertions.assertEquals((Object)OptionalLong.of(98L), (Object)manager.controlledShutdownOffset(2));
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)manager.controlledShutdownOffset(3));
        manager.maybeUpdateControlledShutdownOffset(3, 101L);
        Assertions.assertEquals((Object)OptionalLong.of(101L), (Object)manager.controlledShutdownOffset(3));
        manager.maybeUpdateControlledShutdownOffset(3, 102L);
        Assertions.assertEquals((Object)OptionalLong.of(101L), (Object)manager.controlledShutdownOffset(3));
    }

    @Test
    public void testCalculateNextBrokerState() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        for (int brokerId = 0; brokerId < 6; ++brokerId) {
            manager.register(brokerId, true);
        }
        manager.touch(0, true, 100L);
        manager.touch(1, false, 98L);
        manager.touch(2, false, 100L);
        manager.touch(3, false, 100L);
        manager.touch(4, true, 100L);
        manager.touch(5, false, 99L);
        manager.maybeUpdateControlledShutdownOffset(5, 99L);
        Assertions.assertEquals((long)98L, (long)manager.lowestActiveOffset());
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.FENCED, BrokerControlState.SHUTDOWN_NOW), (Object)manager.calculateNextBrokerState(0, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.FENCED, BrokerControlState.UNFENCED), (Object)manager.calculateNextBrokerState(0, new BrokerHeartbeatRequestData().setWantFence(false).setCurrentMetadataOffset(100L), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.FENCED, BrokerControlState.FENCED), (Object)manager.calculateNextBrokerState(0, new BrokerHeartbeatRequestData().setWantFence(false).setCurrentMetadataOffset(50L), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.FENCED, BrokerControlState.FENCED), (Object)manager.calculateNextBrokerState(0, new BrokerHeartbeatRequestData().setWantFence(true), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.UNFENCED, BrokerControlState.CONTROLLED_SHUTDOWN), (Object)manager.calculateNextBrokerState(1, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> true));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.UNFENCED, BrokerControlState.SHUTDOWN_NOW), (Object)manager.calculateNextBrokerState(1, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.UNFENCED, BrokerControlState.UNFENCED), (Object)manager.calculateNextBrokerState(1, new BrokerHeartbeatRequestData().setWantFence(false), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.CONTROLLED_SHUTDOWN, BrokerControlState.CONTROLLED_SHUTDOWN), (Object)manager.calculateNextBrokerState(5, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> true));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.CONTROLLED_SHUTDOWN, BrokerControlState.CONTROLLED_SHUTDOWN), (Object)manager.calculateNextBrokerState(5, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> false));
        manager.fence(1);
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.CONTROLLED_SHUTDOWN, BrokerControlState.SHUTDOWN_NOW), (Object)manager.calculateNextBrokerState(5, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> false));
        Assertions.assertEquals((Object)new BrokerControlStates(BrokerControlState.CONTROLLED_SHUTDOWN, BrokerControlState.CONTROLLED_SHUTDOWN), (Object)manager.calculateNextBrokerState(5, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> true));
        Assertions.assertEquals((Object)"Broker 6 is not registered.", (Object)((IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> manager.calculateNextBrokerState(6, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> true))).getMessage());
        Assertions.assertEquals((Object)"Broker 7 is not registered.", (Object)((IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> manager.calculateNextBrokerState(7, new BrokerHeartbeatRequestData().setWantShutDown(true), 100L, () -> true))).getMessage());
    }

    @Test
    public void testTouchThrowsExceptionUnlessRegistered() {
        BrokerHeartbeatManager manager = BrokerHeartbeatManagerTest.newBrokerHeartbeatManager();
        manager.register(1, true);
        manager.register(3, true);
        Assertions.assertEquals((Object)"Broker 2 is not registered.", (Object)((IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> manager.touch(2, false, 0L))).getMessage());
        Assertions.assertEquals((Object)"Broker 4 is not registered.", (Object)((IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> manager.touch(4, false, 0L))).getMessage());
    }
}

