/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.controller.ActivationRecordsGenerator;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.EligibleLeaderReplicasVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ActivationRecordsGeneratorTest {
    @Test
    public void testActivationMessageForEmptyLog() {
        ControllerResult result = ActivationRecordsGenerator.recordsForEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. The metadata log appears to be empty. Appending 1 bootstrap record(s) at metadata.version 3.3-IV3 from bootstrap source 'test'.", (Object)logMsg), (long)-1L, (BootstrapMetadata)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.MINIMUM_VERSION, (String)"test"), (MetadataVersion)MetadataVersion.MINIMUM_VERSION, (int)2);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)1, (int)result.records().size());
    }

    @Test
    public void testActivationMessageForEmptyLogAtMv3_4() {
        ControllerResult result = ActivationRecordsGenerator.recordsForEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. The metadata log appears to be empty. Appending 1 bootstrap record(s) at metadata.version 3.4-IV0 from bootstrap source 'test'.", (Object)logMsg), (long)-1L, (BootstrapMetadata)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.IBP_3_4_IV0, (String)"test"), (MetadataVersion)MetadataVersion.IBP_3_4_IV0, (int)2);
        Assertions.assertTrue((boolean)result.isAtomic());
        Assertions.assertEquals((int)1, (int)result.records().size());
    }

    @Test
    public void testActivationMessageForEmptyLogAtMv3_6() {
        ControllerResult result = ActivationRecordsGenerator.recordsForEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. The metadata log appears to be empty. Appending 1 bootstrap record(s) in metadata transaction at metadata.version 3.6-IV1 from bootstrap source 'test'.", (Object)logMsg), (long)-1L, (BootstrapMetadata)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.IBP_3_6_IV1, (String)"test"), (MetadataVersion)MetadataVersion.IBP_3_6_IV1, (int)2);
        Assertions.assertFalse((boolean)result.isAtomic());
        Assertions.assertEquals((int)3, (int)result.records().size());
    }

    @Test
    public void testActivationMessageForEmptyLogAtMv3_6WithTransaction() {
        ControllerResult result = ActivationRecordsGenerator.recordsForEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. Aborting partial bootstrap records transaction at offset 0. Re-appending 1 bootstrap record(s) in new metadata transaction at metadata.version 3.6-IV1 from bootstrap source 'test'.", (Object)logMsg), (long)0L, (BootstrapMetadata)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.IBP_3_6_IV1, (String)"test"), (MetadataVersion)MetadataVersion.IBP_3_6_IV1, (int)2);
        Assertions.assertFalse((boolean)result.isAtomic());
        Assertions.assertEquals((int)4, (int)result.records().size());
    }

    @Test
    public void testActivationMessageForEmptyLogAtMv4_0WithTransactionAndElr() {
        ControllerResult result = ActivationRecordsGenerator.recordsForEmptyLog(logMsg -> Assertions.assertEquals((Object)"Performing controller activation. Aborting partial bootstrap records transaction at offset 0. Re-appending 2 bootstrap record(s) in new metadata transaction at metadata.version 4.0-IV1 from bootstrap source 'test'.", (Object)logMsg), (long)0L, (BootstrapMetadata)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.IBP_4_0_IV1, (String)"test").copyWithFeatureRecord("eligible.leader.replicas.version", EligibleLeaderReplicasVersion.ELRV_1.featureLevel()), (MetadataVersion)MetadataVersion.IBP_4_0_IV1, (int)2);
        Assertions.assertFalse((boolean)result.isAtomic());
        Assertions.assertEquals((int)6, (int)result.records().size());
        Assertions.assertTrue((boolean)result.records().contains(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setName("min.insync.replicas").setValue("2"), 0)));
    }
}

