/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.AclControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclTest;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;
import org.apache.kafka.metadata.authorizer.StandardAclWithIdTest;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.mutable.BoundedListTooLongException;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class AclControlManagerTest {
    @Test
    public void testValidateNewAcl() {
        AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.ALLOW)));
        Assertions.assertEquals((Object)"Invalid patternType UNKNOWN", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.UNKNOWN), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.ALLOW))))).getMessage());
        Assertions.assertEquals((Object)"Invalid resourceType UNKNOWN", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.UNKNOWN, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.ALLOW))))).getMessage());
        Assertions.assertEquals((Object)"Invalid operation UNKNOWN", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.UNKNOWN, AclPermissionType.ALLOW))))).getMessage());
        Assertions.assertEquals((Object)"Invalid permissionType UNKNOWN", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.UNKNOWN))))).getMessage());
    }

    @Test
    public void testValidateAclWithBadPrincipal() {
        Assertions.assertEquals((Object)"Could not parse principal from `invalid` (no colon is present separating the principal type from the principal name)", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("invalid", "*", AclOperation.ALTER, AclPermissionType.ALLOW))))).getMessage());
    }

    @Test
    public void testValidateAclWithEmptyPrincipal() {
        Assertions.assertEquals((Object)"Could not parse principal from `` (no colon is present separating the principal type from the principal name)", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("", "*", AclOperation.ALTER, AclPermissionType.ALLOW))))).getMessage());
    }

    @Test
    public void testValidateFilter() {
        AclControlManager.validateFilter((AclBindingFilter)new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, "*", PatternType.LITERAL), new AccessControlEntryFilter("User:*", "*", AclOperation.ANY, AclPermissionType.ANY)));
        Assertions.assertEquals((Object)"Unknown patternFilter.", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateFilter((AclBindingFilter)new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, "*", PatternType.UNKNOWN), new AccessControlEntryFilter("User:*", "*", AclOperation.ANY, AclPermissionType.ANY))))).getMessage());
        Assertions.assertEquals((Object)"Unknown entryFilter.", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateFilter((AclBindingFilter)new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, "*", PatternType.MATCH), new AccessControlEntryFilter("User:*", "*", AclOperation.ANY, AclPermissionType.UNKNOWN))))).getMessage());
    }

    @Test
    public void testLoadSnapshot() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        snapshotRegistry.idempotentCreateSnapshot(0L);
        AclControlManager manager = new AclControlManager.Builder().setSnapshotRegistry(snapshotRegistry).build();
        HashSet<ApiMessageAndVersion> loadedAcls = new HashSet<ApiMessageAndVersion>();
        for (StandardAclWithId standardAclWithId : StandardAclWithIdTest.TEST_ACLS) {
            AccessControlEntryRecord accessControlEntryRecord = standardAclWithId.toRecord();
            Assertions.assertTrue((boolean)loadedAcls.add(new ApiMessageAndVersion((ApiMessage)accessControlEntryRecord, 0)));
            manager.replay(standardAclWithId.toRecord());
        }
        HashSet<ApiMessageAndVersion> foundAcls = new HashSet<ApiMessageAndVersion>();
        for (Map.Entry entry : manager.idToAcl().entrySet()) {
            foundAcls.add(new ApiMessageAndVersion((ApiMessage)new StandardAclWithId((Uuid)entry.getKey(), (StandardAcl)entry.getValue()).toRecord(), 0));
        }
        Assertions.assertEquals(loadedAcls, foundAcls);
        MockClusterMetadataAuthorizer mockClusterMetadataAuthorizer = new MockClusterMetadataAuthorizer();
        mockClusterMetadataAuthorizer.loadSnapshot(manager.idToAcl());
        Assertions.assertEquals(new HashSet<StandardAcl>(StandardAclTest.TEST_ACLS), new HashSet<StandardAcl>(mockClusterMetadataAuthorizer.acls.values()));
        snapshotRegistry.revertToSnapshot(0L);
        mockClusterMetadataAuthorizer.loadSnapshot(manager.idToAcl());
        Assertions.assertTrue((boolean)manager.idToAcl().isEmpty());
    }

    @Test
    public void testAddAndDelete() {
        AclControlManager manager = new AclControlManager.Builder().build();
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.loadSnapshot(manager.idToAcl());
        manager.replay(StandardAclWithIdTest.TEST_ACLS.get(0).toRecord());
        manager.replay(new RemoveAccessControlEntryRecord().setId(StandardAclWithIdTest.TEST_ACLS.get(0).id()));
        Assertions.assertTrue((boolean)manager.idToAcl().isEmpty());
    }

    @Test
    public void testCreateAclDeleteAcl() {
        int i;
        AclControlManager manager = new AclControlManager.Builder().build();
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.loadSnapshot(manager.idToAcl());
        ArrayList<AclBinding> toCreate = new ArrayList<AclBinding>();
        for (int i2 = 0; i2 < 3; ++i2) {
            toCreate.add(StandardAclWithIdTest.TEST_ACLS.get(i2).toBinding());
        }
        toCreate.add(new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.UNKNOWN), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.ALLOW)));
        ControllerResult createResult = manager.createAcls(toCreate);
        ArrayList<AclCreateResult> expectedResults = new ArrayList<AclCreateResult>();
        for (i = 0; i < 3; ++i) {
            expectedResults.add(AclCreateResult.SUCCESS);
        }
        expectedResults.add(new AclCreateResult((ApiException)new InvalidRequestException("Invalid patternType UNKNOWN")));
        for (i = 0; i < expectedResults.size(); ++i) {
            AclCreateResult expectedResult = (AclCreateResult)expectedResults.get(i);
            if (expectedResult.exception().isPresent()) {
                Assertions.assertEquals((Object)((ApiException)expectedResult.exception().get()).getMessage(), (Object)((ApiException)((AclCreateResult)((List)createResult.response()).get(i)).exception().get()).getMessage());
                continue;
            }
            Assertions.assertFalse((boolean)((AclCreateResult)((List)createResult.response()).get(i)).exception().isPresent());
        }
        RecordTestUtils.replayAll(manager, createResult.records());
        Assertions.assertFalse((boolean)manager.idToAcl().isEmpty());
        ControllerResult deleteResult = manager.deleteAcls(List.of(new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.LITERAL), AccessControlEntryFilter.ANY), new AclBindingFilter(new ResourcePatternFilter(ResourceType.UNKNOWN, null, PatternType.LITERAL), AccessControlEntryFilter.ANY)));
        Assertions.assertEquals((int)2, (int)((List)deleteResult.response()).size());
        HashSet<AclBinding> deleted = new HashSet<AclBinding>();
        for (AclDeleteResult.AclBindingDeleteResult result : ((AclDeleteResult)((List)deleteResult.response()).get(0)).aclBindingDeleteResults()) {
            Assertions.assertEquals(Optional.empty(), (Object)result.exception());
            deleted.add(result.aclBinding());
        }
        Assertions.assertEquals(new HashSet<AclBinding>(List.of(StandardAclWithIdTest.TEST_ACLS.get(0).toBinding(), StandardAclWithIdTest.TEST_ACLS.get(2).toBinding())), deleted);
        Assertions.assertEquals(InvalidRequestException.class, ((ApiException)((AclDeleteResult)((List)deleteResult.response()).get(1)).exception().get()).getClass());
        RecordTestUtils.replayAll(manager, deleteResult.records());
        Iterator iterator = manager.idToAcl().entrySet().iterator();
        Assertions.assertEquals((Object)StandardAclWithIdTest.TEST_ACLS.get(1).acl(), iterator.next().getValue());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testCreateDedupe() {
        AclControlManager manager = new AclControlManager.Builder().build();
        AclBinding aclBinding = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "topic-1", PatternType.LITERAL), new AccessControlEntry("User:user", "10.0.0.1", AclOperation.ALL, AclPermissionType.ALLOW));
        ControllerResult createResult = manager.createAcls(List.of(aclBinding, aclBinding));
        RecordTestUtils.replayAll(manager, createResult.records());
        Assertions.assertEquals((int)1, (int)createResult.records().size());
        Assertions.assertEquals((int)1, (int)manager.idToAcl().size());
        createResult = manager.createAcls(List.of(aclBinding));
        Assertions.assertEquals((int)0, (int)createResult.records().size());
        Assertions.assertEquals((int)1, (int)manager.idToAcl().size());
    }

    @Test
    public void testDeleteDedupe() {
        AclControlManager manager = new AclControlManager.Builder().build();
        AclBinding aclBinding = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "topic-1", PatternType.LITERAL), new AccessControlEntry("User:user", "10.0.0.1", AclOperation.ALL, AclPermissionType.ALLOW));
        ControllerResult createResult = manager.createAcls(List.of(aclBinding));
        RecordTestUtils.replayAll(manager, createResult.records());
        Uuid id = ((AccessControlEntryRecord)((ApiMessageAndVersion)createResult.records().get(0)).message()).id();
        Assertions.assertEquals((int)1, (int)createResult.records().size());
        ControllerResult deleteAclResultsAnyFilter = manager.deleteAcls(List.of(AclBindingFilter.ANY));
        Assertions.assertEquals((int)1, (int)deleteAclResultsAnyFilter.records().size());
        Assertions.assertEquals((Object)id, (Object)((RemoveAccessControlEntryRecord)((ApiMessageAndVersion)deleteAclResultsAnyFilter.records().get(0)).message()).id());
        Assertions.assertEquals((int)1, (int)((List)deleteAclResultsAnyFilter.response()).size());
        ControllerResult deleteAclResultsSpecificFilter = manager.deleteAcls(List.of(aclBinding.toFilter()));
        Assertions.assertEquals((int)1, (int)deleteAclResultsSpecificFilter.records().size());
        Assertions.assertEquals((Object)id, (Object)((RemoveAccessControlEntryRecord)((ApiMessageAndVersion)deleteAclResultsSpecificFilter.records().get(0)).message()).id());
        Assertions.assertEquals((int)1, (int)((List)deleteAclResultsSpecificFilter.response()).size());
        ControllerResult deleteAclResultsBothFilters = manager.deleteAcls(List.of(AclBindingFilter.ANY, aclBinding.toFilter()));
        Assertions.assertEquals((int)1, (int)deleteAclResultsBothFilters.records().size());
        Assertions.assertEquals((Object)id, (Object)((RemoveAccessControlEntryRecord)((ApiMessageAndVersion)deleteAclResultsBothFilters.records().get(0)).message()).id());
        Assertions.assertEquals((int)2, (int)((List)deleteAclResultsBothFilters.response()).size());
    }

    @Test
    public void testDeleteExceedsMaxRecords() {
        AclControlManager manager = new AclControlManager.Builder().build();
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.loadSnapshot(manager.idToAcl());
        ArrayList<AclBinding> firstCreate = new ArrayList<AclBinding>();
        ArrayList<AclBinding> secondCreate = new ArrayList<AclBinding>();
        for (int i = 0; i < 10002; ++i) {
            StandardAclWithId acl = new StandardAclWithId(Uuid.randomUuid(), new StandardAcl(ResourceType.TOPIC, "mytopic_" + i, PatternType.LITERAL, "User:alice", "127.0.0.1", AclOperation.READ, AclPermissionType.ALLOW));
            if (i % 2 == 0) {
                firstCreate.add(acl.toBinding());
                continue;
            }
            secondCreate.add(acl.toBinding());
        }
        ControllerResult firstCreateResult = manager.createAcls(firstCreate);
        Assertions.assertEquals((int)5001, (int)((List)firstCreateResult.response()).size());
        for (Object result : (List)firstCreateResult.response()) {
            Assertions.assertTrue((boolean)result.exception().isEmpty());
        }
        ControllerResult secondCreateResult = manager.createAcls(secondCreate);
        Assertions.assertEquals((int)5001, (int)((List)secondCreateResult.response()).size());
        for (AclCreateResult result : (List)secondCreateResult.response()) {
            Assertions.assertTrue((boolean)result.exception().isEmpty());
        }
        RecordTestUtils.replayAll(manager, firstCreateResult.records());
        RecordTestUtils.replayAll(manager, secondCreateResult.records());
        Assertions.assertFalse((boolean)manager.idToAcl().isEmpty());
        ArrayList<AclBindingFilter> filters = new ArrayList<AclBindingFilter>();
        for (int i = 0; i < 10002; ++i) {
            filters.add(new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "mytopic_" + i, PatternType.LITERAL), AccessControlEntryFilter.ANY));
        }
        Exception exception = (Exception)Assertions.assertThrows(InvalidRequestException.class, () -> manager.deleteAcls((List)filters));
        Assertions.assertEquals(BoundedListTooLongException.class, exception.getCause().getClass());
        Assertions.assertEquals((Object)"Cannot remove more than 10000 acls in a single delete operation.", (Object)exception.getCause().getMessage());
    }

    static class MockClusterMetadataAuthorizer
    implements ClusterMetadataAuthorizer {
        Map<Uuid, StandardAcl> acls = Map.of();

        MockClusterMetadataAuthorizer() {
        }

        public void setAclMutator(AclMutator aclMutator) {
        }

        public AclMutator aclMutatorOrException() {
            throw new NotControllerException("The current node is not the active controller.");
        }

        public void completeInitialLoad() {
        }

        public void completeInitialLoad(Exception e) {
        }

        public void loadSnapshot(Map<Uuid, StandardAcl> acls) {
            this.acls = new HashMap<Uuid, StandardAcl>(acls);
        }

        public void addAcl(Uuid id, StandardAcl acl) {
        }

        public void removeAcl(Uuid id) {
        }

        public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
            return null;
        }

        public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
            return null;
        }

        public Iterable<AclBinding> acls(AclBindingFilter filter) {
            return null;
        }

        public void close() throws IOException {
        }

        public void configure(Map<String, ?> configs) {
        }
    }
}

