/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.metadata.migration.BufferingBatchConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BufferingBatchConsumerTest {
    @Test
    public void testEmptyBatches() {
        ArrayList batches = new ArrayList();
        BufferingBatchConsumer consumer = new BufferingBatchConsumer(batches::add, 4);
        consumer.accept(Collections.emptyList());
        consumer.accept(Collections.emptyList());
        Assertions.assertEquals((int)batches.size(), (int)0);
        consumer.flush();
        Assertions.assertEquals((int)batches.size(), (int)0);
    }

    @Test
    public void testOneBatchSameAsMinSize() {
        ArrayList batches = new ArrayList();
        BufferingBatchConsumer consumer = new BufferingBatchConsumer(batches::add, 4);
        consumer.accept(Arrays.asList(1, 2, 3, 4));
        Assertions.assertEquals((int)batches.size(), (int)1);
        Assertions.assertEquals(batches.get(0), Arrays.asList(1, 2, 3, 4));
        consumer.flush();
        Assertions.assertEquals((int)batches.size(), (int)1);
        Assertions.assertEquals(batches.get(0), Arrays.asList(1, 2, 3, 4));
    }

    @Test
    public void testOneBatchSmallerThanMinSize() {
        ArrayList batches = new ArrayList();
        BufferingBatchConsumer consumer = new BufferingBatchConsumer(batches::add, 4);
        consumer.accept(Arrays.asList(1, 2, 3));
        Assertions.assertEquals((int)batches.size(), (int)0);
        consumer.flush();
        Assertions.assertEquals((int)batches.size(), (int)1);
        Assertions.assertEquals(batches.get(0), Arrays.asList(1, 2, 3));
    }

    @Test
    public void testOneBatchLargerThanMinSize() {
        ArrayList batches = new ArrayList();
        BufferingBatchConsumer consumer = new BufferingBatchConsumer(batches::add, 4);
        consumer.accept(Arrays.asList(1, 2, 3, 4, 5));
        Assertions.assertEquals((int)batches.size(), (int)1);
        Assertions.assertEquals(batches.get(0), Arrays.asList(1, 2, 3, 4, 5));
        consumer.flush();
        Assertions.assertEquals((int)batches.size(), (int)1);
        Assertions.assertEquals(batches.get(0), Arrays.asList(1, 2, 3, 4, 5));
    }

    @Test
    public void testMultiBatchSameAsMinSize() {
        ArrayList batches = new ArrayList();
        BufferingBatchConsumer consumer = new BufferingBatchConsumer(batches::add, 6);
        consumer.accept(Arrays.asList(1, 2));
        consumer.accept(Arrays.asList(3, 4));
        consumer.accept(Arrays.asList(5, 6));
        Assertions.assertEquals((int)batches.size(), (int)1);
        Assertions.assertEquals(batches.get(0), Arrays.asList(1, 2, 3, 4, 5, 6));
        consumer.flush();
        Assertions.assertEquals((int)batches.size(), (int)1);
        Assertions.assertEquals(batches.get(0), Arrays.asList(1, 2, 3, 4, 5, 6));
    }

    @Test
    public void testMultiBatchSmallerThanMinSize() {
        ArrayList batches = new ArrayList();
        BufferingBatchConsumer consumer = new BufferingBatchConsumer(batches::add, 6);
        consumer.accept(Arrays.asList(1, 2));
        consumer.accept(Arrays.asList(3, 4));
        consumer.accept(Collections.singletonList(5));
        Assertions.assertEquals((int)batches.size(), (int)0);
        consumer.flush();
        Assertions.assertEquals((int)batches.size(), (int)1);
        Assertions.assertEquals(batches.get(0), Arrays.asList(1, 2, 3, 4, 5));
    }

    @Test
    public void testMultiBatchLargerThanMinSize() {
        ArrayList batches = new ArrayList();
        BufferingBatchConsumer consumer = new BufferingBatchConsumer(batches::add, 6);
        consumer.accept(Arrays.asList(1, 2));
        consumer.accept(Arrays.asList(3, 4));
        consumer.accept(Arrays.asList(5, 6));
        consumer.accept(Arrays.asList(7, 8));
        consumer.accept(Arrays.asList(9, 10));
        Assertions.assertEquals((int)batches.size(), (int)1);
        Assertions.assertEquals(batches.get(0), Arrays.asList(1, 2, 3, 4, 5, 6));
        consumer.flush();
        Assertions.assertEquals((int)batches.size(), (int)2);
        Assertions.assertEquals(batches.get(0), Arrays.asList(1, 2, 3, 4, 5, 6));
        Assertions.assertEquals(batches.get(1), Arrays.asList(7, 8, 9, 10));
    }
}

