/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.MetricsRegistry;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.junit.jupiter.api.Assertions;

public class ControllerMetricsTestUtils {
    public static void assertMetricsForTypeEqual(MetricsRegistry registry, String expectedPrefix, Set<String> expected) {
        TreeSet actual = new TreeSet();
        registry.allMetrics().forEach((name, __) -> {
            StringBuilder bld = new StringBuilder();
            bld.append(name.getGroup());
            bld.append(":type=").append(name.getType());
            bld.append(",name=").append(name.getName());
            if (bld.toString().startsWith(expectedPrefix)) {
                actual.add(bld.toString());
            }
        });
        Assertions.assertEquals(new TreeSet<String>(expected), actual);
    }

    public static PartitionRegistration fakePartitionRegistration(FakePartitionRegistrationType type) {
        int leader = 0;
        switch (type) {
            case NORMAL: {
                leader = 0;
                break;
            }
            case NON_PREFERRED_LEADER: {
                leader = 1;
                break;
            }
            case OFFLINE: {
                leader = -1;
            }
        }
        return new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{0, 1, 2}).setLeader(Integer.valueOf(leader)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
    }

    public static TopicImage fakeTopicImage(String topicName, Uuid topicId, PartitionRegistration ... registrations) {
        HashMap<Integer, PartitionRegistration> partitions = new HashMap<Integer, PartitionRegistration>();
        int i = 0;
        for (PartitionRegistration registration : registrations) {
            partitions.put(i, registration);
            ++i;
        }
        return new TopicImage(topicName, topicId, partitions);
    }

    public static TopicsImage fakeTopicsImage(TopicImage ... topics) {
        TopicsImage image = TopicsImage.EMPTY;
        for (TopicImage topic : topics) {
            image = image.including(topic);
        }
        return image;
    }

    static enum FakePartitionRegistrationType {
        NORMAL,
        NON_PREFERRED_LEADER,
        OFFLINE;

    }
}

