/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.publisher;

import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.FakeSnapshotWriter;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.image.publisher.SnapshotEmitter;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class SnapshotEmitterTest {
    @Test
    public void testEmit() throws Exception {
        MockRaftClient mockRaftClient = new MockRaftClient();
        MockTime time = new MockTime(0L, 10000L, 20000L);
        SnapshotEmitter emitter = new SnapshotEmitter.Builder().setTime((Time)time).setBatchSize(2).setRaftClient((RaftClient)mockRaftClient).build();
        Assertions.assertEquals((long)0L, (long)emitter.metrics().latestSnapshotGeneratedAgeMs());
        Assertions.assertEquals((long)0L, (long)emitter.metrics().latestSnapshotGeneratedBytes());
        time.sleep(30000L);
        Assertions.assertEquals((long)30000L, (long)emitter.metrics().latestSnapshotGeneratedAgeMs());
        Assertions.assertEquals((long)0L, (long)emitter.metrics().latestSnapshotGeneratedBytes());
        emitter.maybeEmit(MetadataImageTest.IMAGE1);
        Assertions.assertEquals((long)0L, (long)emitter.metrics().latestSnapshotGeneratedAgeMs());
        Assertions.assertEquals((long)1600L, (long)emitter.metrics().latestSnapshotGeneratedBytes());
        FakeSnapshotWriter writer = mockRaftClient.writers.get(MetadataImageTest.IMAGE1.provenance().snapshotId());
        Assertions.assertNotNull((Object)writer);
        Assertions.assertEquals((long)MetadataImageTest.IMAGE1.highestOffsetAndEpoch().offset(), (long)writer.lastContainedLogOffset());
        Assertions.assertEquals((int)MetadataImageTest.IMAGE1.highestOffsetAndEpoch().epoch(), (int)writer.lastContainedLogEpoch());
        Assertions.assertTrue((boolean)writer.isFrozen());
        Assertions.assertTrue((boolean)writer.isClosed());
        emitter.maybeEmit(MetadataImageTest.IMAGE1);
        Assertions.assertEquals((int)1, (int)mockRaftClient.writers.size());
    }

    static class MockRaftClient
    implements RaftClient<ApiMessageAndVersion> {
        TreeMap<OffsetAndEpoch, FakeSnapshotWriter> writers = new TreeMap();

        MockRaftClient() {
        }

        public void initialize() {
        }

        public void register(RaftClient.Listener<ApiMessageAndVersion> listener) {
        }

        public void unregister(RaftClient.Listener<ApiMessageAndVersion> listener) {
        }

        public OptionalLong highWatermark() {
            return OptionalLong.empty();
        }

        public LeaderAndEpoch leaderAndEpoch() {
            return LeaderAndEpoch.UNKNOWN;
        }

        public OptionalInt nodeId() {
            return OptionalInt.empty();
        }

        public long scheduleAppend(int epoch, List<ApiMessageAndVersion> records) {
            return 0L;
        }

        public long scheduleAtomicAppend(int epoch, OptionalLong requiredEndOffset, List<ApiMessageAndVersion> records) {
            return 0L;
        }

        public CompletableFuture<Void> shutdown(int timeoutMs) {
            return CompletableFuture.completedFuture(null);
        }

        public void resign(int epoch) {
        }

        public Optional<SnapshotWriter<ApiMessageAndVersion>> createSnapshot(OffsetAndEpoch snapshotId, long lastContainedLogTime) {
            if (this.writers.containsKey(snapshotId)) {
                return Optional.empty();
            }
            FakeSnapshotWriter writer = new FakeSnapshotWriter(snapshotId);
            this.writers.put(snapshotId, writer);
            return Optional.of(writer);
        }

        public Optional<OffsetAndEpoch> latestSnapshotId() {
            NavigableSet<OffsetAndEpoch> descendingSet = this.writers.descendingKeySet();
            if (descendingSet.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(descendingSet.first());
        }

        public long logEndOffset() {
            return 0L;
        }

        public void close() throws Exception {
        }
    }
}

