/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.ConfigurationImage;
import org.apache.kafka.image.node.ConfigurationImageNode;
import org.apache.kafka.image.node.printer.MetadataNodePrinter;
import org.apache.kafka.image.node.printer.MetadataNodeRedactionCriteria;
import org.apache.kafka.image.node.printer.NodeStringifier;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ConfigurationImageNodeTest {
    private static final MetadataNodeRedactionCriteria NORMAL;
    private static final ConfigurationImageNode NODE;

    @Test
    public void testNonSecretChild() {
        NodeStringifier stringifier = new NodeStringifier(NORMAL);
        NODE.child("non.secret").print((MetadataNodePrinter)stringifier);
        Assertions.assertEquals((Object)"baaz", (Object)stringifier.toString());
    }

    @Test
    public void testSecretChild() {
        NodeStringifier stringifier = new NodeStringifier(NORMAL);
        NODE.child("secret.config").print((MetadataNodePrinter)stringifier);
        Assertions.assertEquals((Object)"[redacted]", (Object)stringifier.toString());
    }

    @Test
    public void testUnknownChild() {
        Assertions.assertNull((Object)NODE.child("also.non.secret"));
    }

    static {
        KafkaConfigSchema schema = new KafkaConfigSchema(Collections.singletonMap(ConfigResource.Type.BROKER, new ConfigDef().define("non.secret", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "baz").define("also.non.secret", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "baz").define("secret.config", ConfigDef.Type.PASSWORD, ConfigDef.Importance.HIGH, "baz")), Collections.emptyMap());
        NORMAL = new MetadataNodeRedactionCriteria.Normal(schema);
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("non.secret", "baaz");
        configs.put("secret.config", "123");
        ConfigurationImage image = new ConfigurationImage(new ConfigResource(ConfigResource.Type.BROKER, ""), configs);
        NODE = new ConfigurationImageNode(image);
    }
}

