/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class TopicsImageTest {
    public static final TopicsImage IMAGE1;
    public static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final TopicsDelta DELTA1;
    static final TopicsImage IMAGE2;
    static final List<TopicImage> TOPIC_IMAGES1;
    public static final Uuid FOO_UUID;
    private static final Uuid BAR_UUID;
    private static final Uuid BAZ_UUID;

    private static TopicImage newTopicImage(String name, Uuid id, PartitionRegistration ... partitions) {
        HashMap<Integer, PartitionRegistration> partitionMap = new HashMap<Integer, PartitionRegistration>();
        int i = 0;
        for (PartitionRegistration partition : partitions) {
            partitionMap.put(i++, partition);
        }
        return new TopicImage(name, id, partitionMap);
    }

    private static ImmutableMap<Uuid, TopicImage> newTopicsByIdMap(Collection<TopicImage> topics) {
        ImmutableMap map = TopicsImage.EMPTY.topicsById();
        for (TopicImage topic : topics) {
            map = map.updated((Object)topic.id(), (Object)topic);
        }
        return map;
    }

    private static ImmutableMap<String, TopicImage> newTopicsByNameMap(Collection<TopicImage> topics) {
        ImmutableMap map = TopicsImage.EMPTY.topicsByName();
        for (TopicImage topic : topics) {
            map = map.updated((Object)topic.name(), (Object)topic);
        }
        return map;
    }

    private ApiMessageAndVersion newPartitionRecord(Uuid topicId, int partitionId, List<Integer> replicas) {
        return new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(partitionId).setTopicId(topicId).setReplicas(replicas).setIsr(replicas).setLeader(replicas.get(0)).setLeaderEpoch(1).setPartitionEpoch(1), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion());
    }

    private PartitionRegistration newPartition(int[] replicas) {
        return new PartitionRegistration.Builder().setReplicas(replicas).setIsr(replicas).setLeader(Integer.valueOf(replicas[0])).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(1)).build();
    }

    @Test
    public void testBasicLocalChanges() {
        int localId = 3;
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>(DELTA1_RECORDS);
        Uuid newFooId = Uuid.fromString((String)"b66ybsWIQoygs01vdjH07A");
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(newFooId), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()));
        topicRecords.add(this.newPartitionRecord(newFooId, 0, Arrays.asList(0, 1, 2)));
        topicRecords.add(this.newPartitionRecord(newFooId, 1, Arrays.asList(0, 1, localId)));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(1).setTopicId(BAZ_UUID).setReplicas(Arrays.asList(4, 2, localId)).setIsr(Arrays.asList(4, 2, localId)).setLeader(4).setLeaderEpoch(2).setPartitionEpoch(1), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(IMAGE1);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("foo", 1))), (Object)changes.deletes());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("baz", 0))), changes.leaders().keySet());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("baz", 1), new TopicPartition("bar", 0), new TopicPartition("foo", 1))), changes.followers().keySet());
        TopicsImage finalImage = delta.apply();
        List<ApiMessageAndVersion> imageRecords = TopicsImageTest.getImageRecords(IMAGE1);
        imageRecords.addAll(topicRecords);
        TopicsImageTest.testToImage(finalImage, Optional.of(imageRecords));
    }

    @Test
    public void testDeleteAfterChanges() {
        int localId = 3;
        Uuid zooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("zoo", zooId, this.newPartition(new int[]{localId, 1, 2})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics));
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(0).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(zooId), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 0))), (Object)changes.deletes());
        Assertions.assertEquals(Collections.emptyMap(), (Object)changes.leaders());
        Assertions.assertEquals(Collections.emptyMap(), (Object)changes.followers());
        TopicsImage finalImage = delta.apply();
        List<ApiMessageAndVersion> imageRecords = TopicsImageTest.getImageRecords(image);
        imageRecords.addAll(topicRecords);
        TopicsImageTest.testToImage(finalImage, Optional.of(imageRecords));
    }

    @Test
    public void testLocalReassignmentChanges() {
        int localId = 3;
        Uuid zooId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        ArrayList<TopicImage> topics = new ArrayList<TopicImage>();
        topics.add(TopicsImageTest.newTopicImage("zoo", zooId, this.newPartition(new int[]{0, 1, localId}), this.newPartition(new int[]{localId, 1, 2}), this.newPartition(new int[]{0, 1, localId}), this.newPartition(new int[]{localId, 1, 2}), this.newPartition(new int[]{0, 1, 2}), this.newPartition(new int[]{0, 1, 2})));
        TopicsImage image = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics), TopicsImageTest.newTopicsByNameMap(topics));
        ArrayList<ApiMessageAndVersion> topicRecords = new ArrayList<ApiMessageAndVersion>();
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(0).setLeader(localId), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(1).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(2).setIsr(Arrays.asList(0, 1, 2)).setReplicas(Arrays.asList(0, 1, 2)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(3).setLeader(0).setIsr(Arrays.asList(0, 1, 2)).setReplicas(Arrays.asList(0, 1, 2)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(4).setLeader(localId).setIsr(Arrays.asList(localId, 1, 2)).setReplicas(Arrays.asList(localId, 1, 2)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        topicRecords.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(zooId).setPartitionId(5).setIsr(Arrays.asList(0, 1, localId)).setReplicas(Arrays.asList(0, 1, localId)), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        TopicsDelta delta = new TopicsDelta(image);
        RecordTestUtils.replayAll(delta, topicRecords);
        LocalReplicaChanges changes = delta.localChanges(localId);
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 2), new TopicPartition("zoo", 3))), (Object)changes.deletes());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 0), new TopicPartition("zoo", 4))), changes.leaders().keySet());
        Assertions.assertEquals(new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("zoo", 1), new TopicPartition("zoo", 5))), changes.followers().keySet());
        TopicsImage finalImage = delta.apply();
        List<ApiMessageAndVersion> imageRecords = TopicsImageTest.getImageRecords(image);
        imageRecords.addAll(topicRecords);
        TopicsImageTest.testToImage(finalImage, Optional.of(imageRecords));
    }

    @Test
    public void testEmptyImageRoundTrip() {
        TopicsImageTest.testToImage(TopicsImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() {
        TopicsImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testApplyDelta1() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
        List<ApiMessageAndVersion> records = TopicsImageTest.getImageRecords(IMAGE1);
        records.addAll(DELTA1_RECORDS);
        TopicsImageTest.testToImage(IMAGE2, records);
    }

    @Test
    public void testImage2RoundTrip() {
        TopicsImageTest.testToImage(IMAGE2);
    }

    private static void testToImage(TopicsImage image) {
        TopicsImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(TopicsImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        TopicsImageTest.testToImage(image, fromRecords.orElseGet(() -> TopicsImageTest.getImageRecords(image)));
    }

    private static void testToImage(TopicsImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<TopicsDelta, TopicsImage>(() -> TopicsImage.EMPTY, TopicsDelta::new).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(TopicsImage image) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        return writer.records();
    }

    @Test
    public void testTopicNameToIdView() {
        Map map = IMAGE1.topicNameToIdView();
        Assertions.assertTrue((boolean)map.containsKey("foo"));
        Assertions.assertEquals((Object)FOO_UUID, map.get("foo"));
        Assertions.assertTrue((boolean)map.containsKey("bar"));
        Assertions.assertEquals((Object)BAR_UUID, map.get("bar"));
        Assertions.assertFalse((boolean)map.containsKey("baz"));
        Assertions.assertNull(map.get("baz"));
        HashSet uuids = new HashSet();
        map.values().iterator().forEachRemaining(u -> uuids.add(u));
        HashSet<Uuid> expectedUuids = new HashSet<Uuid>(Arrays.asList(Uuid.fromString((String)"ThIaNwRnSM2Nt9Mx1v0RvA"), Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw")));
        Assertions.assertEquals(expectedUuids, uuids);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            Uuid cfr_ignored_0 = (Uuid)map.remove("foo");
        });
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put("bar", FOO_UUID));
    }

    @Test
    public void testTopicIdToNameView() {
        Map map = IMAGE1.topicIdToNameView();
        Assertions.assertTrue((boolean)map.containsKey(FOO_UUID));
        Assertions.assertEquals((Object)"foo", map.get(FOO_UUID));
        Assertions.assertTrue((boolean)map.containsKey(BAR_UUID));
        Assertions.assertEquals((Object)"bar", map.get(BAR_UUID));
        Assertions.assertFalse((boolean)map.containsKey(BAZ_UUID));
        Assertions.assertNull(map.get(BAZ_UUID));
        HashSet names = new HashSet();
        map.values().iterator().forEachRemaining(n -> names.add(n));
        HashSet<String> expectedNames = new HashSet<String>(Arrays.asList("foo", "bar"));
        Assertions.assertEquals(expectedNames, names);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            String cfr_ignored_0 = (String)map.remove(FOO_UUID);
        });
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put(FOO_UUID, "bar"));
    }

    static {
        FOO_UUID = Uuid.fromString((String)"ThIaNwRnSM2Nt9Mx1v0RvA");
        BAR_UUID = Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw");
        BAZ_UUID = Uuid.fromString((String)"tgHBnRglT5W_RlENnuG5vg");
        TOPIC_IMAGES1 = Arrays.asList(TopicsImageTest.newTopicImage("foo", FOO_UUID, new PartitionRegistration.Builder().setReplicas(new int[]{2, 3, 4}).setIsr(new int[]{2, 3}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(345)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{3, 4, 5}).setIsr(new int[]{3, 4, 5}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(4)).setPartitionEpoch(Integer.valueOf(684)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{2, 4, 5}).setIsr(new int[]{2, 4, 5}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(10)).setPartitionEpoch(Integer.valueOf(84)).build()), TopicsImageTest.newTopicImage("bar", BAR_UUID, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2, 3, 4}).setIsr(new int[]{0, 1, 2, 3}).setRemovingReplicas(new int[]{1}).setAddingReplicas(new int[]{3, 4}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(345)).build()));
        IMAGE1 = new TopicsImage(TopicsImageTest.newTopicsByIdMap(TOPIC_IMAGES1), TopicsImageTest.newTopicsByNameMap(TOPIC_IMAGES1));
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RemoveTopicRecord().setTopicId(FOO_UUID), MetadataRecordType.REMOVE_TOPIC_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(BAR_UUID).setPartitionId(0).setLeader(1), MetadataRecordType.PARTITION_CHANGE_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("baz").setTopicId(BAZ_UUID), MetadataRecordType.TOPIC_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(BAZ_UUID).setReplicas(Arrays.asList(1, 2, 3, 4)).setIsr(Arrays.asList(3, 4)).setRemovingReplicas(Collections.singletonList(2)).setAddingReplicas(Collections.singletonList(1)).setLeader(3).setLeaderEpoch(2).setPartitionEpoch(1), MetadataRecordType.PARTITION_RECORD.highestSupportedVersion()));
        DELTA1 = new TopicsDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        List<TopicImage> topics2 = Arrays.asList(TopicsImageTest.newTopicImage("bar", BAR_UUID, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2, 3, 4}).setIsr(new int[]{0, 1, 2, 3}).setRemovingReplicas(new int[]{1}).setAddingReplicas(new int[]{3, 4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(2)).setPartitionEpoch(Integer.valueOf(346)).build()), TopicsImageTest.newTopicImage("baz", BAZ_UUID, new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setIsr(new int[]{3, 4}).setRemovingReplicas(new int[]{2}).setAddingReplicas(new int[]{1}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(2)).setPartitionEpoch(Integer.valueOf(1)).build()));
        IMAGE2 = new TopicsImage(TopicsImageTest.newTopicsByIdMap(topics2), TopicsImageTest.newTopicsByNameMap(topics2));
    }
}

