/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.ControllerMetricsTestUtils;
import org.apache.kafka.controller.metrics.QuorumControllerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class QuorumControllerMetricsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testMetricNames(boolean inMigration) {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        try {
            try (QuorumControllerMetrics metrics = new QuorumControllerMetrics(Optional.of(registry), (Time)time, inMigration);){
                HashSet<String> expected = new HashSet<String>(Arrays.asList("kafka.controller:type=ControllerEventManager,name=EventQueueProcessingTimeMs", "kafka.controller:type=ControllerEventManager,name=EventQueueTimeMs", "kafka.controller:type=KafkaController,name=ActiveControllerCount", "kafka.controller:type=KafkaController,name=EventQueueOperationsStartedCount", "kafka.controller:type=KafkaController,name=EventQueueOperationsTimedOutCount", "kafka.controller:type=KafkaController,name=LastAppliedRecordLagMs", "kafka.controller:type=KafkaController,name=LastAppliedRecordOffset", "kafka.controller:type=KafkaController,name=LastAppliedRecordTimestamp", "kafka.controller:type=KafkaController,name=LastCommittedRecordOffset", "kafka.controller:type=KafkaController,name=NewActiveControllersCount", "kafka.controller:type=KafkaController,name=TimedOutBrokerHeartbeatCount"));
                if (inMigration) {
                    expected.add("kafka.controller:type=KafkaController,name=ZkWriteBehindLag");
                    expected.add("kafka.controller:type=KafkaController,name=ZkWriteSnapshotTimeMs");
                    expected.add("kafka.controller:type=KafkaController,name=ZkWriteDeltaTimeMs");
                }
                ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.controller", expected);
            }
            ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.controller", Collections.emptySet());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateEventQueueTime() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        try (QuorumControllerMetrics metrics = new QuorumControllerMetrics(Optional.of(registry), (Time)time, false);){
            metrics.updateEventQueueTime(1000L);
            QuorumControllerMetricsTest.assertMetricHistogram(registry, QuorumControllerMetricsTest.metricName("ControllerEventManager", "EventQueueTimeMs"), 1L, 1000.0);
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateEventQueueProcessingTime() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        try (QuorumControllerMetrics metrics = new QuorumControllerMetrics(Optional.of(registry), (Time)time, false);){
            metrics.updateEventQueueProcessingTime(1000L);
            QuorumControllerMetricsTest.assertMetricHistogram(registry, QuorumControllerMetricsTest.metricName("ControllerEventManager", "EventQueueProcessingTimeMs"), 1L, 1000.0);
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastAppliedRecordMetrics() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        time.sleep(1000L);
        try (QuorumControllerMetrics metrics = new QuorumControllerMetrics(Optional.of(registry), (Time)time, true);){
            int i;
            metrics.setLastAppliedRecordOffset(100L);
            metrics.setLastAppliedRecordTimestamp(500L);
            metrics.setLastCommittedRecordOffset(50L);
            metrics.updateDualWriteOffset(40L);
            for (i = 0; i < 2; ++i) {
                metrics.incrementTimedOutHeartbeats();
            }
            for (i = 0; i < 3; ++i) {
                metrics.incrementOperationsStarted();
            }
            for (i = 0; i < 4; ++i) {
                metrics.incrementOperationsTimedOut();
            }
            for (i = 0; i < 5; ++i) {
                metrics.incrementNewActiveControllers();
            }
            Gauge lastAppliedRecordOffset = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastAppliedRecordOffset"));
            Assertions.assertEquals((long)100L, (Long)((Long)lastAppliedRecordOffset.value()));
            Gauge lastAppliedRecordTimestamp = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastAppliedRecordTimestamp"));
            Assertions.assertEquals((long)500L, (Long)((Long)lastAppliedRecordTimestamp.value()));
            Gauge lastAppliedRecordLagMs = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastAppliedRecordLagMs"));
            Assertions.assertEquals((long)(time.milliseconds() - 500L), (Long)((Long)lastAppliedRecordLagMs.value()));
            Gauge lastCommittedRecordOffset = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "LastCommittedRecordOffset"));
            Assertions.assertEquals((long)50L, (Long)((Long)lastCommittedRecordOffset.value()));
            Gauge zkWriteBehindLag = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "ZkWriteBehindLag"));
            Assertions.assertEquals((long)10L, (Long)((Long)zkWriteBehindLag.value()));
            Gauge timedOutBrokerHeartbeats = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "TimedOutBrokerHeartbeatCount"));
            Assertions.assertEquals((long)2L, (Long)((Long)timedOutBrokerHeartbeats.value()));
            Gauge operationsStarted = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "EventQueueOperationsStartedCount"));
            Assertions.assertEquals((long)3L, (Long)((Long)operationsStarted.value()));
            Gauge operationsTimedOut = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "EventQueueOperationsTimedOutCount"));
            Assertions.assertEquals((long)4L, (Long)((Long)operationsTimedOut.value()));
            Gauge newActiveControllers = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "NewActiveControllersCount"));
            Assertions.assertEquals((long)5L, (Long)((Long)newActiveControllers.value()));
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateZKWriteBehindLag() {
        Gauge zkWriteBehindLag2;
        Throwable throwable;
        QuorumControllerMetrics metrics;
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        try {
            metrics = new QuorumControllerMetrics(Optional.of(registry), (Time)time, true);
            throwable = null;
            try {
                metrics.updateDualWriteOffset(0L);
                zkWriteBehindLag2 = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "ZkWriteBehindLag"));
                Assertions.assertEquals((long)0L, (Long)((Long)zkWriteBehindLag2.value()));
            }
            catch (Throwable zkWriteBehindLag2) {
                throwable = zkWriteBehindLag2;
                throw zkWriteBehindLag2;
            }
            finally {
                if (metrics != null) {
                    if (throwable != null) {
                        try {
                            metrics.close();
                        }
                        catch (Throwable zkWriteBehindLag2) {
                            throwable.addSuppressed(zkWriteBehindLag2);
                        }
                    } else {
                        metrics.close();
                    }
                }
            }
        }
        finally {
            registry.shutdown();
        }
        try {
            metrics = new QuorumControllerMetrics(Optional.of(registry), (Time)time, true);
            throwable = null;
            try {
                metrics.updateDualWriteOffset(90L);
                metrics.setLastCommittedRecordOffset(100L);
                zkWriteBehindLag2 = (Gauge)registry.allMetrics().get(QuorumControllerMetricsTest.metricName("KafkaController", "ZkWriteBehindLag"));
                Assertions.assertEquals((long)10L, (Long)((Long)zkWriteBehindLag2.value()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (metrics != null) {
                    if (throwable != null) {
                        try {
                            metrics.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        metrics.close();
                    }
                }
            }
        }
        finally {
            registry.shutdown();
        }
    }

    private static void assertMetricHistogram(MetricsRegistry registry, MetricName metricName, long count, double sum) {
        Histogram histogram = (Histogram)registry.allMetrics().get(metricName);
        Assertions.assertEquals((long)count, (long)histogram.count());
        Assertions.assertEquals((double)sum, (double)histogram.sum(), (double)0.1);
    }

    private static MetricName metricName(String type, String name) {
        String mBeanName = String.format("kafka.controller:type=%s,name=%s", type, name);
        return new MetricName("kafka.controller", type, name, null, mBeanName);
    }
}

