/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node.printer;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.node.printer.MetadataNodeRedactionCriteria;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MetadataNodeRedactionCriteriaTest {
    private static final MetadataNodeRedactionCriteria.Strict STRICT;
    private static final MetadataNodeRedactionCriteria.Normal NORMAL;
    private static final MetadataNodeRedactionCriteria.Disabled DISABLED;

    @Test
    public void testStrictRedactsScram() {
        Assertions.assertTrue((boolean)STRICT.shouldRedactScram());
    }

    @Test
    public void testNormalRedactsScram() {
        Assertions.assertTrue((boolean)NORMAL.shouldRedactScram());
    }

    @Test
    public void testDisabledDoesNotRedactScram() {
        Assertions.assertFalse((boolean)DISABLED.shouldRedactScram());
    }

    @Test
    public void testStrictRedactsNonSensitiveConfig() {
        Assertions.assertTrue((boolean)STRICT.shouldRedactConfig(ConfigResource.Type.BROKER, "non.secret"));
    }

    @Test
    public void testNormalDoesNotRedactNonSensitiveConfig() {
        Assertions.assertFalse((boolean)NORMAL.shouldRedactConfig(ConfigResource.Type.BROKER, "non.secret"));
    }

    @Test
    public void testDisabledDoesNotRedactNonSensitiveConfig() {
        Assertions.assertFalse((boolean)DISABLED.shouldRedactConfig(ConfigResource.Type.BROKER, "non.secret"));
    }

    @Test
    public void testStrictRedactsSensitiveConfig() {
        Assertions.assertTrue((boolean)STRICT.shouldRedactConfig(ConfigResource.Type.BROKER, "secret.config"));
    }

    @Test
    public void testNormalDoesRedactsSensitiveConfig() {
        Assertions.assertTrue((boolean)NORMAL.shouldRedactConfig(ConfigResource.Type.BROKER, "secret.config"));
    }

    @Test
    public void testDisabledDoesNotRedactSensitiveConfig() {
        Assertions.assertFalse((boolean)DISABLED.shouldRedactConfig(ConfigResource.Type.BROKER, "secret.config"));
    }

    @Test
    public void testStrictRedactsUnknownConfig() {
        Assertions.assertTrue((boolean)STRICT.shouldRedactConfig(ConfigResource.Type.BROKER, "unknown.config"));
    }

    @Test
    public void testNormalDoesRedactsUnknownConfig() {
        Assertions.assertTrue((boolean)NORMAL.shouldRedactConfig(ConfigResource.Type.BROKER, "unknown.config"));
    }

    @Test
    public void testDisabledDoesNotRedactUnknownConfig() {
        Assertions.assertFalse((boolean)DISABLED.shouldRedactConfig(ConfigResource.Type.BROKER, "unknown.config"));
    }

    static {
        HashMap<ConfigResource.Type, ConfigDef> configs = new HashMap<ConfigResource.Type, ConfigDef>();
        configs.put(ConfigResource.Type.BROKER, new ConfigDef().define("non.secret", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "baz").define("secret.config", ConfigDef.Type.PASSWORD, ConfigDef.Importance.HIGH, "baz"));
        configs.put(ConfigResource.Type.TOPIC, new ConfigDef().define("topic.secret.config", ConfigDef.Type.PASSWORD, ConfigDef.Importance.HIGH, "abc"));
        KafkaConfigSchema schema = new KafkaConfigSchema(configs, Collections.emptyMap());
        STRICT = MetadataNodeRedactionCriteria.Strict.INSTANCE;
        NORMAL = new MetadataNodeRedactionCriteria.Normal(schema);
        DISABLED = MetadataNodeRedactionCriteria.Disabled.INSTANCE;
    }
}

