/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.metadata.migration.AclMigrationClient;
import org.apache.kafka.metadata.migration.CapturingAclMigrationClient;
import org.apache.kafka.metadata.migration.CapturingConfigMigrationClient;
import org.apache.kafka.metadata.migration.CapturingTopicMigrationClient;
import org.apache.kafka.metadata.migration.ConfigMigrationClient;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;

class CapturingMigrationClient
implements MigrationClient {
    private final Set<Integer> brokerIds;
    private final TopicMigrationClient topicMigrationClient;
    private final ConfigMigrationClient configMigrationClient;
    private final AclMigrationClient aclMigrationClient;
    private ZkMigrationLeadershipState state = null;

    static Builder newBuilder() {
        return new Builder();
    }

    CapturingMigrationClient(Set<Integer> brokerIdsInZk, TopicMigrationClient topicMigrationClient, ConfigMigrationClient configMigrationClient, AclMigrationClient aclMigrationClient) {
        this.brokerIds = brokerIdsInZk;
        this.topicMigrationClient = topicMigrationClient;
        this.configMigrationClient = configMigrationClient;
        this.aclMigrationClient = aclMigrationClient;
    }

    public ZkMigrationLeadershipState getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState initialState) {
        if (this.state == null) {
            this.state = initialState;
        }
        return this.state;
    }

    public ZkMigrationLeadershipState setMigrationRecoveryState(ZkMigrationLeadershipState state) {
        this.state = state;
        return state;
    }

    public ZkMigrationLeadershipState claimControllerLeadership(ZkMigrationLeadershipState state) {
        this.state = state;
        return state;
    }

    public ZkMigrationLeadershipState releaseControllerLeadership(ZkMigrationLeadershipState state) {
        this.state = state;
        return state;
    }

    public TopicMigrationClient topicClient() {
        return this.topicMigrationClient;
    }

    public ConfigMigrationClient configClient() {
        return this.configMigrationClient;
    }

    public AclMigrationClient aclClient() {
        return this.aclMigrationClient;
    }

    public Optional<ProducerIdsBlock> readProducerId() {
        return Optional.empty();
    }

    public ZkMigrationLeadershipState writeProducerId(long nextProducerId, ZkMigrationLeadershipState state) {
        this.state = state;
        return state;
    }

    public void readAllMetadata(Consumer<List<ApiMessageAndVersion>> batchConsumer, Consumer<Integer> brokerIdConsumer) {
    }

    public Set<Integer> readBrokerIds() {
        return this.brokerIds;
    }

    public static class Builder {
        Set<Integer> brokersInZk = Collections.emptySet();
        TopicMigrationClient topicMigrationClient = new CapturingTopicMigrationClient();
        ConfigMigrationClient configMigrationClient = new CapturingConfigMigrationClient();
        AclMigrationClient aclMigrationClient = new CapturingAclMigrationClient();

        public Builder setBrokersInZk(int ... brokerIds) {
            this.brokersInZk = IntStream.of(brokerIds).boxed().collect(Collectors.toSet());
            return this;
        }

        public Builder setTopicMigrationClient(TopicMigrationClient topicMigrationClient) {
            this.topicMigrationClient = topicMigrationClient;
            return this;
        }

        public Builder setConfigMigrationClient(ConfigMigrationClient configMigrationClient) {
            this.configMigrationClient = configMigrationClient;
            return this;
        }

        public Builder setAclMigrationClient(AclMigrationClient aclMigrationClient) {
            this.aclMigrationClient = aclMigrationClient;
            return this;
        }

        public CapturingMigrationClient build() {
            return new CapturingMigrationClient(this.brokersInZk, this.topicMigrationClient, this.configMigrationClient, this.aclMigrationClient);
        }
    }
}

